/*
 * Decompiled with CFR 0.152.
 */
package stallone.mc;

import stallone.api.algebra.Algebra;
import stallone.api.algebra.IEigenvalueDecomposition;
import stallone.api.complex.IComplexArray;
import stallone.api.doubles.Doubles;
import stallone.api.doubles.IDoubleArray;
import stallone.api.mc.IMarkovPropagator;

public final class RateMatrixPropagator
implements IMarkovPropagator {
    private IDoubleArray K;
    private boolean reversible;
    private IDoubleArray R;
    private IDoubleArray L;
    private IDoubleArray evalReal;

    public RateMatrixPropagator(IDoubleArray _K) {
        this.set(_K);
    }

    @Override
    public void set(IDoubleArray _K) {
        this.K = _K;
        IEigenvalueDecomposition evd = Algebra.util.evd(_K);
        IComplexArray evComplex = evd.getEval();
        if (evComplex.isReal()) {
            this.evalReal = evComplex;
            this.L = evd.getLeftEigenvectorMatrix();
            this.R = evd.getRightEigenvectorMatrix();
        } else {
            this.reversible = false;
        }
    }

    @Override
    public IDoubleArray propagate(double t) {
        IDoubleArray evalPower;
        IDoubleArray res = null;
        if (this.reversible) {
            evalPower = Doubles.create.array(this.evalReal.size());
            int i = 0;
            while (i < evalPower.size()) {
                evalPower.set(i, Math.pow(this.evalReal.get(i), t));
                ++i;
            }
        } else {
            throw new IllegalArgumentException("Trying to use a nonreversible rate matrix propagator. This is not implemented yet.");
        }
        IDoubleArray D = Doubles.create.diag(evalPower);
        res = Algebra.util.product(this.R, Algebra.util.product(D, this.L));
        return res;
    }
}

