/*
 * Decompiled with CFR 0.152.
 */
package stallone.mc;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import stallone.api.algebra.Algebra;
import stallone.api.algebra.IEigenvalueDecomposition;
import stallone.api.complex.IComplexArray;
import stallone.api.doubles.Doubles;
import stallone.api.doubles.IDoubleArray;
import stallone.api.ints.IIntArray;
import stallone.api.ints.IIntList;
import stallone.api.ints.Ints;
import stallone.graph.MatrixIntGraph;
import stallone.graph.connectivity.IntStrongConnectivity;

public class StationaryDistribution {
    IDoubleArray T = null;
    boolean reversible = false;
    IDoubleArray pi = null;
    List<IIntArray> components = null;
    List<IDoubleArray> componentsPi = null;

    public void setT(IDoubleArray _T) {
        this.T = _T;
    }

    public void setK(IDoubleArray _K) {
        this.T = _K.copy();
        int i = 0;
        while (i < this.T.size()) {
            this.T.set(i, i, this.T.get(i, i) + 1.0);
            ++i;
        }
    }

    public void setReversible(boolean rev) {
        this.reversible = rev;
    }

    private boolean componentIsClosed(IIntArray C) {
        int i = 0;
        while (i < C.size()) {
            int s = C.get(i);
            int j = 0;
            while (j < this.T.columns()) {
                if (this.T.get(s, j) > 0.0 && !Ints.util.contains(C, j)) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    private boolean mergeZeroComponent(List<IIntList> C) {
        int cfrom = -1;
        int cto = -1;
        int c = 0;
        while (c < C.size()) {
            int i = 0;
            while (i < C.get(c).size()) {
                int s1 = C.get(c).get(i);
                int s2 = 0;
                while (s2 < this.T.columns()) {
                    if (this.T.get(s1, s2) > 0.0 && !Ints.util.contains(C.get(c), s2)) {
                        cfrom = c;
                        int c2 = 0;
                        while (c2 < C.size()) {
                            if (Ints.util.contains(C.get(c2), s2)) {
                                cto = c2;
                            }
                            ++c2;
                        }
                        break;
                    }
                    if (cfrom > -1) break;
                    ++s2;
                }
                if (cfrom > -1) break;
                ++i;
            }
            ++c;
        }
        if (cfrom == -1) {
            return false;
        }
        C.get(cto).appendAll(C.get(cfrom));
        C.remove(cfrom);
        return true;
    }

    private void calculateComponents() {
        MatrixIntGraph g = new MatrixIntGraph(this.T);
        IntStrongConnectivity connectivity = new IntStrongConnectivity(g);
        connectivity.perform();
        List<IIntArray> C = connectivity.getStrongComponents();
        IIntArray complengths = Ints.create.array(C.size());
        int i = 0;
        while (i < complengths.size()) {
            complengths.set(i, C.get(i).size());
            ++i;
        }
        IIntArray I = Ints.util.sortedIndexes(complengths);
        Ints.util.mirror(I);
        C = Ints.util.subset(C, I);
        this.components = C;
        this.componentsPi = new ArrayList<IDoubleArray>(this.components.size());
        int i2 = 0;
        while (i2 < C.size()) {
            this.componentsPi.add(null);
            ++i2;
        }
    }

    public IDoubleArray calculate() {
        this.pi = Doubles.create.array(this.T.rows());
        this.calculateComponents();
        int c = 0;
        while (c < this.components.size()) {
            IDoubleArray Tsub = this.T.view(this.components.get(c).getArray(), this.components.get(c).getArray()).copy();
            int i = 0;
            while (i < Tsub.rows()) {
                IDoubleArray row = Tsub.viewRow(i);
                Algebra.util.scale(1.0 / Doubles.util.sum(row), row);
                ++i;
            }
            if (this.componentIsClosed(this.components.get(c))) {
                IDoubleArray pisub = this.calculateSub(Tsub);
                this.componentsPi.set(c, pisub);
                int i2 = 0;
                while (i2 < pisub.size()) {
                    int s = this.components.get(c).get(i2);
                    this.pi.set(s, pisub.get(i2));
                    ++i2;
                }
            }
            ++c;
        }
        return this.pi;
    }

    private IDoubleArray calculateSub(IDoubleArray Tsub) {
        IDoubleArray pisub = null;
        pisub = !this.reversible ? this.calculateSubGeneral(Tsub) : this.calculateSubReversible(Tsub);
        return pisub;
    }

    private IDoubleArray calculateSubGeneral(IDoubleArray Tsub) {
        IEigenvalueDecomposition evd = Algebra.util.evd(Tsub, true, false);
        evd.sortNormDescending();
        IComplexArray l1 = evd.getLeftEigenvector(0).copy();
        Algebra.util.scale(1.0 / Doubles.util.sum(l1), (IDoubleArray)l1);
        return l1;
    }

    private IDoubleArray calculateSubReversible(IDoubleArray Tsubrev) {
        IDoubleArray pisub = Doubles.create.array(Tsubrev.rows());
        pisub.set(0, 1.0);
        boolean[] done = new boolean[Tsubrev.rows()];
        done[0] = true;
        LinkedList<Integer> todo = new LinkedList<Integer>();
        todo.add(0);
        while (todo.size() > 0) {
            int i = (Integer)todo.get(0);
            int j = 0;
            while (j < Tsubrev.columns()) {
                if (i != j && Tsubrev.get(i, j) > 0.0 && !done[j]) {
                    this.pi.set(j, this.pi.get(i) * Tsubrev.get(i, j) / Tsubrev.get(j, i));
                    todo.add(j);
                    done[j] = true;
                }
                ++j;
            }
            todo.remove(0);
        }
        Algebra.util.scale(1.0 / Doubles.util.sum(pisub), pisub);
        return pisub;
    }

    public boolean isUnique() {
        if (this.pi == null) {
            throw new RuntimeException("Trying to find out whether stationary distribution is unique before having calculated it.");
        }
        return this.components.size() == 1;
    }

    public IDoubleArray getPi() {
        return this.pi;
    }

    public List<IIntArray> getComponents() {
        return this.components;
    }

    public List<IDoubleArray> getComponentsPi() {
        return this.componentsPi;
    }

    public static IDoubleArray calculate(IDoubleArray T) {
        StationaryDistribution statdist = new StationaryDistribution();
        statdist.setT(T);
        statdist.setReversible(false);
        return statdist.calculate();
    }

    public static IDoubleArray calculateReversible(IDoubleArray T) {
        StationaryDistribution statdist = new StationaryDistribution();
        statdist.setT(T);
        statdist.setReversible(true);
        return statdist.calculate();
    }
}

