/*
 * Decompiled with CFR 0.152.
 */
package stallone.mc.correlations;

import stallone.api.algebra.Algebra;
import stallone.api.algebra.IEigenvalueDecomposition;
import stallone.api.complex.IComplexArray;
import stallone.api.doubles.Doubles;
import stallone.api.doubles.IDoubleArray;
import stallone.api.mc.IDynamicalExpectationsSpectral;
import stallone.api.mc.MarkovModel;
import stallone.mc.StationaryDistribution;

public class DynamicalExpectationsSpectral
implements IDynamicalExpectationsSpectral {
    private IDoubleArray T;
    private IDoubleArray K;
    private StationaryDistribution statdist = new StationaryDistribution();
    private IDoubleArray pi;
    private IDoubleArray timescales;
    private IDoubleArray R;
    private IDoubleArray amplitudes;

    public DynamicalExpectationsSpectral(IDoubleArray M) {
        if (MarkovModel.util.isTransitionMatrix(M)) {
            this.setT(M);
        } else if (MarkovModel.util.isTransitionMatrix(M)) {
            this.setK(M);
        } else {
            throw new IllegalArgumentException("Trying to construct DynamicalExpectationsSpectral with a Matrix that is neither a transition nor a rate matrix");
        }
    }

    public DynamicalExpectationsSpectral() {
    }

    @Override
    public final void setT(IDoubleArray _T) {
        this.K = null;
        this.T = _T;
        this.statdist.setT(_T);
    }

    @Override
    public final void setK(IDoubleArray _K) {
        this.K = _K;
        this.T = null;
        this.statdist.setK(_K);
    }

    @Override
    public void setStationaryDistribution(IDoubleArray _pi) {
        this.pi = Doubles.create.array(_pi.getArray());
    }

    private void calculateAlgebra() {
        int i;
        IEigenvalueDecomposition evd;
        if (this.K == null && this.T == null) {
            throw new RuntimeException("Trying to calculate dynamical expectations before setting T or K.");
        }
        if (this.pi == null) {
            this.pi = Doubles.create.array(this.statdist.calculate().getArray());
        }
        if (this.T != null) {
            evd = Algebra.util.evd(this.T);
            IComplexArray evalT = evd.getEval();
            this.timescales = Doubles.create.array(evalT.size());
            i = 0;
            while (i < this.timescales.size()) {
                this.timescales.set(i, -1.0 / Math.log(Math.abs(evalT.get(i))));
                ++i;
            }
            this.R = evd.getRightEigenvectorMatrix();
        } else {
            evd = Algebra.util.evd(this.K);
            IComplexArray evalK = evd.getEval();
            this.timescales = Doubles.create.array(evalK.size());
            i = 0;
            while (i < this.timescales.size()) {
                this.timescales.set(i, -1.0 / Math.abs(evalK.get(i)));
                ++i;
            }
            this.R = evd.getRightEigenvectorMatrix();
        }
        int i2 = 0;
        while (i2 < this.R.columns()) {
            IDoubleArray ri = this.R.viewColumn(i2);
            double s = Math.sqrt(Algebra.util.dot(ri, ri, this.pi));
            int j = 0;
            while (j < this.R.size()) {
                this.R.set(j, i2, this.R.get(j, i2) / s);
                ++j;
            }
            ++i2;
        }
    }

    @Override
    public void calculatePerturbationExpectation(IDoubleArray p0, IDoubleArray a) {
        if (this.pi == null || this.timescales == null || this.R == null) {
            this.calculateAlgebra();
        }
        this.amplitudes = Doubles.create.array(this.timescales.size());
        int i = 0;
        while (i < this.amplitudes.size()) {
            double a1 = Algebra.util.dot(p0, this.R.viewColumn(i));
            double a2 = Algebra.util.dot(a, this.R.viewColumn(i), this.pi);
            this.amplitudes.set(i, a1 * a2);
            ++i;
        }
    }

    @Override
    public void calculateAutocorrelation(IDoubleArray a) {
        if (this.pi == null || this.timescales == null || this.R == null) {
            this.calculateAlgebra();
        }
        this.amplitudes = Doubles.create.array(this.timescales.size());
        int i = 0;
        while (i < this.amplitudes.size()) {
            double a1 = Algebra.util.dot(a, this.R.viewColumn(i), this.pi);
            this.amplitudes.set(i, a1 * a1);
            ++i;
        }
    }

    @Override
    public void calculateCorrelation(IDoubleArray a, IDoubleArray b) {
        if (this.pi == null || this.timescales == null || this.R == null) {
            this.calculateAlgebra();
        }
        this.amplitudes = Doubles.create.array(this.timescales.size());
        int i = 0;
        while (i < this.amplitudes.size()) {
            double a1 = Algebra.util.dot(a, this.R.viewColumn(i), this.pi);
            double a2 = Algebra.util.dot(b, this.R.viewColumn(i), this.pi);
            this.amplitudes.set(i, a1 * a2);
            ++i;
        }
    }

    @Override
    public IDoubleArray getAmplitudes() {
        return this.amplitudes;
    }

    @Override
    public IDoubleArray getTimescales() {
        return this.timescales;
    }

    @Override
    public double getValue(double t) {
        double res = 0.0;
        int i = 0;
        while (i < this.timescales.size()) {
            res += this.amplitudes.get(i) * Math.exp(-t / this.timescales.get(i));
            ++i;
        }
        return res;
    }
}

