/*
 * Decompiled with CFR 0.152.
 */
package stallone.mc.estimator;

import java.util.LinkedList;
import stallone.api.doubles.Doubles;
import stallone.api.doubles.IDoubleArray;
import stallone.api.ints.IIntArray;
import stallone.api.ints.Ints;
import stallone.api.mc.ICountMatrixEstimator;

public abstract class AbstractCountMatrixEstimator
implements ICountMatrixEstimator {
    protected LinkedList<IIntArray> input = new LinkedList();
    protected int lag = 1;
    protected IDoubleArray C = null;

    public AbstractCountMatrixEstimator(IIntArray traj) {
        this.input.add(traj);
    }

    public AbstractCountMatrixEstimator(Iterable<IIntArray> trajs) {
        for (IIntArray traj : trajs) {
            this.input.add(traj);
        }
    }

    @Override
    public void setLag(int _lag) {
        this.lag = _lag;
    }

    @Override
    public void addInput(IIntArray traj) {
        this.input.add(traj);
    }

    @Override
    public void addInput(Iterable<IIntArray> trajs) {
        for (IIntArray traj : trajs) {
            this.input.add(traj);
        }
    }

    @Override
    public IDoubleArray estimate() {
        int n = 0;
        for (IIntArray traj : this.input) {
            n = Math.max(Ints.util.max(traj) + 1, n);
        }
        this.C = Doubles.create.array(n, n);
        this.count();
        return this.C;
    }

    protected abstract void count();

    @Override
    public IDoubleArray getCountMatrix() {
        return this.C;
    }
}

