/*
 * Decompiled with CFR 0.152.
 */
package stallone.mc.estimator;

import java.util.Arrays;
import stallone.api.algebra.Algebra;
import stallone.api.doubles.Doubles;
import stallone.api.doubles.IDoubleArray;
import stallone.api.doubles.IDoubleIterator;
import stallone.api.doubles.IDoubleList;
import stallone.api.mc.ITransitionMatrixEstimator;

public final class TransitionMatrixEstimatorRev
implements ITransitionMatrixEstimator {
    private int nIterMax = 10000;
    private int nIterPer1 = 100;
    private IDoubleList logliks = Doubles.create.list(this.nIterMax);
    private IDoubleArray C;
    private double[] Crow;
    private IDoubleIterator itX;
    private IDoubleArray X;
    private double[] Xrow;
    private double Xsum;
    private boolean verbose = false;

    public TransitionMatrixEstimatorRev(IDoubleArray _C) {
        this.setCounts(_C);
    }

    public TransitionMatrixEstimatorRev() {
    }

    private void initX() {
        IDoubleArray CCT = Algebra.util.add(this.C, Algebra.util.transposeToNew(this.C));
        this.X = Doubles.create.symmetric(CCT);
        Algebra.util.scale(1.0 / Algebra.util.sum(this.X), this.X);
        this.itX = this.X.nonzeroIterator();
        this.Xrow = new double[this.X.rows()];
        this.updateXrow();
    }

    private void updateXrow() {
        int i;
        Arrays.fill(this.Xrow, 0.0);
        this.Xsum = 0.0;
        this.itX.reset();
        while (this.itX.hasNext()) {
            i = this.itX.row();
            int j = this.itX.column();
            int n = i;
            this.Xrow[n] = this.Xrow[n] + this.X.get(i, j);
            this.itX.advance();
        }
        i = 0;
        while ((double)i < this.Xrow[i]) {
            this.Xsum += this.Xrow[i];
            ++i;
        }
    }

    public double logL() {
        double ll = 0.0;
        this.itX.reset();
        while (this.itX.hasNext()) {
            int j;
            int i = this.itX.row();
            if (this.X.get(i, j = this.itX.column()) > 0.0) {
                ll += this.C.get(i, j) * Math.log(this.X.get(i, j) / this.Xrow[i]);
            }
            this.itX.advance();
        }
        return ll;
    }

    private boolean isConverged() {
        if (this.logliks.size() >= this.nIterMax) {
            return true;
        }
        if (this.logliks.size() <= this.nIterPer1) {
            return false;
        }
        int i2 = this.logliks.size() - 1;
        int i1 = i2 - this.nIterPer1;
        double dL = this.logliks.get(i2) - this.logliks.get(i1);
        return dL <= 1.0;
    }

    public void step() {
        this.itX.reset();
        while (this.itX.hasNext()) {
            int i = this.itX.row();
            int j = this.itX.column();
            double xij = (this.C.get(i, j) + this.C.get(j, i)) / (this.Crow[i] / this.Xrow[i] + this.Crow[j] / this.Xrow[j]);
            this.X.set(i, j, xij);
            this.itX.advance();
        }
        this.updateXrow();
        double ll = this.logL();
        if (this.verbose) {
            System.out.println(String.valueOf(this.logliks.size() + 1) + "\t" + ll);
        }
        this.logliks.append(ll);
    }

    @Override
    public void setMaxIter(int nmax) {
        this.nIterMax = nmax;
    }

    @Override
    public void setConvergence(int niter) {
        this.nIterPer1 = niter;
    }

    @Override
    public void setCounts(IDoubleArray _C) {
        this.C = _C;
        this.Crow = new double[_C.rows()];
        int j = 0;
        while (j < this.Crow.length) {
            this.Crow[j] = Doubles.util.sum(this.C.viewRow(j));
            ++j;
        }
        this.initX();
        double ll = this.logL();
        this.logliks = Doubles.create.list(this.nIterMax);
        this.logliks.append(ll);
    }

    @Override
    public void estimate() {
        while (!this.isConverged()) {
            this.step();
        }
    }

    @Override
    public IDoubleArray getTransitionMatrix() {
        IDoubleArray T = this.X.create(this.X.rows(), this.X.columns());
        IDoubleIterator it = this.X.nonzeroIterator();
        while (it.hasNext()) {
            int i = it.row();
            int j = it.column();
            T.set(i, j, this.X.get(i, j) / this.Xrow[i]);
            it.advance();
        }
        return T;
    }

    public IDoubleArray getSymmetricCorrelationMatrix() {
        return this.X;
    }

    @Override
    public double[] getLikelihoodHistory() {
        return this.logliks.getArray();
    }

    public int getIterations() {
        return this.logliks.size();
    }

    public void setVerbose(boolean _verbose) {
        this.verbose = _verbose;
    }
}

