/*
 * Decompiled with CFR 0.152.
 */
package stallone.mc.sampling;

import cern.jet.random.Beta;
import cern.jet.random.Exponential;
import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;
import stallone.api.doubles.IDoubleArray;
import stallone.api.mc.IReversibleSamplingStep;
import stallone.mc.sampling.ScaledElementSampler;

public class Step_Rev_Quad_Trendelkamp
implements IReversibleSamplingStep {
    private int n;
    private IDoubleArray C;
    private IDoubleArray T;
    private IDoubleArray mu;
    private MersenneTwister rand = new MersenneTwister();
    private Uniform randU = new Uniform(0.0, 1.0, this.rand);
    private Exponential randE = new Exponential(1.0, this.rand);
    private Beta randB = new Beta(1.0, 1.0, this.rand);
    private double Tii_backup;
    private double Tij_backup;
    private double Tji_backup;
    private double Tjj_backup;

    @Override
    public void init(IDoubleArray _C, IDoubleArray _T, IDoubleArray _mu) {
        this.n = _C.rows();
        this.C = _C;
        this.T = _T;
        this.mu = _mu;
    }

    public void sampleQuad(int i, int j) {
        if (i < j && this.C.get(i, j) + this.C.get(j, i) >= 0.0 && this.C.get(i, i) >= 0.0 && this.C.get(j, j) >= 0.0) {
            double a = this.C.get(i, j) + this.C.get(j, i);
            double delta = this.T.get(i, i) + this.T.get(i, j);
            double lambda = this.mu.get(j) / this.mu.get(i) * (this.T.get(j, j) + this.T.get(j, i));
            if (delta > 1.0E-15 && lambda > 1.0E-15) {
                double d;
                double c;
                double b;
                if (delta <= lambda) {
                    b = this.C.get(i, i);
                    c = this.C.get(j, j);
                    d = lambda / delta;
                } else {
                    b = this.C.get(j, j);
                    c = this.C.get(i, i);
                    d = delta / lambda;
                }
                double x = ScaledElementSampler.sample(this.randU, this.randE, this.randB, a, b, c, d);
                this.T.set(i, j, x * Math.min(delta, lambda));
                this.T.set(i, i, delta - this.T.get(i, j));
                this.T.set(j, i, this.mu.get(i) / this.mu.get(j) * this.T.get(i, j));
                this.T.set(j, j, this.mu.get(i) / this.mu.get(j) * lambda - this.T.get(j, i));
            }
        }
    }

    @Override
    public boolean step() {
        int k = this.randU.nextIntFromTo(0, this.n - 1);
        int l = this.randU.nextIntFromTo(0, this.n - 1);
        while (k == l) {
            k = this.randU.nextIntFromTo(0, this.n - 1);
            l = this.randU.nextIntFromTo(0, this.n - 1);
        }
        int i = Math.min(k, l);
        int j = Math.max(k, l);
        this.sampleQuad(i, j);
        return true;
    }
}

