/*
 * Decompiled with CFR 0.152.
 */
package stallone.mc.sampling;

import stallone.api.doubles.IDoubleArray;
import stallone.mc.sampling.TransitionMatrixSamplerAbstract;
import stallone.util.MathTools;

public class TransitionMatrixSamplerNonrev
extends TransitionMatrixSamplerAbstract {
    public TransitionMatrixSamplerNonrev(IDoubleArray counts) {
        super(counts);
    }

    public TransitionMatrixSamplerNonrev(IDoubleArray counts, IDoubleArray Tinit) {
        super(counts, Tinit);
    }

    @Override
    protected boolean step() {
        int i = 0;
        int j = 0;
        while ((i = MathTools.randomInt(0, this.T.rows())) == (j = MathTools.randomInt(0, this.T.rows()))) {
        }
        if (this.T.get(i, j) == 0.0 && this.T.get(i, i) == 0.0) {
            return false;
        }
        double d = MathTools.randomDouble(-this.T.get(i, j), this.T.get(i, i));
        double pacc = Math.pow((this.T.get(i, j) + d) / this.T.get(i, j), this.C.get(i, j)) * Math.pow((this.T.get(i, i) - d) / this.T.get(i, i), this.C.get(i, i));
        if (Math.random() <= pacc) {
            this.T.set(i, j, this.T.get(i, j) + d);
            this.T.set(i, i, this.T.get(i, i) - d);
            this.ensureValidElement(i, j);
            this.ensureValidElement(i, i);
            if (Math.random() < 1.0E-4) {
                this.ensureValidRow(i);
            }
            return true;
        }
        return false;
    }
}

