/*
 * Decompiled with CFR 0.152.
 */
package stallone.mc.sampling;

import stallone.api.API;
import stallone.api.doubles.IDoubleArray;
import stallone.api.mc.IReversibleSamplingStep;
import stallone.api.mc.MarkovModel;
import stallone.mc.sampling.Step_Rev_Quad_Gibbs_MC;
import stallone.mc.sampling.Step_Rev_Row_Beta;
import stallone.mc.sampling.TransitionMatrixSamplerAbstract;

public class TransitionMatrixSamplerRev
extends TransitionMatrixSamplerAbstract {
    protected IDoubleArray mu;
    private double p_step_row;
    private IReversibleSamplingStep step_row;
    private IReversibleSamplingStep step_quad;

    public TransitionMatrixSamplerRev(IDoubleArray counts) {
        super(counts);
    }

    public TransitionMatrixSamplerRev(IDoubleArray counts, IDoubleArray Tinit) {
        super(counts, Tinit);
    }

    @Override
    public final void init(IDoubleArray _C, IDoubleArray Tinit) {
        this.C = _C;
        this.T = Tinit == null ? MarkovModel.util.estimateTrev(TransitionMatrixSamplerRev.eraseNegatives(_C)) : Tinit;
        this.logLikelihood = MarkovModel.util.logLikelihood(this.T, this.C);
        this.mu = API.msm.stationaryDistribution(this.T);
        this.step_row = new Step_Rev_Row_Beta();
        this.step_row.init(this.C, this.T, this.mu);
        this.step_quad = new Step_Rev_Quad_Gibbs_MC();
        this.step_quad.init(this.C, this.T, this.mu);
        int dofQuad = 0;
        int dofRow = 0;
        int i = 0;
        while (i < this.C.rows()) {
            if (this.C.get(i, i) > -1.0 && API.doubles.sumRow(this.C, i) > (double)(-this.C.columns())) {
                ++dofRow;
            }
            int j = i + 1;
            while (j < this.C.columns()) {
                if (this.C.get(i, j) + this.C.get(j, i) > -2.0) {
                    ++dofQuad;
                }
                ++j;
            }
            ++i;
        }
        this.p_step_row = (double)dofRow / (double)(dofQuad + dofRow);
    }

    public static TransitionMatrixSamplerRev create(IDoubleArray _C, IDoubleArray Tinit, IReversibleSamplingStep _step_row, IReversibleSamplingStep _step_quad) {
        TransitionMatrixSamplerRev res = new TransitionMatrixSamplerRev(_C, Tinit);
        res.step_row = _step_row;
        res.step_row.init(_C, res.T, res.mu);
        res.step_quad = _step_quad;
        res.step_quad.init(_C, res.T, res.mu);
        return res;
    }

    public static TransitionMatrixSamplerRev create(IDoubleArray counts, IReversibleSamplingStep _step_row, IReversibleSamplingStep _step_quad) {
        return TransitionMatrixSamplerRev.create(counts, null, _step_row, _step_quad);
    }

    public IDoubleArray getInvariantDensity() {
        return this.mu;
    }

    public double detailedBalanceError() {
        return super.computeDetailedBalanceError(this.mu);
    }

    @Override
    protected boolean step() {
        if (Math.random() < this.p_step_row) {
            return this.step_row.step();
        }
        return this.step_quad.step();
    }
}

