/*
 * Decompiled with CFR 0.152.
 */
package stallone.mc.tpt;

import cern.colt.matrix.impl.SparseObjectMatrix2D;
import java.math.BigDecimal;
import stallone.api.API;
import stallone.api.graph.IIntGraph;
import stallone.doubles.PrimitiveDoubleTools;
import stallone.ints.PrimitiveIntTools;

class Bisection {
    int nV = 0;
    int[][] E;
    int[] order;
    int[][] Esorted;
    int[] A = null;
    int[] B = null;
    boolean[] inA = null;
    boolean[] inB = null;

    public Bisection(SparseObjectMatrix2D currentF, int[][] _E, int[] _A, int[] _B) {
        this.nV = currentF.rows();
        this.E = _E;
        this.A = _A;
        this.B = _B;
        this.inA = new boolean[currentF.rows()];
        int i = 0;
        while (i < this.A.length) {
            this.inA[this.A[i]] = true;
            ++i;
        }
        this.inB = new boolean[currentF.rows()];
        i = 0;
        while (i < this.B.length) {
            this.inB[this.B[i]] = true;
            ++i;
        }
        double[] W = new double[this.E.length];
        int i2 = 0;
        while (i2 < W.length) {
            W[i2] = ((BigDecimal)currentF.get(this.E[i2][0], this.E[i2][1])).doubleValue();
            ++i2;
        }
        this.order = PrimitiveDoubleTools.sortedIndexes(W);
        this.Esorted = new int[this.E.length][];
        i2 = 0;
        while (i2 < this.order.length) {
            this.Esorted[i2] = this.E[this.order[i2]];
            ++i2;
        }
    }

    public boolean hasConnection(int[][] _E) {
        IIntGraph g = API.graphNew.intListGraph(_E);
        int i = 0;
        while (i < this.A.length) {
            int[] found = API.graph.bfs(g, this.A[i]);
            int j = 0;
            while (j < found.length) {
                if (this.inB[found[j]]) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public int[] bottleneck() {
        if (this.Esorted.length == 0) {
            return null;
        }
        int[] ec = this.Esorted[this.Esorted.length - 1];
        if (this.inA[ec[0]] && this.inB[ec[1]]) {
            return ec;
        }
        int l = 0;
        int r = this.Esorted.length - 1;
        while (r - l > 1) {
            int m = (r + l) / 2;
            int[][] Esub = PrimitiveIntTools.subarray(this.Esorted, m, this.Esorted.length);
            if (this.hasConnection(Esub)) {
                l = m;
                continue;
            }
            r = m;
        }
        ec = this.Esorted[l];
        return ec;
    }
}

