/*
 * Decompiled with CFR 0.152.
 */
package stallone.potential;

import stallone.api.doubles.Doubles;
import stallone.api.doubles.IDoubleArray;
import stallone.doubles.EuclideanDistance;
import stallone.potential.AbstractPotential;
import stallone.util.MathTools;

public class FoldingModelSimple
extends AbstractPotential {
    private double df;
    private double kf;
    private double du;
    private double ku;
    private int ndim = 3;
    private IDoubleArray center;
    private IDoubleArray crd;
    private double energy;
    private IDoubleArray grad;
    private EuclideanDistance euclid = new EuclideanDistance();

    public FoldingModelSimple(double _df, double _kf, double _du, double _ku, int _ndim) {
        if (_df < 0.0 || _kf < 0.0 || _du < 0.0 || _ku < 0.0 || _df > _du || this.ndim < 1) {
            throw new IllegalArgumentException("Illegal Parameters");
        }
        this.df = _df;
        this.kf = _kf;
        this.du = _du;
        this.ku = _ku;
        this.ndim = _ndim;
        this.center = Doubles.create.array(this.ndim);
        this.crd = Doubles.create.array(this.ndim);
    }

    @Override
    public void setCoordinates(IDoubleArray coordinates) {
        if (coordinates.size() != this.ndim) {
            throw new IllegalArgumentException("Illegal Coordinate dimension");
        }
        this.crd.copyFrom(coordinates);
    }

    @Override
    public boolean calculate() {
        double d = this.euclid.distance(this.center, this.crd);
        this.grad = this.euclid.gradientY(this.center, this.crd);
        double g = 0.0;
        if (d < this.df) {
            this.energy = -this.kf / 2.0 * (d - this.df) * (d - this.df);
            g = -this.kf * (d - this.df);
        } else if (d > this.du) {
            this.energy = this.ku / 2.0 * (d - this.du) * (d - this.du);
            g = this.ku * (d - this.du);
        } else {
            this.energy = 0.0;
        }
        int i = 0;
        while (i < this.grad.size()) {
            this.grad.set(i, g * this.grad.get(i));
            ++i;
        }
        return true;
    }

    @Override
    public int getNDimensions() {
        return this.ndim;
    }

    @Override
    public double getEnergy() {
        return this.energy;
    }

    @Override
    public IDoubleArray getGradient() {
        return this.grad;
    }

    @Override
    public IDoubleArray getCoordinates() {
        return this.crd;
    }

    public double probabilityDensity(double distance, double kT) {
        double d = distance;
        double e = 0.0;
        e = d < this.df ? -this.kf / 2.0 * (d - this.df) * (d - this.df) : (d > this.du ? this.ku / 2.0 * (d - this.du) * (d - this.du) : 0.0);
        double A = MathTools.hyperSphereSurfaceArea(this.ndim, distance);
        double p = Math.exp(-e / kT) * A;
        return p;
    }

    @Override
    public int getNumberOfVariables() {
        return this.crd.size();
    }
}

