/*
 * Decompiled with CFR 0.152.
 */
package stallone.ui;

import java.io.IOException;
import java.util.List;
import stallone.api.API;
import stallone.api.doubles.IDoubleArray;
import stallone.api.ints.IIntArray;
import stallone.api.ints.IIntList;
import stallone.util.Arguments;

public class MSM_CountMatrix {
    public static void main(String[] args) throws IOException {
        IDoubleArray C;
        Arguments arg;
        if (args.length == 0) {
            System.out.println("CountMatrix\n-estimate <dtraj(s)> [-lag <lag>] [-sampleLag] [-countrev] [-subset <states>] \n\n-submatrix <C> <states>\n\n-populousSet <C> <minCount> <minIn> <minOut>");
            System.exit(0);
        }
        if ((arg = new Arguments(args)).hasCommand("estimate")) {
            List<String> inputfiles = API.io.listFileNames(arg.getArgument("estimate"));
            List<IIntArray> dtrajs = API.intseq.loadIntSequences(inputfiles);
            int lag = 1;
            if (arg.hasCommand("lag")) {
                lag = arg.getIntArgument("lag");
            }
            IDoubleArray C2 = null;
            C2 = arg.hasCommand("sampleLag") ? API.msm.estimateCstepping(dtrajs, lag) : API.msm.estimateC(dtrajs, lag);
            if (arg.hasCommand("countrev")) {
                C2 = API.alg.addWeightedToNew(0.5, C2, 0.5, API.alg.transposeToNew(C2));
            }
            if (arg.hasCommand("subset")) {
                IIntArray S = API.intseq.loadIntSequence(arg.getArgument("subset"));
                C2 = C2.view(S.getArray(), S.getArray());
            }
            API.doubles.writeMatrixSparse(C2, System.out);
        }
        if (arg.hasCommand("submatrix")) {
            C = API.doublesNew.fromFile(arg.getArgument("submatrix", 0));
            IIntArray S = API.intseq.loadIntSequence(arg.getArgument("submatrix", 1));
            C = C.view(S.getArray(), S.getArray());
            API.doubles.writeMatrixSparse(C, System.out);
        }
        if (arg.hasCommand("populousSet")) {
            C = API.doublesNew.fromFile(arg.getArgument("populousSet", 0));
            int n = C.rows();
            double minCount = arg.getIntArgument("populousSet", 1);
            double minIn = arg.getIntArgument("populousSet", 2);
            double minOut = arg.getIntArgument("populousSet", 3);
            IDoubleArray counts = API.alg.rowSums(C);
            IDoubleArray ins = API.alg.columnSums(C);
            IDoubleArray outs = API.alg.rowSums(C);
            int i = 0;
            while (i < n) {
                ins.set(i, i, ins.get(i, i) - C.get(i, i));
                outs.set(i, i, outs.get(i, i) - C.get(i, i));
                ++i;
            }
            IIntArray iC = API.doubles.largeValueIndexes(counts, minCount);
            IIntArray iI = API.doubles.largeValueIndexes(ins, minIn);
            IIntArray iO = API.doubles.largeValueIndexes(outs, minOut);
            IIntList I = API.ints.intersectionToNew(API.ints.intersectionToNew(iC, iI), iO);
            API.ints.print(I, "\n");
        }
    }
}

