/*
 * Decompiled with CFR 0.152.
 */
package stallone.ui;

import java.io.FileNotFoundException;
import java.io.IOException;
import stallone.api.API;
import stallone.api.algebra.IEigenvalueDecomposition;
import stallone.api.complex.IComplexArray;
import stallone.api.doubles.IDoubleArray;
import stallone.util.Arguments;

public class Tools_Matrix {
    public static void main(String[] args) throws FileNotFoundException, IOException {
        IDoubleArray T;
        Arguments arg;
        if (args.length == 0) {
            System.out.println("Tools_Matrix \n-sparse2dense <M>\n-dense2sparse <M>\n-eigenvalues <M> [-norm | -complex]\n-eigenvectors <M> <neig> [-left]\n");
            System.exit(0);
        }
        if ((arg = new Arguments(args)).hasCommand("sparse2dense")) {
            T = API.doublesNew.fromFile(arg.getArgument("sparse2dense"));
            API.doubles.writeMatrixDense(T, System.out);
        }
        if (arg.hasCommand("dense2sparse")) {
            T = API.doublesNew.fromFile(arg.getArgument("dense2sparse"));
            API.doubles.writeMatrixSparse(T, System.out);
        }
        if (arg.hasCommand("eigenvalues")) {
            T = API.doublesNew.fromFile(arg.getArgument("eigenvalues"));
            IEigenvalueDecomposition evd = API.alg.evd(T);
            if (arg.hasCommand("norm")) {
                API.doubles.print(evd.getEvalNorm(), "\n");
            } else if (arg.hasCommand("complex")) {
                IComplexArray eval = evd.getEval();
                int i = 0;
                while (i < eval.size()) {
                    System.out.println(String.valueOf(eval.getRe(i)) + " + " + eval.getIm(i) + "i");
                    ++i;
                }
            } else {
                API.doubles.print(evd.getEvalRe(), "\n");
            }
        }
        if (arg.hasCommand("eigenvectors")) {
            T = API.doublesNew.fromFile(arg.getArgument("eigenvectors"));
            if (arg.hasCommand("left")) {
                API.alg.transpose(T);
            }
            int n = arg.getIntArgument("eigenvectors", 1);
            IDoubleArray EV = API.alg.evd(T).R();
            EV = EV.viewBlock(0, EV.rows(), 0, n);
            API.doubles.print(EV, " ", "\n");
        }
    }
}

