/*
 * Decompiled with CFR 0.152.
 */
package stallone.util;

import java.util.ArrayList;
import java.util.HashMap;
import stallone.util.Arguments;
import stallone.util.Command;
import stallone.util.DoubleArgument;
import stallone.util.DoubleArrayCommand;
import stallone.util.ExpectedArgument;
import stallone.util.HeterogeneousCommand;
import stallone.util.IntArgument;
import stallone.util.IntArrayCommand;
import stallone.util.StringArgument;
import stallone.util.StringArrayCommand;
import stallone.util.StringTools;

public class CommandLineParser {
    private Arguments args;
    private HashMap<String, Command> commands = new HashMap();
    private ArrayList<String[]> atLeastOneOfCommands = new ArrayList();
    private ArrayList<String[]> atMostOneOfCommands = new ArrayList();

    public void addStringArrayCommand(String command, boolean mandatory) {
        this.addStringArrayCommand(command, mandatory, null, null);
    }

    public void addStringArrayCommand(String command, boolean mandatory, String[] defaultValue, String[] options) {
        this.commands.put(command, new StringArrayCommand(command, mandatory, defaultValue, options));
    }

    public void addIntArrayCommand(String command, boolean mandatory) {
        this.addIntArrayCommand(command, mandatory, null, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public void addIntArrayCommand(String command, boolean mandatory, int[] defaultValue, int minValue, int maxValue) {
        this.commands.put(command, new IntArrayCommand(command, mandatory, defaultValue, minValue, maxValue));
    }

    public void addDoubleArrayCommand(String command, boolean mandatory) {
        this.addDoubleArrayCommand(command, mandatory, null, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public void addDoubleArrayCommand(String command, boolean mandatory, double[] defaultValue, double minValue, double maxValue) {
        this.commands.put(command, new DoubleArrayCommand(command, mandatory, defaultValue, minValue, maxValue));
    }

    public void addCommand(String command, boolean _mandatory) {
        this.commands.put(command, new HeterogeneousCommand(command, _mandatory));
    }

    public void addStringCommand(String command, boolean _mandatory, String defaultValue, String[] options) {
        this.commands.put(command, new HeterogeneousCommand(command, _mandatory));
        this.addStringArgument(command, _mandatory, defaultValue, options);
    }

    public void addStringCommand(String command, boolean _mandatory) {
        this.commands.put(command, new HeterogeneousCommand(command, _mandatory));
        this.addStringArgument(command, _mandatory, null, null);
    }

    public void addIntCommand(String command, boolean _mandatory, int defaultValue, int minValue, int maxValue) {
        this.commands.put(command, new HeterogeneousCommand(command, _mandatory));
        this.addIntArgument(command, _mandatory, defaultValue, minValue, maxValue);
    }

    public void addIntCommand(String command, boolean _mandatory) {
        this.commands.put(command, new HeterogeneousCommand(command, _mandatory));
        this.addIntArgument(command, _mandatory);
    }

    public void addDoubleCommand(String command, boolean _mandatory, double defaultValue, double minValue, double maxValue) {
        this.commands.put(command, new HeterogeneousCommand(command, _mandatory));
        this.addDoubleArgument(command, _mandatory, defaultValue, minValue, maxValue);
    }

    public void addDoubleCommand(String command, boolean _mandatory) {
        this.commands.put(command, new HeterogeneousCommand(command, _mandatory));
        this.addDoubleArgument(command, _mandatory);
    }

    public void addStringArgument(String command, boolean mandatory) {
        this.addStringArgument(command, mandatory, null, null);
    }

    public void addStringArgument(String command, boolean mandatory, String defaultValue, String[] options) {
        if (!this.commands.containsKey(command)) {
            throw new IllegalArgumentException("Trying to add argument to command " + command + " which does not exist yet");
        }
        Command cmd = this.commands.get(command);
        if (!(cmd instanceof HeterogeneousCommand)) {
            throw new IllegalArgumentException("Trying to add string argument to command " + command + " which does not support another string argument");
        }
        HeterogeneousCommand cmdh = (HeterogeneousCommand)cmd;
        int pos = cmdh.arguments.size();
        cmdh.addArgument(new StringArgument(command, pos, mandatory, defaultValue, options));
    }

    public void addIntArgument(String command, boolean mandatory) {
        this.addIntArgument(command, mandatory, 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public void addIntArgument(String command, boolean mandatory, int defaultValue, int minValue, int maxValue) {
        if (!this.commands.containsKey(command)) {
            throw new IllegalArgumentException("Trying to add argument to command " + command + " which does not exist yet");
        }
        Command cmd = this.commands.get(command);
        if (!(cmd instanceof HeterogeneousCommand)) {
            throw new IllegalArgumentException("Trying to add string argument to command " + command + " which does not support another string argument");
        }
        HeterogeneousCommand cmdh = (HeterogeneousCommand)cmd;
        int pos = cmdh.arguments.size();
        cmdh.addArgument(new IntArgument(command, pos, mandatory, defaultValue, minValue, maxValue));
    }

    public void addDoubleArgument(String command, boolean mandatory) {
        this.addDoubleArgument(command, mandatory, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public void addDoubleArgument(String command, boolean mandatory, double defaultValue, double minValue, double maxValue) {
        if (!this.commands.containsKey(command)) {
            throw new IllegalArgumentException("Trying to add argument to command " + command + " which does not exist yet");
        }
        Command cmd = this.commands.get(command);
        if (!(cmd instanceof HeterogeneousCommand)) {
            throw new IllegalArgumentException("Trying to add string argument to command " + command + " which does not support another string argument");
        }
        HeterogeneousCommand cmdh = (HeterogeneousCommand)cmd;
        int pos = cmdh.arguments.size();
        cmdh.addArgument(new DoubleArgument(command, pos, mandatory, defaultValue, minValue, maxValue));
    }

    public void requireAtMostOneOf(String ... exclusives) {
        String[] stringArray = exclusives;
        int n = exclusives.length;
        int n2 = 0;
        while (n2 < n) {
            String cmd = stringArray[n2];
            if (!this.commands.containsKey(cmd)) {
                throw new IllegalArgumentException("Trying to set the command " + cmd + " exclusive. This command has not been defined yet");
            }
            ++n2;
        }
        this.atMostOneOfCommands.add(exclusives);
    }

    public void requireAtLeastOneOf(String ... cmds) {
        String[] stringArray = cmds;
        int n = cmds.length;
        int n2 = 0;
        while (n2 < n) {
            String cmd = stringArray[n2];
            if (!this.commands.containsKey(cmd)) {
                throw new IllegalArgumentException("Trying to set the command " + cmd + " exclusive. This command has not been defined yet");
            }
            ++n2;
        }
        this.atLeastOneOfCommands.add(cmds);
    }

    public void requireExactlyOneOf(String ... cmds) {
        this.requireAtMostOneOf(cmds);
        this.requireAtLeastOneOf(cmds);
    }

    private boolean checkIfAllCommandsAreExpected() {
        String[] stringArray = this.args.getCommands();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String cmd = stringArray[n2];
            boolean found = false;
            for (Command expectedArg : this.commands.values()) {
                if (expectedArg.command.equals(cmd)) {
                    found = true;
                    break;
                }
                if (!expectedArg.command.equalsIgnoreCase(cmd)) continue;
                System.out.println("Found command " + cmd + " but expected " + expectedArg.command + ". Please check case.");
                return false;
            }
            if (!found) {
                System.out.println("Unexpected command " + cmd);
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean checkCommandDependencies() {
        String cmd;
        int n;
        int n2;
        String[] stringArray;
        for (String[] group : this.atMostOneOfCommands) {
            String found = null;
            stringArray = group;
            n2 = group.length;
            n = 0;
            while (n < n2) {
                cmd = stringArray[n];
                if (this.args.hasCommand(cmd)) {
                    if (found == null) {
                        found = cmd;
                    } else {
                        System.out.println("Found both commands " + found + " and " + cmd + " which are mutually exclusive.");
                        return false;
                    }
                }
                ++n;
            }
        }
        for (String[] group : this.atLeastOneOfCommands) {
            boolean found = false;
            stringArray = group;
            n2 = group.length;
            n = 0;
            while (n < n2) {
                cmd = stringArray[n];
                if (this.args.hasCommand(cmd)) {
                    found = true;
                    break;
                }
                ++n;
            }
            if (found) continue;
            System.out.println("Found none of the commands " + StringTools.toString(group) + ". At least one is required");
            return false;
        }
        return true;
    }

    public boolean parse(String[] commandline) {
        this.args = new Arguments(commandline);
        if (!this.checkIfAllCommandsAreExpected()) {
            return false;
        }
        if (!this.checkCommandDependencies()) {
            return false;
        }
        String[] stringArray = this.args.getCommands();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String cmdstr = stringArray[n2];
            Command cmd = this.commands.get(cmdstr);
            cmd.setArguments(this.args);
            cmd.parse();
            ++n2;
        }
        return true;
    }

    private Command retrieve(String cmd) {
        if (!this.commands.containsKey(cmd)) {
            throw new IllegalArgumentException("Trying to read command " + cmd + " which has not been defined");
        }
        Command c = this.commands.get(cmd);
        return c;
    }

    private ExpectedArgument retrieve(String cmd, int iArg) {
        if (!this.commands.containsKey(cmd)) {
            throw new IllegalArgumentException("Trying to read command " + cmd + " which has not been defined");
        }
        Command c = this.commands.get(cmd);
        if (!(c instanceof HeterogeneousCommand)) {
            throw new IllegalArgumentException("Trying to read single argument " + iArg + " of a command " + cmd + " which supports only an array. Get the array as a whole");
        }
        HeterogeneousCommand ch = (HeterogeneousCommand)c;
        if (ch.arguments.size() <= iArg) {
            throw new IllegalArgumentException("Trying to read argument " + iArg + " of command " + cmd + " which has not been defined");
        }
        return ch.arguments.get(iArg);
    }

    public boolean hasCommand(String cmd) {
        return this.args.hasCommand(cmd);
    }

    public String getString(String cmd, int iArg) {
        ExpectedArgument ea = this.retrieve(cmd, iArg);
        if (!(ea instanceof StringArgument)) {
            throw new IllegalArgumentException("Trying to read argument " + iArg + " of command " + cmd + " as string argument, but it is of a different type");
        }
        return ((StringArgument)ea).value;
    }

    public String[] getStringArray(String cmd) {
        Command c = this.retrieve(cmd);
        if (!(c instanceof StringArrayCommand)) {
            throw new IllegalArgumentException("Trying to read argument of command " + cmd + " as int array argument, but it is of a different type");
        }
        return ((StringArrayCommand)c).value;
    }

    public int getInt(String cmd, int iArg) {
        ExpectedArgument ea = this.retrieve(cmd, iArg);
        if (!(ea instanceof IntArgument)) {
            throw new IllegalArgumentException("Trying to read argument " + iArg + " of command " + cmd + " as int argument, but it is of a different type");
        }
        return ((IntArgument)ea).value;
    }

    public int[] getIntArray(String cmd) {
        Command c = this.retrieve(cmd);
        if (!(c instanceof IntArrayCommand)) {
            throw new IllegalArgumentException("Trying to read argument of command " + cmd + " as int array argument, but it is of a different type");
        }
        return ((IntArrayCommand)c).value;
    }

    public double getDouble(String cmd, int iArg) {
        ExpectedArgument ea = this.retrieve(cmd, iArg);
        if (!(ea instanceof DoubleArgument)) {
            throw new IllegalArgumentException("Trying to read argument " + iArg + " of command " + cmd + " as double argument, but it is of a different type");
        }
        return ((DoubleArgument)ea).value;
    }

    public double[] getDoubleArray(String cmd) {
        Command c = this.retrieve(cmd);
        if (!(c instanceof DoubleArrayCommand)) {
            throw new IllegalArgumentException("Trying to read argument of command " + cmd + " as double array argument, but it is of a different type");
        }
        return ((DoubleArrayCommand)c).value;
    }

    public String getString(String cmd) {
        return this.getString(cmd, 0);
    }

    public int getInt(String cmd) {
        return this.getInt(cmd, 0);
    }

    public double getDouble(String cmd) {
        return this.getDouble(cmd, 0);
    }
}

