/*
 * Decompiled with CFR 0.152.
 */
package stallone.util;

import stallone.api.ints.IIntArray;
import stallone.api.ints.Ints;

public class Counter {
    IIntArray nStates;
    IIntArray count;

    public Counter(IIntArray _nStates) {
        this.nStates = _nStates.copy();
        this.count = Ints.create.array(this.nStates.size());
    }

    public int getNstates() {
        int N = 1;
        int i = 0;
        while (i < this.nStates.size()) {
            N *= this.nStates.get(i);
            ++i;
        }
        return N;
    }

    public void set(IIntArray _count) {
        int i = 0;
        while (i < this.nStates.size()) {
            if (_count.get(i) >= this.nStates.get(i)) {
                throw new IllegalArgumentException("Trying to set illegal count state " + _count.get(i) + " for counter index " + i);
            }
            this.count.set(i, _count.get(i));
            ++i;
        }
    }

    public IIntArray get() {
        return this.count;
    }

    public boolean inc(int state) {
        if (state < 0) {
            return false;
        }
        this.count.set(state, this.count.get(state) + 1);
        if (this.count.get(state) == this.nStates.get(state)) {
            this.count.set(state, 0);
            return this.inc(state - 1);
        }
        return true;
    }

    public boolean inc() {
        return this.inc(this.count.size() - 1);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(String.valueOf(this.count.get(0)));
        int i = 1;
        while (i < this.count.size()) {
            buf.append(", ").append(this.count.get(i));
            ++i;
        }
        return buf.toString();
    }
}

