/*
 * Decompiled with CFR 0.152.
 */
package stallone.algebra;

import stallone.api.complex.IComplexArray;
import stallone.api.doubles.IDoubleArray;

public class ArrayNumericalEquality {
    public boolean numericallyEqual(IDoubleArray o1, IDoubleArray o2, double precision) {
        int rows = o1.rows();
        int cols = o1.columns();
        if (rows != o2.rows() || cols != o2.columns()) {
            return false;
        }
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                if (Math.abs(o1.get(i, j) - o2.get(i, j)) > precision) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public boolean numericallyEqual(IComplexArray o1, IComplexArray o2, double precision) {
        int rows = o1.rows();
        int cols = o1.columns();
        if (rows != o2.rows() || cols != o2.columns()) {
            return false;
        }
        double p2 = precision * precision;
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                double diffIm;
                double diffRe = o1.getRe(i, j) - o2.getRe(i, j);
                if (diffRe * diffRe + (diffIm = o1.getIm(i, j) - o2.getIm(i, j)) * diffIm > p2) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }
}

