/*
 * Decompiled with CFR 0.152.
 */
package stallone.algebra;

import stallone.api.algebra.IComplexNumber;
import stallone.api.complex.IComplexArray;
import stallone.api.complex.IComplexIterator;
import stallone.api.doubles.IDoubleArray;
import stallone.api.doubles.IDoubleIterator;

public class ArrayScale {
    public void scaleQuick(IDoubleArray a, double k, IDoubleArray target) {
        IDoubleIterator it = a.nonzeroIterator();
        while (it.hasNext()) {
            target.set(it.row(), it.column(), k * it.get());
            it.advance();
        }
    }

    public void scale(IDoubleArray a, double k) {
        IDoubleIterator it = a.nonzeroIterator();
        while (it.hasNext()) {
            it.set(k * it.get());
            it.advance();
        }
    }

    public void scale(IDoubleArray a, double k, IDoubleArray target) {
        target.zero();
        this.scaleQuick(a, k, target);
    }

    public void scaleQuick(IComplexArray a, IComplexNumber k, IComplexArray target) {
        if (a.isReal() && k.isPurelyReal()) {
            this.scale((IDoubleArray)a, k.getRe(), (IDoubleArray)target);
        } else {
            IComplexIterator it = a.nonzeroComplexIterator();
            while (it.hasNext()) {
                int i = it.row();
                int j = it.column();
                double re = it.getRe() * k.getRe() - it.getIm() * k.getIm();
                double im = it.getRe() * k.getIm() + it.getIm() * k.getRe();
                target.setRe(i, j, re);
                target.setIm(i, j, im);
                it.advance();
            }
        }
    }

    public void scale(IComplexArray a, IComplexNumber k, IComplexArray target) {
        target.zero();
        this.scaleQuick(a, k, target);
    }

    public void scale(IComplexArray a, IComplexNumber k) {
        if (a.isReal() && k.isPurelyReal()) {
            this.scale((IDoubleArray)a, k.getRe());
        } else {
            IComplexIterator it = a.nonzeroComplexIterator();
            while (it.hasNext()) {
                double re = it.getRe() * k.getRe() - it.getIm() * k.getIm();
                double im = it.getRe() * k.getIm() + it.getIm() * k.getRe();
                it.setRe(re);
                it.setIm(im);
                it.advance();
            }
        }
    }
}

