/*
 * Decompiled with CFR 0.152.
 */
package stallone.algebra;

import stallone.api.complex.IComplexArray;
import stallone.api.complex.IComplexIterator;
import stallone.api.doubles.IDoubleArray;
import stallone.api.doubles.IDoubleIterator;
import stallone.doubles.DoubleArrayTest;

public class ArraySum {
    public IDoubleArray addToNewDense(IDoubleArray a, IDoubleArray b) {
        IDoubleArray target = a.copy();
        this.sumDense(a, b, target);
        return target;
    }

    public IDoubleArray addToNewSparse(IDoubleArray a, IDoubleArray b) {
        IDoubleArray target = a.copy();
        this.sumSparse(a, b, target);
        return target;
    }

    public void addToSparse(IDoubleArray a, IDoubleArray b) {
        DoubleArrayTest.assertEqualDimensions(a, b);
        IDoubleIterator it = b.nonzeroIterator();
        while (it.hasNext()) {
            int i = it.row();
            int j = it.column();
            a.set(i, j, a.get(i, j) + it.get());
            it.advance();
        }
    }

    public void addToDense(IDoubleArray a, IDoubleArray b) {
        this.sumDense(a, b, a);
    }

    public void sumDense(IDoubleArray a, IDoubleArray b, IDoubleArray target) {
        DoubleArrayTest.assertEqualDimensions(a, b);
        DoubleArrayTest.assertEqualDimensions(a, target);
        int rowsA = a.rows();
        int colsA = a.columns();
        int i = 0;
        while (i < rowsA) {
            int j = 0;
            while (j < colsA) {
                target.set(i, j, a.get(i, j) + b.get(i, j));
                ++j;
            }
            ++i;
        }
    }

    public void sumSparse(IDoubleArray a, IDoubleArray b, IDoubleArray target) {
        IDoubleIterator it;
        DoubleArrayTest.assertEqualDimensions(a, b);
        DoubleArrayTest.assertEqualDimensions(a, target);
        if (a != target) {
            target.zero();
            it = a.nonzeroIterator();
            while (it.hasNext()) {
                target.set(it.row(), it.column(), it.get());
                it.advance();
            }
        }
        it = b.nonzeroIterator();
        while (it.hasNext()) {
            int i = it.row();
            int j = it.column();
            target.set(i, j, target.get(i, j) + it.get());
            it.advance();
        }
    }

    public IComplexArray addToNewDense(IComplexArray a, IComplexArray b) {
        IComplexArray target = a.copy();
        this.sumDense(a, b, target);
        return target;
    }

    public IComplexArray addToNewSparse(IComplexArray a, IComplexArray b) {
        IComplexArray target = a.copy();
        this.sumSparse(a, b, target);
        return target;
    }

    public void addToDense(IComplexArray a, IComplexArray b) {
        this.sumDense(a, b, a);
    }

    public void addToSparse(IComplexArray a, IComplexArray b) {
        DoubleArrayTest.assertEqualDimensions(a, b);
        IComplexIterator it = b.nonzeroComplexIterator();
        while (it.hasNext()) {
            int i = it.row();
            int j = it.column();
            a.set(it.row(), it.column(), a.getRe(i, j) + it.getRe(), b.getIm(i, j) + it.getIm());
            it.advance();
        }
    }

    public void sumDense(IComplexArray a, IComplexArray b, IComplexArray target) {
        DoubleArrayTest.assertEqualDimensions(a, b);
        DoubleArrayTest.assertEqualDimensions(a, target);
        int colsA = a.columns();
        int rowsA = a.rows();
        int j = 0;
        while (j < rowsA) {
            int i = 0;
            while (i < colsA) {
                target.set(i, j, a.getRe(i, j) + b.getRe(i, j), a.getIm(i, j) + b.getIm(i, j));
                ++i;
            }
            ++j;
        }
    }

    public void sumSparse(IComplexArray a, IComplexArray b, IComplexArray target) {
        IComplexIterator it;
        DoubleArrayTest.assertEqualDimensions(a, b);
        DoubleArrayTest.assertEqualDimensions(a, target);
        if (a != target) {
            target.zero();
            it = a.nonzeroComplexIterator();
            while (it.hasNext()) {
                target.set(it.row(), it.column(), it.getRe(), it.getIm());
                it.advance();
            }
        }
        it = b.nonzeroComplexIterator();
        while (it.hasNext()) {
            int i = it.row();
            int j = it.column();
            target.set(i, j, target.getRe(i, j) + it.getRe(), target.getIm(i, j) + it.getIm());
            it.advance();
        }
    }
}

