/*
 * Decompiled with CFR 0.152.
 */
package stallone.algebra;

import stallone.api.algebra.IComplexNumber;
import stallone.api.algebra.IEigenvalueDecomposition;
import stallone.api.complex.Complex;
import stallone.api.complex.IComplexArray;
import stallone.api.doubles.Doubles;
import stallone.api.doubles.IDoubleArray;
import stallone.api.ints.IIntArray;
import stallone.api.ints.Ints;
import stallone.complex.ComplexNumber;

public class EigenvalueDecomposition
implements IEigenvalueDecomposition {
    private IComplexArray L;
    private IComplexArray eval;
    private IComplexArray R;
    private int fullRank = 0;
    private int availableEigenvalues = 0;
    private IIntArray order;
    private int[] fullRankEnum;

    public EigenvalueDecomposition(IComplexArray _L, IComplexArray _eval, IComplexArray _R) {
        this.L = _L;
        this.eval = _eval;
        this.R = _R;
        if (_L != null) {
            this.availableEigenvalues = _L.rows();
            this.fullRank = _L.columns();
            if (_R != null && (_R.rows() != this.fullRank || _R.columns() != this.availableEigenvalues)) {
                throw new IllegalArgumentException("Inconsistent sizes of eigenvector matrices or eigenvalues: (" + this.L.rows() + "x" + this.L.columns() + "  (" + this.eval.size() + ")  " + this.R.rows() + "x" + this.R.columns());
            }
        }
        if (_R != null) {
            this.availableEigenvalues = _R.columns();
            this.fullRank = _R.rows();
            if (_L != null && (_L.columns() != this.fullRank || _L.rows() != this.availableEigenvalues)) {
                throw new IllegalArgumentException("Inconsistent sizes of eigenvector matrices or eigenvalues: (" + this.L.rows() + "x" + this.L.columns() + "  (" + this.eval.size() + ")  " + this.R.rows() + "x" + this.R.columns());
            }
        }
        if (_L == null && _R == null) {
            this.availableEigenvalues = _eval.size();
            this.fullRank = _eval.size();
        }
        if (_eval.size() != this.availableEigenvalues || _eval.order() != 1) {
            throw new IllegalArgumentException("Inconsistent sizes of eigenvalue matrix: (" + this.eval.size() + ")");
        }
        this.order = Ints.create.arrayRange(this.availableEigenvalues);
        this.sortNormDescending();
        this.fullRankEnum = Ints.create.arrayRange(this.fullRank).getArray();
    }

    @Override
    public int availableEigenpairs() {
        return this.availableEigenvalues;
    }

    @Override
    public int fullRank() {
        return this.fullRank;
    }

    @Override
    public final void sortNormAscending() {
        IDoubleArray evalNorm = this.getEvalNormUnsorted();
        this.order = Doubles.util.sortedIndexes(evalNorm);
    }

    @Override
    public final void sortNormDescending() {
        IDoubleArray evalNorm = this.getEvalNormUnsorted();
        this.order = Doubles.util.sortedIndexes(evalNorm);
        Ints.util.mirror(this.order);
    }

    @Override
    public final void sortRealAscending() {
        IDoubleArray evalNorm = this.eval.viewReal();
        this.order = Doubles.util.sortedIndexes(evalNorm);
    }

    @Override
    public final void sortRealDescending() {
        IDoubleArray evalNorm = this.eval.viewReal();
        this.order = Doubles.util.sortedIndexes(evalNorm);
        Ints.util.mirror(this.order);
    }

    @Override
    public IComplexArray getRightEigenvectorMatrix() {
        return this.R.view(this.fullRankEnum, this.order.getArray());
    }

    @Override
    public IComplexArray getRightEigenvector(int i) {
        return this.R.viewColumn(this.order.get(i));
    }

    @Override
    public IComplexArray getLeftEigenvectorMatrix() {
        return this.L.view(this.order.getArray(), this.fullRankEnum);
    }

    @Override
    public IComplexArray getLeftEigenvector(int i) {
        return this.L.viewRow(this.order.get(i));
    }

    @Override
    public IComplexArray getDiagonalMatrix() {
        return Complex.create.diag(this.eval.view(this.order.getArray(), new int[1]));
    }

    @Override
    public IComplexArray getEval() {
        return this.eval.view(this.order.getArray(), new int[1]);
    }

    @Override
    public IComplexNumber getEval(int i) {
        return new ComplexNumber(this.eval.getRe(this.order.get(i)), this.eval.getIm(this.order.get(i)));
    }

    @Override
    public IDoubleArray getEvalRe() {
        return this.getEval().viewReal();
    }

    @Override
    public double getEvalRe(int i) {
        return this.eval.getRe(this.order.get(i));
    }

    @Override
    public IDoubleArray getEvalIm() {
        return this.getEval().viewImaginary();
    }

    @Override
    public double getEvalIm(int i) {
        return this.eval.getIm(this.order.get(i));
    }

    @Override
    public IComplexArray R() {
        return this.getRightEigenvectorMatrix();
    }

    @Override
    public IComplexArray L() {
        return this.getLeftEigenvectorMatrix();
    }

    @Override
    public IComplexArray D() {
        return this.getDiagonalMatrix();
    }

    private IDoubleArray getEvalNormUnsorted() {
        IDoubleArray res = Doubles.create.array(this.availableEigenvalues);
        int i = 0;
        while (i < this.availableEigenvalues) {
            double re = this.eval.getRe(i);
            double im = this.eval.getIm(i);
            res.set(i, Math.sqrt(re * re + im * im));
            ++i;
        }
        return res;
    }

    @Override
    public IDoubleArray getEvalNorm() {
        IDoubleArray res = Doubles.create.array(this.availableEigenvalues);
        int i = 0;
        while (i < this.availableEigenvalues) {
            double re = this.eval.getRe(this.order.get(i));
            double im = this.eval.getIm(this.order.get(i));
            res.set(i, Math.sqrt(re * re + im * im));
            ++i;
        }
        return res;
    }

    @Override
    public double getEvalNorm(int i) {
        double re = this.eval.getRe(this.order.get(i));
        double im = this.eval.getIm(this.order.get(i));
        return Math.sqrt(re * re + im * im);
    }

    @Override
    public boolean hasLeftEigenvectors() {
        return this.L != null;
    }

    @Override
    public boolean hasRightEigenvectors() {
        return this.R != null;
    }
}

