/*
 * Decompiled with CFR 0.152.
 */
package stallone.algebra;

import java.security.InvalidParameterException;
import stallone.api.algebra.Algebra;
import stallone.api.algebra.ICholeskyDecomposition;
import stallone.api.doubles.Doubles;
import stallone.api.doubles.IDoubleArray;

public class RealCholeskyDecomposition
implements ICholeskyDecomposition {
    private IDoubleArray matrixA;
    private IDoubleArray matrixR;

    public RealCholeskyDecomposition(IDoubleArray input) {
        this.setInputMatrix(input);
        this.setResultMatrix(this.computeDecomposition(input));
    }

    @Override
    public boolean hasDecomposition() {
        return this.getRMatrix() != null;
    }

    @Override
    public IDoubleArray getRMatrix() {
        return this.matrixR;
    }

    @Override
    public IDoubleArray getInputMatrix() {
        return this.matrixA;
    }

    protected void setInputMatrix(IDoubleArray matrix) {
        if (matrix == null) {
            throw new InvalidParameterException("Input matrix must not be null");
        }
        if (!Algebra.util.isSymmetric(matrix)) {
            throw new InvalidParameterException("Input matrix must be symmetric");
        }
        this.matrixA = matrix;
    }

    protected void setResultMatrix(IDoubleArray matrix) {
        this.matrixR = matrix;
    }

    private IDoubleArray computeDecomposition(IDoubleArray input) {
        int n = input.rows();
        IDoubleArray result = Doubles.create.array(n, n);
        result.zero();
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j <= i) {
                double sum = 0.0;
                int k = 0;
                while (k < j) {
                    sum += result.get(i, k) * result.get(j, k);
                    ++k;
                }
                if (i == j) {
                    result.set(i, i, Math.sqrt(input.get(i, i) - sum));
                } else {
                    result.set(i, j, 1.0 / result.get(j, j) * (input.get(i, j) - sum));
                }
                ++j;
            }
            if (result.get(i, i) <= 0.0) {
                result = null;
                break;
            }
            ++i;
        }
        return result;
    }
}

