/*
 * Decompiled with CFR 0.152.
 */
package stallone.algebra.extern;

import com.github.fommil.netlib.LAPACK;
import org.netlib.util.intW;
import stallone.algebra.EigenvalueDecomposition;
import stallone.api.algebra.Algebra;
import stallone.api.algebra.IComplexNumber;
import stallone.api.algebra.IEigenvalueDecomposition;
import stallone.api.algebra.IEigenvalueSolver;
import stallone.api.complex.IComplexArray;
import stallone.api.complex.ImaginaryView;
import stallone.api.doubles.IDoubleArray;
import stallone.complex.AbstractComplexArray;
import stallone.complex.ComplexNumber;
import stallone.complex.DenseComplexArray;
import stallone.doubles.DoubleArrayTest;

public class LapackEigenvalueDecomposition
implements IEigenvalueSolver {
    private static double[] emptyDouble = new double[0];
    private double[] workSpace;
    private int size;
    private IDoubleArray matrix;
    private boolean jobLeft;
    private boolean jobRight;
    private int nev = -1;
    private String jobLeftString;
    private String jobRightString;
    private double[] wRealValues;
    private double[] wImagValues;
    private double[] vLeftEigenvectors;
    private double[] vRightEigenvectors;
    private IEigenvalueDecomposition result;

    public LapackEigenvalueDecomposition() {
        this(false, true);
    }

    public LapackEigenvalueDecomposition(boolean left, boolean right) {
        this.setPerformLeftComputation(left);
        this.setPerformRightComputation(right);
        this.workSpace = null;
    }

    @Override
    public final void setPerformLeftComputation(boolean left) {
        this.jobLeft = left;
        this.jobLeftString = "N";
        if (this.jobLeft) {
            this.jobLeftString = "V";
        }
    }

    @Override
    public final void setPerformRightComputation(boolean right) {
        this.jobRight = right;
        this.jobRightString = "N";
        if (this.jobRight) {
            this.jobRightString = "V";
        }
    }

    @Override
    public void setMatrix(IDoubleArray m) {
        DoubleArrayTest.assertSquare(m);
        this.matrix = m;
        this.size = m.rows();
        this.wRealValues = new double[this.size];
        this.wImagValues = new double[this.size];
        this.vLeftEigenvectors = (double[])(this.jobLeft ? new double[this.size * this.size] : null);
        this.vRightEigenvectors = (double[])(this.jobRight ? new double[this.size * this.size] : null);
        this.workSpace = new double[this.getSizeOfWorkspace()];
    }

    @Override
    public void setNumberOfRequestedEigenvalues(int nev) {
    }

    @Override
    public void perform() {
        intW info = new intW(0);
        double[] matrixDataColumnMajor = new double[this.size * this.size];
        int i = 0;
        while (i < this.size) {
            int j = 0;
            while (j < this.size) {
                matrixDataColumnMajor[i + j * this.size] = this.matrix.get(i, j);
                ++j;
            }
            ++i;
        }
        double[] leftEigenVectorData = emptyDouble;
        if (this.jobLeft) {
            leftEigenVectorData = this.vLeftEigenvectors;
        }
        double[] rightEigenVectorData = emptyDouble;
        if (this.jobRight) {
            rightEigenVectorData = this.vRightEigenvectors;
        }
        LAPACK.getInstance().dgeev(this.jobLeftString, this.jobRightString, this.size, matrixDataColumnMajor, this.size, this.wRealValues, this.wImagValues, leftEigenVectorData, this.size, rightEigenVectorData, this.size, this.workSpace, this.workSpace.length, info);
        if (info.val > 0) {
            throw new RuntimeException("EVD did not converge.");
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        IComplexArray L = null;
        if (this.jobLeft) {
            L = new MatrixOfEigenvectors(this.vLeftEigenvectors).copy();
            Algebra.util.transpose(L);
        }
        MatrixOfEigenvectors R = null;
        if (this.jobRight) {
            R = new MatrixOfEigenvectors(this.vRightEigenvectors);
        }
        VectorOfEigenvalues eval = new VectorOfEigenvalues();
        this.result = new EigenvalueDecomposition(L, eval, R);
    }

    @Override
    public IEigenvalueDecomposition getResult() {
        return this.result;
    }

    private int getSizeOfWorkspace() {
        double[] worksize = new double[1];
        intW info = new intW(0);
        LAPACK.getInstance().dgeev(this.jobLeftString, this.jobRightString, this.size, emptyDouble, this.size, emptyDouble, emptyDouble, emptyDouble, this.size, emptyDouble, this.size, worksize, -1, info);
        int workSpaceSize = 0;
        workSpaceSize = info.val != 0 ? (this.jobLeft && this.jobRight ? 4 * this.size : 3 * this.size) : (int)worksize[0];
        workSpaceSize = Math.max(1, workSpaceSize);
        return workSpaceSize;
    }

    private class MatrixOfEigenvectors
    extends AbstractComplexArray {
        private final int rows;
        private final int cols;
        private final double[] data;
        private final int[] firstOfPair;
        private final boolean[] isComplex;
        private final int n;

        private MatrixOfEigenvectors(double[] data) {
            this.rows = LapackEigenvalueDecomposition.this.size;
            this.cols = LapackEigenvalueDecomposition.this.size;
            this.data = data;
            this.n = LapackEigenvalueDecomposition.this.size;
            this.firstOfPair = new int[this.n];
            this.isComplex = new boolean[this.n];
            int i = 0;
            while (i < this.n) {
                if (LapackEigenvalueDecomposition.this.wImagValues[i] == 0.0) {
                    this.firstOfPair[i] = i;
                    this.isComplex[i] = false;
                } else {
                    this.firstOfPair[i] = i;
                    this.firstOfPair[i + 1] = i;
                    this.isComplex[i] = true;
                    this.isComplex[i + 1] = true;
                    ++i;
                }
                ++i;
            }
        }

        private MatrixOfEigenvectors(MatrixOfEigenvectors m) {
            this(m.data);
        }

        public IComplexNumber getScalar(int i, int j) {
            int f = this.firstOfPair[j];
            int idx = f * this.n + i;
            if (f == j) {
                if (this.isComplex[f]) {
                    return new ComplexNumber(this.data[idx], this.data[idx + this.n]);
                }
                return new ComplexNumber(this.data[idx], 0.0);
            }
            return new ComplexNumber(this.data[idx], -this.data[idx + this.n]);
        }

        public IComplexNumber getScalar(int i, int j, IComplexNumber target) {
            int f = this.firstOfPair[j];
            int idx = f * this.n + i;
            if (f == j) {
                if (this.isComplex[f]) {
                    target.setComplex(this.data[idx], this.data[idx + this.n]);
                } else {
                    target.setComplex(this.data[idx], 0.0);
                }
            } else {
                target.setComplex(this.data[idx], -this.data[idx + this.n]);
            }
            return target;
        }

        @Override
        public double getRe(int i, int j) {
            int f = this.firstOfPair[j];
            int idx = f * this.n + i;
            return this.data[idx];
        }

        @Override
        public double getIm(int i, int j) {
            int f = this.firstOfPair[j];
            if (this.isComplex[f]) {
                int idx = f * this.n + i;
                return this.data[idx + this.n];
            }
            return 0.0;
        }

        @Override
        public int rows() {
            return this.n;
        }

        @Override
        public int columns() {
            return this.n;
        }

        @Override
        public void setRe(int row, int column, double value) {
            throw new UnsupportedOperationException("Writing not supported.");
        }

        @Override
        public void setIm(int row, int column, double value) {
            throw new UnsupportedOperationException("Writing not supported.");
        }

        @Override
        public void zero() {
            throw new UnsupportedOperationException("Writing not supported.");
        }

        @Override
        public void copyInto(IComplexArray target) {
            int j = 0;
            while (j < this.n) {
                int idx;
                int i;
                int f = this.firstOfPair[j];
                if (f == j) {
                    if (this.isComplex[f]) {
                        i = 0;
                        while (i < this.n) {
                            idx = f * this.n + i;
                            target.set(i, j, this.data[idx], this.data[idx + this.n]);
                            ++i;
                        }
                    } else {
                        i = 0;
                        while (i < this.n) {
                            idx = f * this.n + i;
                            target.set(i, j, this.data[idx], 0.0);
                            ++i;
                        }
                    }
                } else {
                    i = 0;
                    while (i < this.n) {
                        idx = f * this.n + i;
                        target.set(i, j, this.data[idx], -this.data[idx + this.n]);
                        ++i;
                    }
                }
                ++j;
            }
        }

        @Override
        public IComplexArray create(int _rows, int _cols) {
            return new DenseComplexArray(_rows, _cols);
        }

        @Override
        public IComplexArray create(int size) {
            return new DenseComplexArray(size, 1);
        }

        @Override
        public IComplexArray copy() {
            DenseComplexArray res = new DenseComplexArray(this.rows, this.cols);
            res.copyFrom(this);
            return res;
        }

        @Override
        public IDoubleArray viewReal() {
            return this;
        }

        @Override
        public IDoubleArray viewImaginary() {
            return new ImaginaryView(this);
        }

        @Override
        public boolean isSparse() {
            return false;
        }
    }

    private class VectorOfEigenvalues
    extends AbstractComplexArray {
        private int size;

        private VectorOfEigenvalues() {
            this.size = LapackEigenvalueDecomposition.this.size;
        }

        @Override
        public int rows() {
            return this.size;
        }

        @Override
        public int columns() {
            return 1;
        }

        @Override
        public double getRe(int i, int j) {
            if (j != 0) {
                throw new ArrayIndexOutOfBoundsException("Trying to access column " + j + " of a column vector");
            }
            return LapackEigenvalueDecomposition.this.wRealValues[i];
        }

        @Override
        public double getIm(int i, int j) {
            if (j != 0) {
                throw new ArrayIndexOutOfBoundsException("Trying to access column " + j + " of a column vector");
            }
            return LapackEigenvalueDecomposition.this.wImagValues[i];
        }

        @Override
        public double getRe(int i) {
            return LapackEigenvalueDecomposition.this.wRealValues[i];
        }

        @Override
        public double getIm(int i) {
            return LapackEigenvalueDecomposition.this.wImagValues[i];
        }

        @Override
        public void setRe(int i, int j, double value) {
            throw new UnsupportedOperationException("Read only vector.");
        }

        @Override
        public void setIm(int i, int j, double value) {
            throw new UnsupportedOperationException("Read only vector.");
        }

        @Override
        public void set(int i, int j, double real, double imaginary) {
            throw new UnsupportedOperationException("Read only vector.");
        }

        @Override
        public IComplexArray copy() {
            return new DenseComplexArray(this);
        }

        @Override
        public void copyFrom(IComplexArray other) {
            throw new UnsupportedOperationException("Read only vector.");
        }

        @Override
        public void zero() {
            throw new UnsupportedOperationException("Read only vector.");
        }

        @Override
        public IComplexArray create(int size) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public IComplexArray create(int rows, int cols) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public IDoubleArray viewReal() {
            return this;
        }

        @Override
        public IDoubleArray viewImaginary() {
            return new ImaginaryView(this);
        }

        @Override
        public boolean isSparse() {
            return false;
        }
    }
}

