/*
 * Decompiled with CFR 0.152.
 */
package stallone.algebra.extern;

import com.github.fommil.netlib.ARPACK;
import java.util.HashMap;
import java.util.Map;
import org.netlib.util.doubleW;
import org.netlib.util.intW;
import stallone.algebra.EigenvalueDecomposition;
import stallone.api.algebra.Algebra;
import stallone.api.algebra.IComplexNumber;
import stallone.api.algebra.IEigenvalueDecomposition;
import stallone.api.algebra.IEigenvalueSolver;
import stallone.api.complex.Complex;
import stallone.api.complex.IComplexArray;
import stallone.api.doubles.Doubles;
import stallone.api.doubles.IDoubleArray;
import stallone.complex.ComplexNumber;
import stallone.io.Log;

public class SparseArpackEigenvalueDecomposition
implements IEigenvalueSolver {
    protected IDoubleArray matrix;
    private int nev;
    private double tolerance = 1.0E-15;
    private int maxIter = 100;
    private IComplexArray eigenvalues;
    private IComplexArray rightEigenvectors;
    private boolean bRightComputation = true;
    private static Map<Integer, String> snaupdErrors = new HashMap<Integer, String>();
    private IEigenvalueDecomposition result;

    static {
        snaupdErrors.put(1, "The Schur form computed by LAPACK routine dlahqrcould not be reordered by LAPACK routine dtrsen.Re-enter subroutine DNEUPD with IPARAM(5)=NCV andincrease the size of the arrays DR and DI to havedimension at least dimension NCV and allocate at least NCVcolumns for Z. NOTE: Not necessary if Z and V sharethe same space. Please notify the authors if this erroroccurs.");
        snaupdErrors.put(-1, "N must be positive.");
        snaupdErrors.put(-2, "NEV must be positive.");
        snaupdErrors.put(-3, "NCV-NEV >= 2 and less than or equal to N.");
        snaupdErrors.put(-5, "WHICH must be one of 'LM', 'SM', 'LR', 'SR', 'LI', 'SI'");
        snaupdErrors.put(-6, "BMAT must be one of 'I' or 'G'.");
        snaupdErrors.put(-7, "Length of private work WORKL array is not sufficient.");
        snaupdErrors.put(-8, "Error return from calculation of a real Schur form.Informational error from LAPACK routine dlahqr.");
        snaupdErrors.put(-9, "Error return from calculation of eigenvectors.Informational error from LAPACK routine dtrevc.");
        snaupdErrors.put(-10, "IPARAM(7) must be 1,2,3,4.");
        snaupdErrors.put(-11, "IPARAM(7) = 1 and BMAT = 'G' are incompatible.");
        snaupdErrors.put(-12, "HOWMNY = 'S' not yet implemented");
        snaupdErrors.put(-13, "HOWMNY must be one of 'A' or 'P' if RVEC = .true.");
        snaupdErrors.put(-14, "DNAUPD did not find any eigenvalues to sufficient accuracy");
    }

    public SparseArpackEigenvalueDecomposition(IDoubleArray matrix) throws IllegalArgumentException {
        if (!matrix.isSparse()) {
            throw new IllegalArgumentException("matrix is not sparse. One should use dense solver instead.");
        }
        this.matrix = matrix;
    }

    @Override
    public void perform() throws RuntimeException {
        if (!this.bRightComputation) {
            throw new RuntimeException("should not compute right eigenvectors, but this is the only supported operation.");
        }
        if (this.nev == 0) {
            Log.logError("ARPACK eigensolver: number of requested eigenvalues not set. Defaulting to 1.");
            this.setNumberOfRequestedEigenvalues(1);
        }
        int n = this.matrix.columns();
        int ncv = 2 * this.nev;
        System.out.println("NEV = " + this.nev);
        System.out.println("NCV = " + ncv);
        System.out.println("NCV-NEV = " + (ncv - this.nev));
        System.out.println("n = " + n);
        if (ncv > n) {
            throw new RuntimeException("constraint NCV(" + ncv + ") >= N(" + n + ") not satisfied.");
        }
        if (ncv - this.nev < 2) {
            throw new RuntimeException("constraint 2 <= NCV-NEV = " + (ncv - this.nev) + " not satisfied.");
        }
        IDoubleArray x = Doubles.create.array(n);
        IDoubleArray y = Doubles.create.array(n);
        String bmat = "I";
        String which = "LM";
        double[] resid = new double[n];
        double[] workd = new double[3 * n];
        int lworkl = 3 * (int)Math.pow(ncv, 2.0) + 6 * ncv;
        double[] workl = new double[lworkl];
        System.out.println("WORKL length = " + lworkl);
        double[] v = new double[n * ncv];
        System.out.println("Arnoldi basis length = " + v.length);
        intW info = new intW(0);
        doubleW tol = new doubleW(this.tolerance);
        boolean ishfts = true;
        int maxitr = Math.max(n, this.maxIter);
        boolean mode1 = true;
        int[] nArray = new int[11];
        nArray[0] = 1;
        nArray[2] = maxitr;
        nArray[6] = 1;
        int[] iparam = nArray;
        int[] ipntr = new int[14];
        intW ido = new intW(0);
        this.calculate(n, x, y, "I", "LM", ncv, resid, workd, lworkl, workl, v, info, tol, iparam, ipntr, ido);
        this.postprocess(n, "I", "LM", ncv, resid, workd, lworkl, workl, v, info, tol, iparam, ipntr);
        this.result = new EigenvalueDecomposition(null, this.eigenvalues, this.rightEigenvectors);
    }

    private void calculate(int n, IDoubleArray x, IDoubleArray y, String bmat, String which, int ncv, double[] resid, double[] workd, int lworkl, double[] workl, double[] v, intW info, doubleW tol, int[] iparam, int[] ipntr, intW ido) {
        ARPACK arpack = ARPACK.getInstance();
        do {
            arpack.dnaupd(ido, bmat, n, which, this.nev, tol, resid, ncv, v, n, iparam, ipntr, workd, workl, lworkl, info);
            if (ido.val == 99) break;
            int pos = ipntr[0] - 1;
            while (pos < ipntr[0] - 1 + n) {
                x.set(pos - (ipntr[0] - 1), workd[pos]);
                ++pos;
            }
            Algebra.util.product(this.matrix, x, y);
            pos = ipntr[1] - 1;
            while (pos < ipntr[1] - 1 + n) {
                workd[pos] = y.get(pos - (ipntr[1] - 1));
                ++pos;
            }
        } while (ido.val == -1 || ido.val == 1);
    }

    private void postprocess(int n, String bmat, String which, int ncv, double[] resid, double[] workd, int lworkl, double[] workl, double[] v, intW info, doubleW tol, int[] iparam, int[] ipntr) throws RuntimeException {
        if (info.val < 0) {
            String err = snaupdErrors.get(info.val);
            throw new RuntimeException("ARPACK error: snaupd(1) returned with info = " + info.val + "\n" + err);
        }
        boolean rvec = true;
        double sigmar = 0.0;
        double sigmai = 0.0;
        intW ierr = new intW(0);
        boolean[] select = new boolean[ncv];
        double[] dReal = new double[this.nev + 2];
        double[] dImg = new double[this.nev + 2];
        double[] z = new double[n * (this.nev + 1)];
        double[] workev = new double[3 * ncv];
        ARPACK.getInstance().dneupd(true, "A", select, dReal, dImg, z, n, sigmar, sigmai, workev, bmat, n, which, new intW(this.nev), tol.val, resid, ncv, v, n, iparam, ipntr, workd, workl, lworkl, ierr);
        if (ierr.val != 0) {
            String error = snaupdErrors.get(ierr.val);
            throw new RuntimeException("ARPACK error: dneupd returned with info = " + ierr.val + "\n" + error);
        }
        this.eigenvalues = Complex.create.array(this.nev);
        this.rightEigenvectors = Complex.create.array(n, this.nev);
        int i = 0;
        while (i < this.nev) {
            int source;
            this.eigenvalues.set(i, dReal[i], dImg[i]);
            int dest = 0;
            if (dImg[i] == 0.0) {
                source = i * n;
                while (source < i * n + n) {
                    this.rightEigenvectors.set(dest++, i, z[source]);
                    ++source;
                }
            } else if (dImg[i] > 0.0) {
                source = i * n;
                while (source < i * n + n) {
                    this.rightEigenvectors.set(dest++, i, z[source], z[source + n]);
                    ++source;
                }
            } else {
                source = i * n;
                while (source < i * n + n) {
                    this.rightEigenvectors.set(dest++, i, z[source - n], -z[source]);
                    ++source;
                }
            }
            ++i;
        }
    }

    @Override
    public IEigenvalueDecomposition getResult() {
        return this.result;
    }

    @Override
    public void setMatrix(IDoubleArray m) {
        this.matrix = m;
    }

    public int getNumberOfAvailableEigenvectors() {
        return this.matrix.columns() - 2;
    }

    @Override
    public void setPerformRightComputation(boolean right) {
        this.bRightComputation = right;
    }

    public IComplexNumber getEigenvalue(int i) {
        return new ComplexNumber(this.eigenvalues.getRe(i), this.eigenvalues.getIm(i));
    }

    public IComplexArray getEigenvalues() {
        return this.eigenvalues;
    }

    public IComplexArray getRightEigenvectorMatrix() {
        return this.rightEigenvectors;
    }

    public IComplexArray getRightEigenvector(int i) {
        return this.rightEigenvectors.viewColumn(i);
    }

    public IComplexArray getLeftEigenvectorMatrix() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setPerformLeftComputation(boolean left) {
        if (left) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public IComplexArray getLeftEigenvector(int i) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNumberOfRequestedEigenvalues(int _nev) {
        if (_nev > this.matrix.columns()) {
            throw new IllegalArgumentException("there cannot be more eigenvalues than columns of matrix.");
        }
        this.nev = _nev;
    }
}

