/*
 * Decompiled with CFR 0.152.
 */
package stallone.api.algebra;

import stallone.algebra.ArrayDifference;
import stallone.algebra.ArrayElementDivide;
import stallone.algebra.ArrayElementProduct;
import stallone.algebra.ArrayNorm;
import stallone.algebra.ArrayNumericalEquality;
import stallone.algebra.ArrayScale;
import stallone.algebra.ArraySum;
import stallone.algebra.ArrayTranspose;
import stallone.algebra.InnerProduct;
import stallone.algebra.MatrixProduct;
import stallone.algebra.ScalarNumericalEquality;
import stallone.api.algebra.Algebra;
import stallone.api.algebra.IComplexNumber;
import stallone.api.algebra.IEigenvalueDecomposition;
import stallone.api.algebra.IEigenvalueSolver;
import stallone.api.algebra.ILUDecomposition;
import stallone.api.algebra.ILinearMatrixSystem;
import stallone.api.algebra.ILinearSystem;
import stallone.api.algebra.INorm;
import stallone.api.complex.Complex;
import stallone.api.complex.IComplexArray;
import stallone.api.complex.IComplexIterator;
import stallone.api.doubles.Doubles;
import stallone.api.doubles.IDoubleArray;
import stallone.api.doubles.IDoubleIterator;
import stallone.complex.ComplexNumber;
import stallone.doubles.DoubleArrayTest;

public class AlgebraUtilities {
    private INorm norm = new ArrayNorm();
    private ArraySum vsum = new ArraySum();
    private ArrayDifference vdiff = new ArrayDifference();
    private ArrayScale vscale = new ArrayScale();
    private InnerProduct vdot = new InnerProduct(true);
    private ArrayTranspose trans = new ArrayTranspose();
    private MatrixProduct mprod = new MatrixProduct();
    private ArrayElementProduct elprod = new ArrayElementProduct();
    private ArrayElementDivide eldiv = new ArrayElementDivide();
    private ArrayNumericalEquality arrequal = new ArrayNumericalEquality();
    private ScalarNumericalEquality scalarequal = new ScalarNumericalEquality();

    public boolean isSquare(IDoubleArray matrix) {
        return matrix.rows() == matrix.columns();
    }

    public boolean isSymmetric(IDoubleArray matrix) {
        boolean result = this.isSquare(matrix);
        if (result) {
            int dimension = matrix.rows();
            int i = 0;
            while (i < dimension) {
                int j = i;
                while (j < dimension) {
                    if (matrix.get(i, j) != matrix.get(j, i)) {
                        result = false;
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return result;
    }

    public double norm(IDoubleArray v) {
        return this.norm.norm(v);
    }

    public double norm(IDoubleArray v, int p) {
        return this.norm.norm(v, p);
    }

    public double distance(IDoubleArray v1, IDoubleArray v2) {
        return this.norm(this.subtract(v1, v2));
    }

    public void addTo(IComplexArray v1, IComplexArray v2) {
        this.add(v1, v2, v1);
    }

    public void addTo(IComplexArray v1, IComplexNumber c) {
        IComplexIterator it = v1.complexIterator();
        while (it.hasNext()) {
            it.set(it.getRe() + c.getRe(), it.getIm() + c.getIm());
            it.advance();
        }
    }

    public IComplexArray add(IComplexArray v1, IComplexArray v2) {
        IComplexArray target = Complex.create.array(v1.size(), v2.size());
        return this.add(v1, v2, target);
    }

    public IComplexArray add(IComplexArray v1, IComplexArray v2, IComplexArray target) {
        this.vsum.sumDense(v1, v2, target);
        return target;
    }

    public IComplexArray addWeightedToNew(double a1, IComplexArray v1, double a2, IComplexArray v2) {
        IComplexArray h1 = this.scaleToNew(a1, v1);
        IComplexArray h2 = this.scaleToNew(a2, v2);
        this.addTo(h1, h2);
        return h1;
    }

    public void addTo(IDoubleArray v1, IDoubleArray v2) {
        this.add(v1, v2, v1);
    }

    public void addTo(IDoubleArray v1, double c) {
        IDoubleIterator it = v1.iterator();
        while (it.hasNext()) {
            it.set(it.get() + c);
            it.advance();
        }
    }

    public IDoubleArray add(IDoubleArray v1, IDoubleArray v2) {
        IDoubleArray target = Doubles.create.array(v1.rows(), v1.columns());
        return this.add(v1, v2, target);
    }

    public IDoubleArray add(IDoubleArray v1, IDoubleArray v2, IDoubleArray target) {
        this.vsum.sumDense(v1, v2, target);
        return target;
    }

    public IDoubleArray addWeightedToNew(double a1, IDoubleArray v1, double a2, IDoubleArray v2) {
        IDoubleArray h1 = this.scaleToNew(a1, v1);
        IDoubleArray h2 = this.scaleToNew(a2, v2);
        this.addTo(h1, h2);
        return h1;
    }

    public IDoubleArray subtract(IDoubleArray v1, IDoubleArray v2) {
        return this.subtract(v1, v2, v1.copy());
    }

    public IDoubleArray subtract(IDoubleArray v1, IDoubleArray v2, IDoubleArray target) {
        this.vdiff.subtractDense(v1, v2, target);
        return target;
    }

    public IComplexArray multiplyElementsToNew(IComplexArray arr1, IComplexArray arr2) {
        return this.elprod.multiplyToNewDense(arr1, arr2);
    }

    public IDoubleArray multiplyElementsToNew(IDoubleArray arr1, IDoubleArray arr2) {
        if (arr1.isSparse() || arr2.isSparse()) {
            return this.elprod.multiplyToNewSparse(arr1, arr2);
        }
        return this.elprod.multiplyToNewDense(arr1, arr2);
    }

    public IDoubleArray divideElementsToNew(IDoubleArray arr1, IDoubleArray arr2) {
        return this.eldiv.divideToNewDense(arr1, arr2);
    }

    public IComplexNumber dotComplex(IComplexArray v1, IComplexArray v2) {
        return this.dotComplexWeighted(v1, v2, null);
    }

    public IComplexNumber dotComplex(IComplexArray v1, IComplexArray v2, IComplexNumber target) {
        return this.dotComplexWeighted(v1, v2, null, target);
    }

    public IComplexNumber dotComplexWeighted(IComplexArray v1, IComplexArray v2, IDoubleArray w, IComplexNumber target) {
        return this.vdot.innerProduct(v1, v2, w, target);
    }

    public IComplexNumber dotComplexWeighted(IComplexArray v1, IComplexArray v2, IDoubleArray w) {
        ComplexNumber target = new ComplexNumber(0.0, 0.0);
        this.vdot.innerProduct(v1, v2, w, target);
        return target;
    }

    public double dot(IDoubleArray v1, IDoubleArray v2) {
        return this.vdot.innerProduct(v1, v2);
    }

    public double dot(IDoubleArray v1, IDoubleArray v2, IDoubleArray w) {
        return this.vdot.innerProduct(v1, v2, w);
    }

    public void negate(IComplexArray arr) {
        this.scale(-1.0, arr);
    }

    public void negate(IDoubleArray arr) {
        this.scale(-1.0, arr);
    }

    public void invertElements(IDoubleArray arr) {
        int i = 0;
        while (i < arr.size()) {
            arr.set(i, 1.0 / arr.get(i));
            ++i;
        }
    }

    public void square(IDoubleArray arr) {
        int i = 0;
        while (i < arr.size()) {
            arr.set(i, arr.get(i) * arr.get(i));
            ++i;
        }
    }

    public double sum(IDoubleArray arr) {
        double res = 0.0;
        IDoubleIterator it = arr.nonzeroIterator();
        while (it.hasNext()) {
            res += it.get();
            it.advance();
        }
        return res;
    }

    public IDoubleArray rowSums(IDoubleArray arr) {
        double[] rowsums = new double[arr.rows()];
        IDoubleIterator it = arr.nonzeroIterator();
        while (it.hasNext()) {
            int n = it.row();
            rowsums[n] = rowsums[n] + it.get();
            it.advance();
        }
        return Doubles.create.array(rowsums);
    }

    public IDoubleArray columnSums(IDoubleArray arr) {
        double[] colsums = new double[arr.columns()];
        IDoubleIterator it = arr.nonzeroIterator();
        while (it.hasNext()) {
            int n = it.column();
            colsums[n] = colsums[n] + it.get();
            it.advance();
        }
        return Doubles.create.array(colsums);
    }

    public IComplexNumber sum(IComplexArray arr) {
        double re = 0.0;
        double im = 0.0;
        IComplexIterator it = arr.nonzeroComplexIterator();
        while (it.hasNext()) {
            re += it.getRe();
            im += it.getIm();
            it.advance();
        }
        return new ComplexNumber(re, im);
    }

    public IComplexArray scaleToNew(IComplexNumber s, IComplexArray v, IDoubleArray target) {
        IComplexArray res = v.copy();
        this.vscale.scale(v, s, res);
        return res;
    }

    public IComplexArray scaleToNew(IComplexNumber s, IComplexArray v) {
        return this.scaleToNew(s, v, v.copy());
    }

    public IComplexArray scaleToNew(double s, IComplexArray v) {
        return this.scaleToNew(new ComplexNumber(s, 0.0), v, v.copy());
    }

    public void scale(IComplexNumber s, IComplexArray v) {
        this.vscale.scale(v, s);
    }

    public void scale(double s, IComplexArray v) {
        this.vscale.scale(v, new ComplexNumber(s, 0.0));
    }

    public IDoubleArray scaleToNew(double s, IDoubleArray v) {
        IDoubleArray res = v.copy();
        this.vscale.scale(v, s, res);
        return res;
    }

    public void scale(double s, IDoubleArray v) {
        this.vscale.scale(v, s);
    }

    public void normalizeRows(IDoubleArray M, int p) {
        double[] rownorms = new double[M.rows()];
        int i = 0;
        while (i < rownorms.length) {
            rownorms[i] = this.norm(M.viewRow(i), p);
            ++i;
        }
        IDoubleIterator it = M.nonzeroIterator();
        while (it.hasNext()) {
            it.set(it.get() / rownorms[it.row()]);
            it.advance();
        }
    }

    public void normalize(IDoubleArray v) {
        this.scale(1.0 / this.norm(v), v);
    }

    public void normalize(IDoubleArray v, int p) {
        this.scale(1.0 / this.norm(v, p), v);
    }

    public IDoubleArray createNormalized(IDoubleArray v) {
        return this.scaleToNew(1.0 / this.norm(v), v);
    }

    public IDoubleArray createNormalized(IDoubleArray v, int p) {
        return this.scaleToNew(1.0 / this.norm(v, p), v);
    }

    public IDoubleArray product(IComplexArray v, IComplexArray m) {
        return this.mprod.multiplyToNew(v, m);
    }

    public IComplexArray product(IComplexArray v, IComplexArray m, IComplexArray target) {
        this.mprod.multiply(v, m, target);
        return target;
    }

    public IDoubleArray product(IDoubleArray v, IDoubleArray m) {
        return this.mprod.multiplyToNew(v, m);
    }

    public IDoubleArray product(IDoubleArray v, IDoubleArray m, IDoubleArray target) {
        this.mprod.multiply(v, m, target);
        return target;
    }

    public IDoubleArray power(IDoubleArray M, int p) {
        if (p < 0) {
            throw new IllegalArgumentException("Trying to raise matrix to a negative power. Use Matrix inverse explicitly if desired");
        }
        if (p == 0) {
            return Doubles.create.diag(M.rows(), 1.0);
        }
        IDoubleArray res = M.copy();
        int i = 1;
        while (i < p) {
            res = this.product(res, M);
            ++i;
        }
        return res;
    }

    public IComplexArray transposeToNew(IComplexArray m) {
        return this.trans.conjugateTransposeToNew(m);
    }

    public void transpose(IComplexArray m) {
        this.trans.conjugateTranspose(m);
    }

    public IDoubleArray transposeToNew(IDoubleArray m) {
        return this.trans.transposeToNew(m);
    }

    public void transpose(IDoubleArray m) {
        this.trans.transpose(m);
    }

    public IDoubleArray inverse(IDoubleArray m) {
        if (m.columns() != m.rows()) {
            throw new IllegalArgumentException("Matrix must be square.");
        }
        IDoubleArray identity = Doubles.create.identity(m.columns());
        ILinearMatrixSystem matrixSystem = Algebra.create.linearMatrixSolver(m, identity);
        matrixSystem.perform();
        return matrixSystem.getSolutionMatrix();
    }

    public double det(IDoubleArray m) {
        ILUDecomposition decomposition = Algebra.create.LUSolver(m);
        decomposition.perform();
        return decomposition.det();
    }

    public double trace(IDoubleArray M) {
        double tr = 0.0;
        int i = 0;
        while (i < M.rows()) {
            tr += M.get(i, i);
            ++i;
        }
        return tr;
    }

    public IEigenvalueDecomposition evd(IDoubleArray matrix) {
        IEigenvalueSolver solver = Algebra.create.eigensolverDense(matrix);
        solver.perform();
        return solver.getResult();
    }

    public IEigenvalueDecomposition evd(IDoubleArray matrix, boolean computeLeftEV, boolean computeRightEV) {
        IEigenvalueSolver solver = Algebra.create.eigensolverDense(matrix, computeLeftEV, computeRightEV);
        solver.perform();
        return solver.getResult();
    }

    public IEigenvalueDecomposition evdSparse(IDoubleArray matrix, int nev) {
        IEigenvalueSolver solver = Algebra.create.eigensolverSparse(matrix, nev);
        solver.perform();
        return solver.getResult();
    }

    public IEigenvalueDecomposition evd(IDoubleArray matrix, int nev) {
        IEigenvalueSolver solver = Algebra.create.eigensolver(matrix, nev);
        solver.perform();
        return solver.getResult();
    }

    public IEigenvalueDecomposition evd(IDoubleArray matrix, String algoName) {
        IEigenvalueSolver solver = Algebra.create.eigensolver(matrix, algoName);
        solver.perform();
        return solver.getResult();
    }

    public IDoubleArray solve(IDoubleArray A, IDoubleArray b) {
        IDoubleArray res = null;
        if (b.order() == 1) {
            ILinearSystem solver = Algebra.create.linearSolver(A, b);
            solver.perform();
            res = solver.getSolutionVector();
        } else {
            ILinearMatrixSystem solver = Algebra.create.linearMatrixSolver(A, b);
            solver.perform();
            res = solver.getSolutionMatrix();
        }
        return res;
    }

    public IDoubleArray solve(IDoubleArray A, IDoubleArray b, String algoName) {
        DoubleArrayTest.assertOrder(b, 1);
        ILinearSystem solver = Algebra.create.linearSolver(A, b, algoName);
        solver.perform();
        IDoubleArray res = solver.getSolutionVector();
        return res;
    }

    public boolean numericallyEquals(IDoubleArray o1, IDoubleArray o2, double precision) {
        return this.arrequal.numericallyEqual(o1, o2, precision);
    }

    public boolean numericallyEquals(IComplexNumber o1, IComplexNumber o2, double precision) {
        return this.scalarequal.numericallyEqual(o1, o2, precision);
    }
}

