/*
 * Decompiled with CFR 0.152.
 */
package stallone.api.complex;

import stallone.api.algebra.IComplexNumber;
import stallone.api.complex.IComplexArray;
import stallone.complex.ComplexNumber;
import stallone.complex.DenseComplexArray;

public class ComplexFactory {
    public IComplexArray array(int size) {
        DenseComplexArray res = new DenseComplexArray(size, 1);
        return res;
    }

    public IComplexArray array(int rows, int cols) {
        DenseComplexArray res = new DenseComplexArray(rows, cols);
        return res;
    }

    public IComplexArray array(double[][] real, double[][] imag) {
        IComplexArray res = this.array(real.length, real[0].length);
        int i = 0;
        while (i < real.length) {
            int j = 0;
            while (j < real[i].length) {
                res.set(i, j, real[i][j], imag[i][j]);
                ++j;
            }
            ++i;
        }
        return res;
    }

    public IComplexArray array(IComplexNumber[][] values) {
        return new DenseComplexArray(values);
    }

    public IComplexArray row(int dimension) {
        return this.array(1, dimension);
    }

    public IComplexArray row(double[] re, double[] im) {
        IComplexArray res = this.row(re.length);
        int i = 0;
        while (i < re.length) {
            res.set(i, re[i], im[i]);
            ++i;
        }
        return res;
    }

    public IComplexArray column(int dimension) {
        return this.array(dimension, 1);
    }

    public IComplexArray column(double[] re, double[] im) {
        IComplexArray res = this.column(re.length);
        int i = 0;
        while (i < re.length) {
            res.set(i, re[i], im[i]);
            ++i;
        }
        return res;
    }

    public IComplexArray diag(int size, double value) {
        IComplexArray M = this.array(size, size);
        int i = 0;
        while (i < size) {
            M.set(i, i, value);
            ++i;
        }
        return M;
    }

    public IComplexArray diag(double ... values) {
        IComplexArray M = this.array(values.length, values.length);
        int i = 0;
        while (i < values.length) {
            M.set(i, i, values[i]);
            ++i;
        }
        return M;
    }

    public IComplexArray diag(IComplexArray values) {
        IComplexArray M = this.array(values.size(), values.size());
        int i = 0;
        while (i < values.size()) {
            M.set(i, i, values.getRe(i), values.getIm(i));
            ++i;
        }
        return M;
    }

    public IComplexArray identity(int dim) {
        IComplexArray identityMatrix = this.array(dim, dim);
        int i = 0;
        while (i < dim) {
            identityMatrix.set(i, i, 1.0);
            ++i;
        }
        return identityMatrix;
    }

    public IComplexNumber complexScalar(double real, double imaginary) {
        return new ComplexNumber(real, imaginary);
    }

    public IComplexNumber complexScalar() {
        return new ComplexNumber(0.0, 0.0);
    }
}

