/*
 * Decompiled with CFR 0.152.
 */
package stallone.api.coordinates;

import stallone.api.API;
import stallone.api.coordinates.ICoordinateTransform;
import stallone.api.coordinates.IPCA;
import stallone.api.coordinates.ITICA;
import stallone.api.datasequence.IDataInput;
import stallone.api.datasequence.IDataSequence;
import stallone.api.doubles.IDoubleArray;
import stallone.coordinates.AbstractCoordinateTransform;
import stallone.coordinates.MinimalRMSDistance3D;
import stallone.coordinates.PCA;
import stallone.coordinates.TICA;
import stallone.doubles.DenseDoubleArray;
import stallone.doubles.PrimitiveDoubleTools;

public class CoordinateFactory {
    public ICoordinateTransform transform_minrmsd(final IDoubleArray Xref) {
        return new AbstractCoordinateTransform(1){
            MinimalRMSDistance3D minrmsd;
            {
                super($anonymous0);
                this.minrmsd = new MinimalRMSDistance3D(iDoubleArray.rows());
            }

            @Override
            public void transform(IDoubleArray in, IDoubleArray out) {
                out.set(0, this.minrmsd.distance(Xref, in));
            }
        };
    }

    public ICoordinateTransform transform_distances(final int[] set1) {
        return new AbstractCoordinateTransform(set1.length * (set1.length - 1) / 2){

            @Override
            public void transform(IDoubleArray in, IDoubleArray out) {
                API.coor.distances(in, set1, out);
            }
        };
    }

    public ICoordinateTransform transform_distances(final int[] set1, final int[] set2) {
        return new AbstractCoordinateTransform(set1.length, set2.length){

            @Override
            public void transform(IDoubleArray in, IDoubleArray out) {
                API.coor.distanceMatrix(in, set1, set2, out);
            }
        };
    }

    public ICoordinateTransform transform_distances(final int[][] set1) {
        return new AbstractCoordinateTransform(set1.length * (set1.length - 1) / 2){

            @Override
            public void transform(IDoubleArray in, IDoubleArray out) {
                API.coor.distances(in, set1, out);
            }
        };
    }

    public ICoordinateTransform transform_distances(final int[][] set1, final int[][] set2) {
        return new AbstractCoordinateTransform(set1.length, set2.length){

            @Override
            public void transform(IDoubleArray in, IDoubleArray out) {
                API.coor.distanceMatrix(in, set1, set2, out);
            }
        };
    }

    public ICoordinateTransform transform_angles(final int[][] selection) {
        return new AbstractCoordinateTransform(selection.length){

            @Override
            public void transform(IDoubleArray in, IDoubleArray out) {
                API.coor.angles(in, selection, out);
            }
        };
    }

    public ICoordinateTransform transform_dihedrals(int[][] selection) {
        return this.transform_angles(selection);
    }

    public ICoordinateTransform transform_selection(final int[] selection) {
        return new AbstractCoordinateTransform(selection.length, 3){

            @Override
            public void transform(IDoubleArray in, IDoubleArray out) {
                API.coor.select(in, selection, out);
            }
        };
    }

    public ICoordinateTransform linear_operator(final IDoubleArray A) {
        int rows = A.rows();
        int cols = 1;
        return new AbstractCoordinateTransform(rows, cols){

            @Override
            public void transform(IDoubleArray in, IDoubleArray out) {
                IDoubleArray input = in;
                if (in.rows() * in.columns() == A.columns()) {
                    double[] flat = null;
                    flat = in instanceof DenseDoubleArray ? ((DenseDoubleArray)in).getArray() : PrimitiveDoubleTools.flatten(in.getTable());
                    input = new DenseDoubleArray(flat);
                }
                API.alg.product(A, input, out);
            }
        };
    }

    public IPCA pca(IDataInput datainput) {
        return new PCA(datainput);
    }

    public IPCA pca(IDataSequence X) {
        return new PCA(X);
    }

    public ITICA tica(IDataInput input, int lagtime) {
        return new TICA(input, lagtime);
    }

    public ITICA tica(IDataSequence X, int lagtime) {
        return new TICA(X, lagtime);
    }
}

