/*
 * Decompiled with CFR 0.152.
 */
package stallone.api.doubles;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import stallone.api.doubles.Doubles;
import stallone.api.doubles.IDoubleArray;
import stallone.api.doubles.IDoubleList;
import stallone.api.strings.Strings;
import stallone.doubles.DenseDoubleArray;
import stallone.doubles.DiagonalMatrix;
import stallone.doubles.DoubleArrayList_FastUtilWrapper;
import stallone.doubles.DoubleIO;
import stallone.doubles.ForeignBufferDoubleArray;
import stallone.doubles.PrimitiveDoubleTools;
import stallone.doubles.SparseRealMatrix;
import stallone.doubles.SparseRealVector;
import stallone.doubles.SymmetricMatrix;

public class DoubleFactory {
    public IDoubleArray denseColumn(int size) {
        return new DenseDoubleArray(new double[size]);
    }

    public IDoubleArray denseRow(int size) {
        return new DenseDoubleArray(1, size);
    }

    public IDoubleArray sparseColumn(int size) {
        return new SparseRealVector(size);
    }

    public IDoubleArray sparseRow(int size) {
        return new SparseRealMatrix(1, size);
    }

    public IDoubleArray column(int size) {
        if (size < 25000000) {
            return this.denseColumn(size);
        }
        return this.sparseColumn(size);
    }

    public IDoubleArray row(int size) {
        if (size < 25000000) {
            return this.denseRow(size);
        }
        return this.sparseRow(size);
    }

    public IDoubleArray array(int size) {
        return this.column(size);
    }

    public IDoubleArray array(double[] init) {
        return new DenseDoubleArray(init);
    }

    public IDoubleArray denseMatrix(int nrows, int ncols) {
        return new DenseDoubleArray(nrows, ncols);
    }

    public IDoubleArray sparseMatrix(int nrows, int ncols) {
        return new SparseRealMatrix(nrows, ncols);
    }

    public IDoubleArray array(double[][] init) {
        return new DenseDoubleArray(init);
    }

    public IDoubleArray array(int rows, int cols) {
        if (rows < 5000 && cols < 5000) {
            if (cols == 1) {
                return this.column(rows);
            }
            if (rows == 1) {
                return this.row(cols);
            }
            return this.denseMatrix(rows, cols);
        }
        if (cols == 1) {
            return this.sparseColumn(rows);
        }
        if (rows == 1) {
            return this.sparseRow(cols);
        }
        return this.sparseMatrix(rows, cols);
    }

    public IDoubleArray fromFile(String filename) throws FileNotFoundException, IOException {
        return DoubleIO.readDoubleMatrix(filename);
    }

    public IDoubleArray array(int size, double value) {
        IDoubleArray res = this.array(size);
        Doubles.util.fill(res, value);
        return res;
    }

    public IDoubleArray array(int size, boolean allocateInSysMem) {
        IDoubleArray res;
        if (allocateInSysMem) {
            ByteBuffer bb = ByteBuffer.allocateDirect(size * 64);
            res = new ForeignBufferDoubleArray(bb, 1, size);
        } else {
            res = this.array(size);
        }
        return res;
    }

    public IDoubleArray array(String from) {
        IDoubleArray res = this.array(Strings.util.toDoubleArray(from));
        return res;
    }

    public IDoubleArray arrayFrom(double d) {
        DenseDoubleArray res = new DenseDoubleArray(1);
        res.set(0, d);
        return res;
    }

    public IDoubleArray arrayFrom(double d1, double ... d2) {
        DenseDoubleArray res = new DenseDoubleArray(1 + d2.length);
        res.set(0, d1);
        int i = 0;
        while (i < d2.length) {
            res.set(i + 1, d2[i]);
            ++i;
        }
        return res;
    }

    public IDoubleArray arrayFrom(double[] arr) {
        return this.array(arr);
    }

    public IDoubleArray arrayFrom(ByteBuffer b, int rows, int cols) {
        return new ForeignBufferDoubleArray(b, rows, cols);
    }

    public IDoubleArray arrayFrom(int[] a) {
        DenseDoubleArray res = new DenseDoubleArray(a.length);
        int i = 0;
        while (i < a.length) {
            res.set(i, a[i]);
            ++i;
        }
        return res;
    }

    public IDoubleArray arrayFrom(float[] a) {
        DenseDoubleArray res = new DenseDoubleArray(a.length);
        int i = 0;
        while (i < a.length) {
            res.set(i, a[i]);
            ++i;
        }
        return res;
    }

    public IDoubleArray arrayRandom(int n) {
        double[] res = PrimitiveDoubleTools.randomArray(n);
        return this.array(res);
    }

    public IDoubleArray arrayRange(double start, double end, double step) {
        double[] res = PrimitiveDoubleTools.range(start, end, step);
        return this.array(res);
    }

    public IDoubleArray arrayGrid(double min, double max, int ngridpoints) {
        IDoubleArray grid = Doubles.create.array(ngridpoints);
        double dg = (max - min) / ((double)ngridpoints - 1.0);
        grid.set(0, min);
        int i = 1;
        while (i < grid.size()) {
            grid.set(i, grid.get(i - 1) + dg);
            ++i;
        }
        return grid;
    }

    public IDoubleArray matrix(int nrows, int ncols) {
        return new DenseDoubleArray(nrows, ncols);
    }

    public IDoubleArray matrix(int nrows, int ncols, double value) {
        DenseDoubleArray res = new DenseDoubleArray(nrows, ncols);
        int i = 0;
        while (i < res.size()) {
            res.set(i, value);
            ++i;
        }
        return res;
    }

    public IDoubleArray matrix(double[][] res) {
        return new DenseDoubleArray(res);
    }

    public IDoubleArray matrix(String from) {
        return this.array(Strings.util.toDoubleTable(from));
    }

    public IDoubleArray matrixFrom(float[][] a) {
        DenseDoubleArray res = new DenseDoubleArray(a.length, a[0].length);
        int i = 0;
        while (i < a.length) {
            int j = 0;
            while (j < a[i].length) {
                res.set(i, j, a[i][j]);
                ++j;
            }
            ++i;
        }
        return res;
    }

    public IDoubleArray matrixFrom(int[][] a) {
        DenseDoubleArray res = new DenseDoubleArray(a.length, a[0].length);
        int i = 0;
        while (i < a.length) {
            int j = 0;
            while (j < a[i].length) {
                res.set(i, j, a[i][j]);
                ++j;
            }
            ++i;
        }
        return res;
    }

    public IDoubleArray diag(int size, double value) {
        double[] diag = new double[size];
        Arrays.fill(diag, value);
        return new DiagonalMatrix(diag);
    }

    public IDoubleArray diag(double ... values) {
        return new DiagonalMatrix(values);
    }

    public IDoubleArray diag(IDoubleArray values) {
        return new DiagonalMatrix(values);
    }

    public IDoubleArray symmetric(IDoubleArray matrix) {
        return new SymmetricMatrix(matrix);
    }

    public IDoubleArray symmetricReal(int size) {
        return new SymmetricMatrix(this.array(size, size));
    }

    public IDoubleArray identity(int dim) {
        return this.diag(dim, 1.0);
    }

    public IDoubleList list(int size) {
        return new DoubleArrayList_FastUtilWrapper(size);
    }

    public IDoubleList list(int size, double value) {
        return new DoubleArrayList_FastUtilWrapper(PrimitiveDoubleTools.createInitialized(size, value));
    }

    public IDoubleList list(IDoubleArray arr) {
        return new DoubleArrayList_FastUtilWrapper(arr.getArray());
    }

    public IDoubleList listFrom(double d) {
        double[] arr = PrimitiveDoubleTools.getDoubleArray(d);
        return new DoubleArrayList_FastUtilWrapper(arr);
    }

    public IDoubleList listFrom(double d1, double ... d2) {
        double[] arr = PrimitiveDoubleTools.concat(PrimitiveDoubleTools.getDoubleArray(d1), d2);
        return new DoubleArrayList_FastUtilWrapper(arr);
    }

    public IDoubleList listFrom(double[] arr) {
        return new DoubleArrayList_FastUtilWrapper(arr);
    }

    public IDoubleList listFrom(int[] a) {
        double[] res = PrimitiveDoubleTools.from(a);
        return new DoubleArrayList_FastUtilWrapper(res);
    }

    public IDoubleList listFrom(float[] a) {
        double[] res = PrimitiveDoubleTools.from(a);
        return new DoubleArrayList_FastUtilWrapper(res);
    }

    public IDoubleList listRandom(int n) {
        double[] res = PrimitiveDoubleTools.randomArray(n);
        return new DoubleArrayList_FastUtilWrapper(res);
    }

    public IDoubleList listRange(double start, double end, double step) {
        double[] res = PrimitiveDoubleTools.range(start, end, step);
        return new DoubleArrayList_FastUtilWrapper(res);
    }
}

