/*
 * Decompiled with CFR 0.152.
 */
package stallone.api.intsequence;

import java.io.IOException;
import java.util.List;
import stallone.api.ints.IIntArray;
import stallone.api.intsequence.IIntReader;
import stallone.api.intsequence.IIntSequenceLoader;
import stallone.api.intsequence.IIntWriter;
import stallone.api.io.IO;
import stallone.api.strings.Strings;
import stallone.intsequence.IntArrayTokenizer;
import stallone.intsequence.IntSequenceReaderAsciiDense;
import stallone.intsequence.IntSequenceReaderAsciiSparse;
import stallone.intsequence.IntSequenceWriterAsciiDense;
import stallone.intsequence.IntSequencesFileLoader;
import stallone.io.CachedAsciiFileReader;

public class IntSequenceFactory {
    public IIntSequenceLoader intSequenceLoader(List<String> files) throws IOException {
        String firstFile = files.get(0);
        CachedAsciiFileReader firstReader = IO.create.asciiReader(firstFile);
        String[] words = Strings.util.split(firstReader.getLine(0));
        CachedAsciiFileReader sequenceLoader = words.length == 1 ? new IntSequenceReaderAsciiDense() : new IntSequenceReaderAsciiSparse();
        return this.intSequenceLoader(files, (IIntReader)((Object)sequenceLoader));
    }

    public IIntSequenceLoader intSequenceLoader(List<String> files, IIntReader sequenceLoader) {
        IntSequencesFileLoader loader = new IntSequencesFileLoader();
        loader.setLoader(sequenceLoader);
        for (String s : files) {
            loader.addSource(s);
        }
        return loader;
    }

    public IIntWriter intSequenceWriter(String file) throws IOException {
        return new IntSequenceWriterAsciiDense(file);
    }

    public IntArrayTokenizer intSequenceTokenizer(IIntArray arr) {
        return new IntArrayTokenizer(arr);
    }
}

