/*
 * Decompiled with CFR 0.152.
 */
package stallone.api.stat;

import stallone.api.doubles.IDoubleArray;
import stallone.api.doubles.IDoubleList;
import stallone.api.ints.IIntList;
import stallone.api.stat.IDiscreteDistribution;
import stallone.api.stat.IParameterEstimator;
import stallone.stat.DiscreteDistribution;
import stallone.stat.GaussianUnivariate;
import stallone.stat.RunningAverage;
import stallone.stat.RunningMomentsMultivariate;
import stallone.stat.modelselection.ExitTimeSplitter;

public class StatisticsFactory {
    public RunningAverage runningAverage() {
        return new RunningAverage();
    }

    public RunningMomentsMultivariate runningMomentsMultivar(int _dimension) {
        return new RunningMomentsMultivariate(_dimension);
    }

    public RunningMomentsMultivariate runningMomentsMultivar(int _dimension, int _tau) {
        return new RunningMomentsMultivariate(_dimension, _tau);
    }

    public IParameterEstimator parameterEstimatorGaussian1D() {
        return new GaussianUnivariate(0.0, 0.0);
    }

    public ExitTimeSplitter exitTimeSplitter(IIntList states, IDoubleList lifetimes) {
        ExitTimeSplitter splitter = new ExitTimeSplitter();
        int i = 0;
        while (i < states.size()) {
            splitter.add(states.get(i), lifetimes.get(i));
            ++i;
        }
        return splitter;
    }

    public IDiscreteDistribution discreteDistribution(IDoubleArray probabilities) {
        return new DiscreteDistribution(probabilities);
    }
}

