/*
 * Decompiled with CFR 0.152.
 */
package stallone.api.stat;

import stallone.api.API;
import stallone.api.algebra.Algebra;
import stallone.api.doubles.Doubles;
import stallone.api.doubles.IDoubleArray;
import stallone.api.doubles.IDoubleList;
import stallone.api.ints.IIntArray;
import stallone.api.ints.IIntList;
import stallone.stat.modelselection.ExitTimeSplitter;

public class StatisticsUtilities {
    public double mean(IDoubleArray arr) {
        return Doubles.util.sum(arr) / (double)arr.size();
    }

    public double variance(IDoubleArray arr) {
        if (arr.size() == 1) {
            return 0.0;
        }
        double meanval = this.mean(arr);
        double sum = 0.0;
        int i = 0;
        while (i < arr.size()) {
            double err = arr.get(i) - meanval;
            sum += err * err;
            ++i;
        }
        return sum / (double)(arr.size() - 1);
    }

    public double covariance(IDoubleArray X, IDoubleArray Y) {
        if (X.size() == 1) {
            return 0.0;
        }
        if (X.size() != Y.size()) {
            throw new IllegalArgumentException("Cannot compute covariance between double arrays of different length: " + X.size() + "," + Y.size());
        }
        double meanX = this.mean(X);
        double meanY = this.mean(Y);
        double sum = 0.0;
        int i = 0;
        while (i < X.size()) {
            sum += (X.get(i) - meanX) * (Y.get(i) - meanY);
            ++i;
        }
        return sum / (double)(X.size() - 1);
    }

    public double stdDev(IDoubleArray arr) {
        return Math.sqrt(this.variance(arr));
    }

    public IDoubleArray meanRow(IDoubleArray arr) {
        int nrows = arr.rows();
        int ncols = arr.columns();
        IDoubleArray res = Doubles.create.array(ncols);
        int i = 0;
        while (i < nrows) {
            Algebra.util.addTo(res, arr.viewRow(i));
            ++i;
        }
        Algebra.util.scale(1.0 / (double)nrows, res);
        return res;
    }

    public IDoubleArray meanColumn(IDoubleArray arr) {
        int nrows = arr.rows();
        int ncols = arr.columns();
        IDoubleArray res = Doubles.create.array(nrows);
        int i = 0;
        while (i < ncols) {
            Algebra.util.addTo(res, arr.viewColumn(i));
            ++i;
        }
        Algebra.util.scale(1.0 / (double)ncols, res);
        return res;
    }

    public IIntArray histogram(IDoubleArray data, IDoubleArray grid) {
        if (!API.doubles.isSorted(grid)) {
            throw new IllegalArgumentException("Grid passed to histogram must be sorted");
        }
        int[] res = new int[grid.size()];
        int i = 0;
        while (i < data.size()) {
            int n = API.doubles.findClosest(grid, data.get(i));
            res[n] = res[n] + 1;
            ++i;
        }
        return API.intsNew.arrayFrom(res);
    }

    public double gaussianDensity(double mean, double variance, double x) {
        double dev = mean - x;
        double f = 1.0 / Math.sqrt(Math.PI * 2 * variance) * Math.exp(-(dev * dev) / (2.0 * variance));
        return f;
    }

    public int[] splitNonexponentialLifetimes(IIntList states, IDoubleList lifetimes) {
        ExitTimeSplitter splitter = new ExitTimeSplitter();
        int i = 0;
        while (i < states.size()) {
            splitter.add(states.get(i), lifetimes.get(i));
            ++i;
        }
        splitter.run();
        return splitter.getNewStateAssignment();
    }

    public int[] splitNonexponentialLifetimes(int[] states, double[] lifetimes) {
        ExitTimeSplitter splitter = new ExitTimeSplitter();
        int i = 0;
        while (i < states.length) {
            splitter.add(states[i], lifetimes[i]);
            ++i;
        }
        splitter.run();
        return splitter.getNewStateAssignment();
    }
}

