/*
 * Decompiled with CFR 0.152.
 */
package stallone.api.strings;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import stallone.ints.PrimitiveIntTools;

public class StringUtilities {
    public List<String> toList(String[] arr) {
        ArrayList<String> list = new ArrayList<String>();
        String[] stringArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            list.add(s);
            ++n2;
        }
        return list;
    }

    public String[] toArray(List<String> list) {
        String[] arr = new String[list.size()];
        int i = 0;
        while (i < arr.length) {
            arr[i] = list.get(i);
            ++i;
        }
        return arr;
    }

    public String[] getLines(String str) {
        StringTokenizer tok = new StringTokenizer(str, "\n");
        String[] arr = new String[tok.countTokens()];
        int i = 0;
        while (i < arr.length) {
            arr[i] = tok.nextToken();
            ++i;
        }
        return arr;
    }

    public String[] split(String str) {
        StringTokenizer tok = new StringTokenizer(str);
        String[] arr = new String[tok.countTokens()];
        int i = 0;
        while (i < arr.length) {
            arr[i] = tok.nextToken();
            ++i;
        }
        return arr;
    }

    public String[][] split(String[] lines) {
        String[][] res = new String[lines.length][];
        int i = 0;
        while (i < res.length) {
            res[i] = this.split(lines[i]);
            ++i;
        }
        return res;
    }

    public String mergeLines(String[] lines) {
        StringBuffer strbuf = new StringBuffer();
        int i = 0;
        while (i < lines.length) {
            strbuf.append(String.valueOf(lines[i]) + "\n");
            ++i;
        }
        return strbuf.toString();
    }

    public String[] purgeEmpty(String[] arr) {
        int[] drop = new int[]{};
        int i = 0;
        while (i < arr.length) {
            if (this.split(arr[i]).length == 0) {
                drop = PrimitiveIntTools.concat(drop, i);
            }
            ++i;
        }
        int[] include = PrimitiveIntTools.removeByValue(PrimitiveIntTools.range(arr.length), drop);
        return this.subarray(arr, include);
    }

    public String replaceAll(String str, String pattern, String value) {
        String res = str;
        int i = res.indexOf(pattern);
        while (i > -1) {
            res = String.valueOf(res.substring(0, i)) + value + res.substring(i + pattern.length(), res.length());
            i = res.indexOf(pattern);
        }
        return res;
    }

    public boolean isInt(String str) {
        try {
            Integer.valueOf(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public int leadingInt(String str) {
        int k = 0;
        while (k < str.length()) {
            if (!Character.isDigit(str.charAt(k))) break;
            ++k;
        }
        if (k == 0) {
            return -1;
        }
        return this.toInt(str.substring(0, k));
    }

    public boolean startsWithInt(String str) {
        String[] words = this.split(str);
        if (words.length == 0) {
            return false;
        }
        return this.isInt(words[0]);
    }

    public int nextInt(String str, int s) {
        int k = s;
        while (k < str.length() && !Character.isDigit(str.charAt(k))) {
            ++k;
        }
        int i1 = k;
        while (k < str.length() && Character.isDigit(str.charAt(k))) {
            ++k;
        }
        int i2 = k;
        if (i2 - i1 < 1) {
            return -1;
        }
        return this.toInt(str.substring(i1, i2));
    }

    public long nextLong(String str, int s) {
        int k = s;
        while (k < str.length() && !Character.isDigit(str.charAt(k))) {
            ++k;
        }
        int i1 = k;
        while (k < str.length() && Character.isDigit(str.charAt(k))) {
            ++k;
        }
        int i2 = k;
        if (i2 - i1 < 1) {
            return -1L;
        }
        return this.toLong(str.substring(i1, i2));
    }

    public int toInt(String str) {
        return Integer.valueOf(str);
    }

    public long toLong(String str) {
        return Long.valueOf(str);
    }

    public String[][] transpose(String[][] arr) {
        int nCol = arr.length;
        int nLin = arr[0].length;
        int i = 0;
        while (i < arr.length) {
            if (arr[i].length != nLin) {
                System.out.println(arr[i].length);
                throw new IllegalArgumentException("Trying to transpose a non-matrix-array");
            }
            ++i;
        }
        String[][] res = new String[nLin][nCol];
        int i2 = 0;
        while (i2 < res.length) {
            int j = 0;
            while (j < res[i2].length) {
                res[i2][j] = arr[j][i2];
                ++j;
            }
            ++i2;
        }
        return res;
    }

    public int[] toIntArray(String[] str) {
        int[] res = new int[str.length];
        int i = 0;
        while (i < str.length) {
            res[i] = this.toInt(str[i]);
            ++i;
        }
        return res;
    }

    public int[][] toIntMatrix(String[][] str) {
        int[][] res = new int[str.length][str[0].length];
        int r = 0;
        int i = 0;
        while (i < str.length) {
            if (str[i].length > 0) {
                ++r;
            }
            int j = 0;
            while (j < str[i].length) {
                res[i][j] = this.toInt(str[i][j]);
                ++j;
            }
            ++i;
        }
        return PrimitiveIntTools.subarray(res, 0, r);
    }

    public int[] toIntArray(String str) {
        String[] strarr = this.split(str);
        if (this.isInt(strarr[0])) {
            return this.toIntArray(strarr);
        }
        strarr = str.split(",");
        if (this.isInt(strarr[0])) {
            return this.toIntArray(strarr);
        }
        strarr = str.split(";");
        if (this.isInt(strarr[0])) {
            return this.toIntArray(strarr);
        }
        throw new IllegalArgumentException("No int array: " + str);
    }

    public boolean isIntArray(String str) {
        try {
            this.toIntArray(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isDouble(String str) {
        try {
            Double.valueOf(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public double toDouble(String str) {
        String enString = str;
        int i = str.indexOf(",");
        if (i != -1) {
            StringBuffer strbuf = new StringBuffer(str);
            strbuf.setCharAt(i, '.');
            enString = strbuf.toString();
        }
        return Double.valueOf(str);
    }

    public double[] toDoubleArray(String[] str) {
        double[] res = new double[str.length];
        int i = 0;
        while (i < str.length) {
            res[i] = this.toDouble(str[i]);
            ++i;
        }
        return res;
    }

    public double[][] toDoubleArray(String[][] str) {
        double[][] res = new double[str.length][];
        int i = 0;
        while (i < str.length) {
            res[i] = this.toDoubleArray(str[i]);
            ++i;
        }
        return res;
    }

    public boolean isDoubleArray(String str) {
        try {
            this.toDoubleArray(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public double[] toDoubleArray(String str) {
        String[] words = str.split("[ ,\t]++");
        double[] res = new double[words.length];
        int i = 0;
        while (i < words.length) {
            try {
                res[i] = this.toDouble(words[i]);
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("No double array: " + str);
            }
            ++i;
        }
        return res;
    }

    public double[][] toDoubleTable(String str) {
        String[] lines = str.split("[;\n]");
        double[][] res = new double[lines.length][];
        int i = 0;
        while (i < lines.length) {
            res[i] = this.toDoubleArray(lines[i]);
            ++i;
        }
        return res;
    }

    public String[] concat(String[] a1, String[] a2) {
        String[] res = new String[a1.length + a2.length];
        int j = 0;
        int i = 0;
        while (i < a1.length) {
            res[j++] = a1[i];
            ++i;
        }
        i = 0;
        while (i < a2.length) {
            res[j++] = a2[i];
            ++i;
        }
        return res;
    }

    public String[][] concat(String[][] a1, String[][] a2) {
        String[][] res = new String[a1.length + a2.length][];
        int j = 0;
        int i = 0;
        while (i < a1.length) {
            res[j++] = a1[i];
            ++i;
        }
        i = 0;
        while (i < a2.length) {
            res[j++] = a2[i];
            ++i;
        }
        return res;
    }

    public String[] concat(String[] a1, String a2) {
        String[] res = new String[a1.length + 1];
        int j = 0;
        int i = 0;
        while (i < a1.length) {
            res[j++] = a1[i];
            ++i;
        }
        res[j] = a2;
        return res;
    }

    public String[][] concat(String[][] a1, String[] a2) {
        String[][] res = new String[a1.length + 1][];
        int j = 0;
        int i = 0;
        while (i < a1.length) {
            res[j++] = a1[i];
            ++i;
        }
        res[j] = a2;
        return res;
    }

    public boolean contains(String[] arr, String pattern) {
        int i = 0;
        while (i < arr.length) {
            if (arr[i].equals(pattern)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int findForward(String[] arr, String pattern, int iStart) {
        int i = iStart;
        while (i < arr.length) {
            if (arr[i].equals(pattern)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int findForward(String[] arr, String pattern) {
        return this.findForward(arr, pattern, 0);
    }

    public int findBackward(String[] arr, String pattern, int iStart) {
        int i = iStart;
        while (i >= 0) {
            if (arr[i].equals(pattern)) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public int findBackward(String[] arr, String pattern) {
        return this.findForward(arr, pattern, arr.length - 1);
    }

    public static String flushLeft(String str, int size) {
        StringBuffer strbuf = new StringBuffer(str);
        int i = str.length();
        while (i < size) {
            strbuf.append(" ");
            ++i;
        }
        return strbuf.toString();
    }

    public static String flushRight(String str, int size) {
        StringBuffer strbuf = new StringBuffer();
        int i = str.length();
        while (i < size) {
            strbuf.append(" ");
            ++i;
        }
        strbuf.append(str);
        return strbuf.toString();
    }

    public String[] copy(String[] arr) {
        String[] res = new String[arr.length];
        int i = 0;
        while (i < res.length) {
            res[i] = arr[i];
            ++i;
        }
        return res;
    }

    public String[] subarray(String[] arr, int i1, int i2) {
        String[] res = new String[i2 - i1];
        int i = i1;
        while (i < i2) {
            res[i - i1] = arr[i];
            ++i;
        }
        return res;
    }

    public String[] subarray(String[] arr, int[] indexes) {
        String[] res = new String[indexes.length];
        int i = 0;
        int k = 0;
        while (i < indexes.length) {
            res[k++] = arr[indexes[i]];
            ++i;
        }
        return res;
    }

    public String[][] subarray(String[][] arr, int i1, int i2) {
        String[][] res = new String[i2 - i1][];
        int i = i1;
        while (i < i2) {
            res[i - i1] = arr[i];
            ++i;
        }
        return res;
    }

    public String[][] subarray(String[][] arr, int[] indexes) {
        String[][] res = new String[indexes.length][];
        int i = 0;
        int k = 0;
        while (i < indexes.length) {
            res[k++] = arr[indexes[i]];
            ++i;
        }
        return res;
    }

    public String[] drop(String[] arr, int[] droplist) {
        int[] include = PrimitiveIntTools.removeByValue(PrimitiveIntTools.range(arr.length), droplist);
        return this.subarray(arr, include);
    }

    public String[] dropLeading(String[] arr, String pattern) {
        int[] droplist = new int[]{};
        int i = 0;
        while (i < arr.length) {
            if (arr[i].startsWith(pattern)) {
                droplist = PrimitiveIntTools.concat(droplist, i);
            }
            ++i;
        }
        return this.drop(arr, droplist);
    }

    public String[] getColumn(String[][] arr, int k) {
        String[] res = new String[arr.length];
        int i = 0;
        while (i < arr.length) {
            res[i] = arr[i][k];
            ++i;
        }
        return res;
    }

    public static String toScientific(double I, int digits) {
        StringBuffer strbuf = new StringBuffer("0.");
        int i = 0;
        while (i < digits) {
            strbuf.append("#");
            ++i;
        }
        strbuf.append("E0");
        DecimalFormat df = new DecimalFormat(strbuf.toString());
        return df.format(I);
    }

    public static String toPrecision(double I, int digits1, int digits2) {
        if (digits2 == 0) {
            return String.valueOf((int)Math.round(I));
        }
        StringBuffer strbuf = new StringBuffer("");
        int i = 0;
        while (i < digits1 - 1) {
            strbuf.append("#");
            ++i;
        }
        strbuf.append("0.");
        i = 0;
        while (i < digits2) {
            strbuf.append("#");
            ++i;
        }
        DecimalFormat df = new DecimalFormat(strbuf.toString(), new DecimalFormatSymbols(Locale.ENGLISH));
        return df.format(I);
    }
}

