/*
 * Decompiled with CFR 0.152.
 */
package stallone.cluster;

import java.util.Arrays;
import java.util.HashMap;
import stallone.api.ints.IIntArray;
import stallone.api.ints.Ints;

public class MilestoningFilter {
    private Iterable<IIntArray> cores;
    private HashMap<Integer, Integer> state2core;

    public MilestoningFilter(Iterable<IIntArray> _cores) {
        this.cores = _cores;
        this.state2core = new HashMap();
        int c = 0;
        for (IIntArray core : _cores) {
            int i = 0;
            while (i < core.size()) {
                this.state2core.put(core.get(i), c);
                ++i;
            }
            ++c;
        }
    }

    public MilestoningFilter(IIntArray ... _cores) {
        this(Arrays.asList(_cores));
    }

    public IIntArray filter(IIntArray traj) {
        int ifirst = 0;
        while (ifirst < traj.size()) {
            if (this.state2core.containsKey(traj.get(ifirst))) break;
            ++ifirst;
        }
        if (ifirst >= traj.size()) {
            return Ints.create.array(0);
        }
        IIntArray res = Ints.create.array(traj.size() - ifirst);
        int currentCore = this.state2core.get(traj.get(ifirst));
        int i = ifirst;
        while (i < traj.size()) {
            if (this.state2core.containsKey(traj.get(i))) {
                currentCore = this.state2core.get(traj.get(i));
            }
            res.set(i - ifirst, currentCore);
            ++i;
        }
        return res;
    }
}

