/*
 * Decompiled with CFR 0.152.
 */
package stallone.complex;

import stallone.api.algebra.IComplexNumber;

public class ComplexNumber
implements IComplexNumber {
    private double real;
    private double imaginary;

    public ComplexNumber(double real, double imag) {
        this.real = real;
        this.imaginary = imag;
    }

    public ComplexNumber(double real) {
        this.real = real;
        this.imaginary = 0.0;
    }

    public ComplexNumber(IComplexNumber other) {
        this.real = other.getRe();
        this.imaginary = other.getIm();
    }

    public static ComplexNumber createZero() {
        return new ComplexNumber(0.0, 0.0);
    }

    public static ComplexNumber createUnit() {
        return new ComplexNumber(1.0, 0.0);
    }

    public static ComplexNumber createNegatedUnit() {
        return new ComplexNumber(-1.0, 0.0);
    }

    public static ComplexNumber createI() {
        return new ComplexNumber(0.0, 1.0);
    }

    public static ComplexNumber createNegatedI() {
        return new ComplexNumber(0.0, -1.0);
    }

    public String toString() {
        return "(" + this.real + " " + this.imaginary + "i)";
    }

    @Override
    public final void setComplex(double real, double imaginary) {
        this.real = real;
        this.imaginary = imaginary;
    }

    @Override
    public final double get() {
        return this.real;
    }

    @Override
    public final double getRe() {
        return this.real;
    }

    @Override
    public final double getIm() {
        return this.imaginary;
    }

    @Override
    public IComplexNumber copy() {
        return new ComplexNumber(this);
    }

    @Override
    public IComplexNumber copy(IComplexNumber target) {
        target.setComplex(this.real, this.imaginary);
        return target;
    }

    @Override
    public double abs() {
        return Math.sqrt(this.real * this.real + this.imaginary * this.imaginary);
    }

    @Override
    public IComplexNumber invertInplace() {
        double l = this.real * this.real + this.imaginary * this.imaginary;
        this.real /= l;
        this.imaginary = -this.imaginary / l;
        return this;
    }

    @Override
    public IComplexNumber invert() {
        double l = this.real * this.real + this.imaginary * this.imaginary;
        return new ComplexNumber(this.real / l, -this.imaginary / l);
    }

    @Override
    public IComplexNumber invert(IComplexNumber target) {
        double l = this.real * this.real + this.imaginary * this.imaginary;
        target.setRe(this.real / l);
        target.setIm(-this.imaginary / l);
        return target;
    }

    @Override
    public IComplexNumber negateInplace() {
        this.real = -this.real;
        this.imaginary = -this.imaginary;
        return this;
    }

    @Override
    public IComplexNumber negate() {
        return new ComplexNumber(-this.real, -this.imaginary);
    }

    @Override
    public IComplexNumber negate(IComplexNumber target) {
        target.setComplex(-this.real, -this.imaginary);
        return target;
    }

    @Override
    public IComplexNumber conjInplace() {
        this.imaginary = -this.imaginary;
        return this;
    }

    @Override
    public IComplexNumber conj() {
        return new ComplexNumber(this.real, -this.imaginary);
    }

    @Override
    public IComplexNumber conj(IComplexNumber target) {
        target.setComplex(this.real, -this.imaginary);
        return target;
    }

    @Override
    public boolean isZero() {
        return this.real == 0.0 && this.imaginary == 0.0;
    }

    @Override
    public final boolean isPurelyReal() {
        return this.imaginary == 0.0;
    }

    @Override
    public final boolean isPurelyImaginary() {
        return this.real == 0.0;
    }

    @Override
    public void setScalar(IComplexNumber complex) {
        this.real = complex.getRe();
        this.imaginary = complex.getIm();
    }

    @Override
    public void setRe(double real) {
        this.real = real;
    }

    @Override
    public void setIm(double imag) {
        this.imaginary = imag;
    }

    @Override
    public final boolean storesComplex() {
        return true;
    }

    @Override
    public IComplexNumber add(IComplexNumber other) {
        this.real += other.getRe();
        this.imaginary += other.getIm();
        return this;
    }

    @Override
    public IComplexNumber multBy(IComplexNumber other) {
        double a_r = this.real;
        double a_i = this.imaginary;
        double b_r = other.getRe();
        double b_i = other.getIm();
        this.real = a_r * b_r - a_i * b_i;
        this.imaginary = a_r * b_i + a_i * b_r;
        return this;
    }

    @Override
    public IComplexNumber addRe(double re) {
        this.real += re;
        return this;
    }

    @Override
    public IComplexNumber addIm(double im) {
        this.imaginary += im;
        return this;
    }

    @Override
    public void set(double real) {
        this.setRe(real);
    }
}

