/*
 * Decompiled with CFR 0.152.
 */
package stallone.complex;

import stallone.api.algebra.IComplexNumber;
import stallone.api.complex.IComplexArray;
import stallone.complex.AbstractComplexArray;
import stallone.complex.ComplexNumber;
import stallone.doubles.DoubleArrayTest;

public class DenseComplexArray
extends AbstractComplexArray {
    protected double[] data;
    protected int rows;
    protected int cols;

    public DenseComplexArray(int _rows, int _cols) {
        this.rows = _rows;
        this.cols = _cols;
        this.data = new double[2 * this.rows * this.cols];
    }

    public DenseComplexArray(IComplexArray source) {
        this(source.rows(), source.columns());
        this.copyFrom(source);
    }

    public DenseComplexArray(IComplexNumber[][] value) {
        this.rows = value.length;
        this.cols = value[0].length;
        this.data = new double[this.rows * this.cols * 2];
        int i = 0;
        while (i < this.rows) {
            if (this.cols != value[i].length) {
                throw new IllegalArgumentException("input array has rows of uneven length");
            }
            int j = 0;
            while (j < this.cols) {
                this.data[2 * (i + j * this.rows)] = value[i][j].getRe();
                this.data[2 * (i + j * this.rows) + 1] = value[i][j].getIm();
                ++j;
            }
            ++i;
        }
    }

    @Override
    public int rows() {
        return this.rows;
    }

    @Override
    public int columns() {
        return this.cols;
    }

    @Override
    public double getRe(int i, int j) {
        int idx = (i + j * this.rows) * 2;
        return this.data[idx];
    }

    @Override
    public double getIm(int i, int j) {
        int idx = (i + j * this.rows) * 2;
        return this.data[idx + 1];
    }

    public IComplexNumber getScalar(int i, int j) {
        int idx = (i + j * this.rows) * 2;
        return new ComplexNumber(this.data[idx], this.data[idx + 1]);
    }

    public IComplexNumber getScalar(int i, int j, IComplexNumber target) {
        int idx = (i + j * this.rows) * 2;
        target.setComplex(this.data[idx], this.data[idx + 1]);
        return target;
    }

    @Override
    public void setRe(int i, int j, double real) {
        int idx = (i + j * this.rows) * 2;
        this.data[idx] = real;
    }

    @Override
    public void setIm(int i, int j, double imaginary) {
        int idx = (i + j * this.rows) * 2;
        this.data[idx + 1] = imaginary;
    }

    public void setScalar(int i, int j, IComplexNumber complex) {
        int idx = (i + j * this.rows) * 2;
        this.data[idx] = complex.getRe();
        this.data[idx + 1] = complex.getIm();
    }

    @Override
    public void set(int i, int j, double real, double imaginary) {
        int idx = (i + j * this.rows) * 2;
        this.data[idx] = real;
        this.data[idx + 1] = imaginary;
    }

    @Override
    public void copyFrom(IComplexArray matrix) {
        DoubleArrayTest.assertEqualDimensions(this, matrix);
        if (matrix instanceof DenseComplexArray) {
            System.arraycopy(((DenseComplexArray)matrix).data, 0, this.data, 0, this.rows * this.cols * 2);
        } else {
            super.copyFrom(matrix);
        }
    }

    @Override
    public void zero() {
        int j = 0;
        while (j < this.cols) {
            int i = 0;
            while (i < this.rows) {
                this.set(i, j, 0.0, 0.0);
                ++i;
            }
            ++j;
        }
    }

    @Override
    public boolean isReal() {
        int n = this.data.length;
        int i = 1;
        while (i < n) {
            if (this.data[i] != 0.0) {
                return false;
            }
            i += 2;
        }
        return true;
    }

    public void addRe(int i, int j, double real) {
        int idx;
        int n = idx = (i + j * this.rows) * 2;
        this.data[n] = this.data[n] + real;
    }

    public void addIm(int i, int j, double imaginary) {
        int idx = (i + j * this.rows) * 2;
        int n = idx + 1;
        this.data[n] = this.data[n] + imaginary;
    }

    public void add(int i, int j, double real, double imaginary) {
        int idx;
        int n = idx = (i + j * this.rows) * 2;
        this.data[n] = this.data[n] + real;
        int n2 = idx + 1;
        this.data[n2] = this.data[n2] + imaginary;
    }

    public void add(int i, int j, IComplexNumber scalar) {
        int idx;
        int n = idx = (i + j * this.rows) * 2;
        this.data[n] = this.data[n] + scalar.getRe();
        int n2 = idx + 1;
        this.data[n2] = this.data[n2] + scalar.getIm();
    }

    @Override
    public IComplexArray copy() {
        return new DenseComplexArray(this);
    }

    @Override
    public IComplexArray create(int rows, int cols) {
        return new DenseComplexArray(rows, cols);
    }

    @Override
    public IComplexArray create(int size) {
        return new DenseComplexArray(size, 1);
    }

    @Override
    public boolean isSparse() {
        return false;
    }
}

