/*
 * Decompiled with CFR 0.152.
 */
package stallone.complex.io;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import stallone.api.complex.Complex;
import stallone.api.complex.IComplexArray;
import stallone.complex.io.OutputUtil;

public class DenseAsciiVectorWriter {
    private IComplexArray vector;
    private String filename;
    private Alignment alignment;
    private boolean allPurelyReal;

    public DenseAsciiVectorWriter(IComplexArray vector, String filename) {
        this(vector, filename, Alignment.COLUMN);
    }

    public DenseAsciiVectorWriter(IComplexArray vector, String filename, Alignment alignment) {
        this.vector = vector;
        this.filename = filename;
        this.alignment = alignment;
        this.allPurelyReal = vector.isReal();
    }

    public void perform() {
        BufferedWriter writer = null;
        try {
            try {
                writer = new BufferedWriter(new FileWriter(this.filename));
                int n = this.vector.size();
                int i = 0;
                while (i < n) {
                    double re = this.vector.getRe(i);
                    double im = this.vector.getIm(i);
                    if (this.alignment.equals((Object)Alignment.COLUMN)) {
                        writer.write(OutputUtil.scalarToEasyString(re, im));
                        writer.newLine();
                    } else {
                        writer.write(OutputUtil.scalarToEasyString(re, im));
                        writer.write(" ");
                    }
                    ++i;
                }
                writer.newLine();
                writer.close();
            }
            catch (IOException ex) {
                Logger.getLogger(DenseAsciiVectorWriter.class.getName()).log(Level.SEVERE, null, ex);
                try {
                    writer.close();
                }
                catch (IOException ex2) {
                    Logger.getLogger(DenseAsciiVectorWriter.class.getName()).log(Level.SEVERE, null, ex2);
                }
            }
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException ex) {
                Logger.getLogger(DenseAsciiVectorWriter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static void main(String[] args) {
        IComplexArray v1 = Complex.create.array(3);
        v1.set(0, 1.0);
        v1.set(1, 2.0, -3.0);
        v1.set(2, 0.0, 5.0);
        DenseAsciiVectorWriter writer = new DenseAsciiVectorWriter(v1, "/home/fischbac/vector.dat");
        writer.perform();
    }

    public static enum Alignment {
        ROW,
        COLUMN;

    }
}

