/*
 * Decompiled with CFR 0.152.
 */
package stallone.datasequence;

import java.io.IOException;
import java.util.Iterator;
import stallone.api.datasequence.IDataInput;
import stallone.api.doubles.IDoubleArray;

class DataInput_DataPairIterator
implements Iterator<IDoubleArray[]> {
    protected IDataInput loader;
    protected int itraj = 0;
    protected int iindex1 = 0;
    protected int iindex2 = 1;
    private int spacing = 1;
    private int stepsize = 1;
    private IDoubleArray[] res = new IDoubleArray[2];

    public DataInput_DataPairIterator(IDataInput _loader, int _spacing) {
        this.loader = _loader;
        this.spacing = _spacing;
        this.iindex1 = 0;
        this.iindex2 = this.spacing;
    }

    public DataInput_DataPairIterator(IDataInput _loader, int _spacing, int _stepsize) {
        this(_loader, _spacing);
        this.stepsize = _stepsize;
    }

    @Override
    public boolean hasNext() {
        return this.itraj < this.loader.numberOfSequences() - 1 || this.itraj == this.loader.numberOfSequences() - 1 && this.iindex2 < this.loader.size(this.itraj) - 1;
    }

    @Override
    public IDoubleArray[] next() {
        try {
            this.res[0] = this.loader.get(this.itraj, this.iindex1);
            this.res[1] = this.loader.get(this.itraj, this.iindex2);
            this.advance();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.res;
    }

    protected void advance() throws IOException {
        this.iindex1 += this.stepsize;
        this.iindex2 += this.stepsize;
        if (this.iindex2 >= this.loader.size(this.itraj)) {
            ++this.itraj;
            this.iindex1 = 0;
            this.iindex2 = this.spacing;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

