/*
 * Decompiled with CFR 0.152.
 */
package stallone.datasequence;

import java.util.ArrayList;
import java.util.Iterator;
import stallone.api.datasequence.IDataList;
import stallone.api.datasequence.IDataSequence;
import stallone.api.doubles.IDoubleArray;
import stallone.datasequence.DataSequencePairIterator;

public class DataList
implements IDataList {
    private ArrayList<IDoubleArray> list = new ArrayList();

    public DataList() {
        this.list = new ArrayList();
    }

    public DataList(int size) {
        this.list = new ArrayList(size);
    }

    @Override
    public int dimension() {
        return this.get(0).size();
    }

    @Override
    public IDoubleArray get(int i) {
        return this.list.get(i);
    }

    @Override
    public IDoubleArray getView(int i) {
        return this.get(i);
    }

    @Override
    public Iterator<IDoubleArray[]> pairIterator(int spacing) {
        return new DataSequencePairIterator(this, spacing);
    }

    @Override
    public Iterable<IDoubleArray[]> pairs(int spacing) {
        class PairIterable
        implements Iterable<IDoubleArray[]> {
            private IDataSequence seq;
            private int spacing = 1;

            public PairIterable(IDataSequence _seq, int _spacing) {
                this.seq = _seq;
                this.spacing = _spacing;
            }

            @Override
            public Iterator<IDoubleArray[]> iterator() {
                return new DataSequencePairIterator(this.seq, this.spacing);
            }
        }
        return new PairIterable(this, spacing);
    }

    @Override
    public double getTime(int i) {
        return i;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public Iterator<IDoubleArray> iterator() {
        return this.list.iterator();
    }

    @Override
    public boolean add(IDoubleArray x) {
        return this.list.add(x);
    }

    @Override
    public boolean remove(IDoubleArray x) {
        return this.list.remove(x);
    }

    @Override
    public IDoubleArray remove(int i) {
        return this.list.remove(i);
    }

    @Override
    public void set(int i, IDoubleArray x) {
        this.list.set(i, x);
    }
}

