/*
 * Decompiled with CFR 0.152.
 */
package stallone.datasequence.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import stallone.api.datasequence.IDataReader;
import stallone.api.datasequence.IDataWriter;
import stallone.api.io.IO;
import stallone.datasequence.io.AsciiDataSequenceReader;
import stallone.datasequence.io.AsciiDataSequenceWriter;
import stallone.datasequence.io.DcdReader;
import stallone.datasequence.io.DcdWriter;
import stallone.datasequence.io.XtcReader;

public class DataSequenceFileFormats {
    private static String getInputFileFormat(String filename) {
        String ext;
        String requestedFormat = "auto";
        String internalFormat = requestedFormat.equals("auto") ? ((ext = IO.util.getExtension(filename)).equals("xtc") ? "xtc" : (ext.equals("dcd") ? "dcd" : "ascii")) : requestedFormat;
        return internalFormat;
    }

    public static IDataReader createReader(String file) throws IOException {
        String internalFormat = DataSequenceFileFormats.getInputFileFormat(file);
        IDataReader reader = null;
        if (internalFormat.equals("xtc")) {
            reader = new XtcReader(file);
        } else if (internalFormat.equals("dcd")) {
            reader = new DcdReader(file);
        } else if (internalFormat.equals("ascii")) {
            reader = new AsciiDataSequenceReader(file);
        }
        return reader;
    }

    public static IDataWriter createWriter(String file, int size, int dimension) throws FileNotFoundException, IOException {
        if (!new File(IO.util.getDirectory(file)).exists()) {
            throw new FileNotFoundException("File " + file + " cannot be written. Check if path name is valid and file location is accessible.");
        }
        String extension = IO.util.getExtension(file);
        IDataWriter writer = null;
        if (extension.equalsIgnoreCase("dcd")) {
            writer = new DcdWriter(file, size, dimension);
        } else {
            if (extension.equalsIgnoreCase("xtc")) {
                throw new UnsupportedOperationException("xtc writer is not supported yet.");
            }
            writer = new AsciiDataSequenceWriter(file);
        }
        return writer;
    }
}

