/*
 * Decompiled with CFR 0.152.
 */
package stallone.doubles;

import stallone.api.doubles.Doubles;
import stallone.api.doubles.IDoubleArray;
import stallone.api.doubles.IDoubleIterator;
import stallone.doubles.DoubleArrayView;
import stallone.doubles.DoubleTableIterator;
import stallone.doubles.DoubleTableNonzeroIterator;

public abstract class AbstractDoubleArray
implements IDoubleArray {
    @Override
    public int size() {
        return this.rows() * this.columns();
    }

    @Override
    public int order() {
        int order = 0;
        if (this.rows() > 1) {
            ++order;
        }
        if (this.columns() > 1) {
            ++order;
        }
        return order;
    }

    @Override
    public void zero() {
        IDoubleIterator it = this.iterator();
        while (it.hasNext()) {
            it.set(0.0);
            it.advance();
        }
    }

    @Override
    public double get(int ij) {
        int cols = this.columns();
        return this.get(ij / cols, ij % cols);
    }

    @Override
    public void set(int ij, double x) {
        int cols = this.columns();
        this.set(ij / cols, ij % cols, x);
    }

    @Override
    public double[] getArray() {
        int size = this.size();
        double[] res = new double[size];
        int i = 0;
        while (i < size) {
            res[i] = this.get(i);
            ++i;
        }
        return res;
    }

    @Override
    public double[][] getTable() {
        int nrows = this.rows();
        int ncols = this.columns();
        double[][] res = new double[nrows][ncols];
        int i = 0;
        while (i < nrows) {
            int j = 0;
            while (j < ncols) {
                res[i][j] = this.get(i, j);
                ++j;
            }
            ++i;
        }
        return res;
    }

    @Override
    public double[] getRow(int row) {
        int ncols = this.columns();
        double[] res = new double[ncols];
        int i = 0;
        while (i < ncols) {
            res[i] = this.get(row, i);
            ++i;
        }
        return res;
    }

    @Override
    public double[] getColumn(int col) {
        int nrows = this.rows();
        double[] res = new double[nrows];
        int i = 0;
        while (i < nrows) {
            res[i] = this.get(i, col);
            ++i;
        }
        return res;
    }

    @Override
    public IDoubleIterator iterator() {
        return new DoubleTableIterator(this);
    }

    @Override
    public IDoubleIterator nonzeroIterator() {
        return new DoubleTableNonzeroIterator(this);
    }

    @Override
    public void copyFrom(IDoubleArray other) {
        int size = this.size();
        if (size != other.size()) {
            throw new IllegalArgumentException("Incosistent sizes: This array has size " + size + " the other array has size " + other.size());
        }
        int i = 0;
        while (i < size) {
            this.set(i, other.get(i));
            ++i;
        }
    }

    @Override
    public void copyInto(IDoubleArray other) {
        int size = this.size();
        if (size != other.size()) {
            throw new IllegalArgumentException("Incosistent sizes: This array has size " + size + " the other array has size " + other.size());
        }
        int i = 0;
        while (i < size) {
            other.set(i, this.get(i));
            ++i;
        }
    }

    @Override
    public IDoubleArray viewRow(int i) {
        return new DoubleArrayView(this, i, 0, i + 1, this.columns());
    }

    @Override
    public IDoubleArray viewColumn(int j) {
        return new DoubleArrayView(this, 0, j, this.rows(), j + 1);
    }

    @Override
    public IDoubleArray viewBlock(int top, int left, int bottom, int right) {
        return new DoubleArrayView(this, top, left, bottom, right);
    }

    @Override
    public IDoubleArray view(int[] selectedRows, int[] selectedColumns) {
        return new DoubleArrayView((IDoubleArray)this, selectedRows, selectedColumns);
    }

    public boolean equals(Object o) {
        if (!(o instanceof IDoubleArray)) {
            return false;
        }
        IDoubleArray oo = (IDoubleArray)o;
        if (oo.size() != this.size()) {
            return false;
        }
        if (oo.rows() != this.rows()) {
            return false;
        }
        if (oo.columns() != this.columns()) {
            return false;
        }
        int i = 0;
        while (i < oo.size()) {
            if (oo.get(i) != this.get(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int hash = 3;
        return hash;
    }

    public String toString() {
        return Doubles.util.toString(this);
    }
}

