/*
 * Decompiled with CFR 0.152.
 */
package stallone.doubles;

import stallone.api.doubles.IDoubleArray;
import stallone.api.ints.IIntArray;
import stallone.api.ints.Ints;
import stallone.doubles.IArrayIndexMap;

class ArraySelectedIndexMap
implements IArrayIndexMap {
    private IIntArray Irows;
    private IIntArray Icols;
    private int nrows;
    private int ncols;
    private int size;

    public ArraySelectedIndexMap(IDoubleArray data, IIntArray _Irows, IIntArray _Icols) {
        this.Irows = _Irows;
        this.Icols = _Icols;
        this.nrows = this.Irows.size();
        this.ncols = this.Icols.size();
        this.size = this.nrows * this.ncols;
    }

    public ArraySelectedIndexMap(IDoubleArray data, IIntArray _Iindexes) {
        if (data.order() > 1) {
            throw new IllegalArgumentException("Cannot use order-1 array view constructor for a table");
        }
        if (data.columns() == 1) {
            this.Irows = _Iindexes;
            this.nrows = this.Irows.size();
            this.Icols = Ints.create.arrayFrom(0);
            this.ncols = 1;
        }
        if (data.rows() == 1) {
            this.Icols = _Iindexes;
            this.ncols = this.Icols.size();
            this.Irows = Ints.create.arrayFrom(0);
            this.nrows = 1;
        }
        this.size = this.nrows * this.ncols;
    }

    @Override
    public int getRow(int row) {
        return this.Irows.get(row);
    }

    @Override
    public int getColumn(int column) {
        return this.Icols.get(column);
    }

    @Override
    public int rows() {
        return this.nrows;
    }

    @Override
    public int columns() {
        return this.ncols;
    }

    @Override
    public int size() {
        return this.size;
    }
}

