/*
 * Decompiled with CFR 0.152.
 */
package stallone.doubles;

import stallone.api.API;
import stallone.api.doubles.IDoubleArray;
import stallone.doubles.AbstractDoubleArray;
import stallone.doubles.PrimitiveDoubleTools;

public class DenseDoubleArray
extends AbstractDoubleArray {
    protected double[] x;
    private int nrow;
    private int ncol;

    public DenseDoubleArray(int n) {
        this.x = new double[n];
        this.nrow = n;
        this.ncol = 1;
    }

    public DenseDoubleArray(int _nrow, int _ncol) {
        this.nrow = _nrow;
        this.ncol = _ncol;
        this.x = new double[_nrow * _ncol];
    }

    public DenseDoubleArray(double[] _x) {
        this.nrow = _x.length;
        this.ncol = 1;
        this.x = _x;
    }

    public DenseDoubleArray(double[][] _x) {
        this.nrow = _x.length;
        this.ncol = _x[0].length;
        this.x = new double[this.nrow * this.ncol];
        int k = 0;
        int i = 0;
        while (i < this.nrow) {
            int j = 0;
            while (j < this.ncol) {
                this.x[k++] = _x[i][j];
                ++j;
            }
            ++i;
        }
    }

    public DenseDoubleArray(IDoubleArray _x) {
        this.nrow = _x.rows();
        this.ncol = _x.columns();
        this.x = new double[this.nrow * this.ncol];
        int k = 0;
        int i = 0;
        while (i < this.nrow) {
            int j = 0;
            while (j < this.ncol) {
                this.x[k++] = _x.get(i, j);
                ++j;
            }
            ++i;
        }
    }

    public void reshape(int nrownew, int ncolnew) {
        if (nrownew * ncolnew != this.nrow * this.ncol) {
            throw new IllegalArgumentException("Trying to reshape a (" + this.nrow + "," + this.ncol + ") array into a (" + this.nrow + "," + this.ncol + ") array failed. Shapes are not compatible");
        }
        this.nrow = nrownew;
        this.ncol = ncolnew;
    }

    @Override
    public double get(int i) {
        try {
            return this.x[i];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Array index error: Trying to access element (" + i + "," + 0 + ") in a (" + this.nrow + "," + this.ncol + ") array");
        }
    }

    @Override
    public double get(int i, int j) {
        try {
            if (this.ncol == 1 && j == 0) {
                return this.x[i];
            }
            if (this.nrow == 1 && i == 0) {
                return this.x[j];
            }
            return this.x[i * this.ncol + j];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Array index error: Trying to access element (" + i + "," + j + ") in a (" + this.nrow + "," + this.ncol + ") array");
        }
    }

    @Override
    public void set(int i, double v) {
        try {
            this.x[i] = v;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Array index error: Trying to access element (" + i + "," + 0 + ") in a (" + this.nrow + "," + this.ncol + ") array");
        }
    }

    @Override
    public void set(int i, int j, double val) {
        try {
            if (this.ncol == 1 && j == 0) {
                this.x[i] = val;
            } else if (this.nrow == 1 && i == 0) {
                this.x[j] = val;
            } else {
                this.x[i * this.ncol + j] = val;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Array index error: Trying to access element (" + i + "," + j + ") in a (" + this.nrow + "," + this.ncol + ") array");
        }
    }

    @Override
    public void copyFrom(IDoubleArray other) {
        int i = 0;
        while (i < other.size()) {
            this.x[i] = other.get(i);
            ++i;
        }
    }

    public void set(double[] _x) {
        this.x = _x;
        this.nrow = _x.length;
        this.ncol = 1;
    }

    @Override
    public double[] getArray() {
        return this.x;
    }

    @Override
    public int size() {
        return this.x.length;
    }

    @Override
    public IDoubleArray copy() {
        DenseDoubleArray res = new DenseDoubleArray(PrimitiveDoubleTools.copy(this.x));
        res.reshape(this.nrow, this.ncol);
        return res;
    }

    @Override
    public IDoubleArray create(int size) {
        return new DenseDoubleArray(new double[size]);
    }

    @Override
    public int order() {
        if (this.nrow == 1 || this.ncol == 1) {
            return 1;
        }
        return 2;
    }

    @Override
    public int rows() {
        return this.nrow;
    }

    @Override
    public int columns() {
        return this.ncol;
    }

    @Override
    public IDoubleArray create(int rows, int columns) {
        return new DenseDoubleArray(rows, columns);
    }

    @Override
    public boolean isSparse() {
        return false;
    }

    public static void main(String[] args) {
        DenseDoubleArray da = new DenseDoubleArray(2, 2);
        da.set(0, 0, 0.9);
        da.set(0, 1, 0.1);
        da.set(1, 0, 0.1);
        da.set(1, 1, 0.9);
        IDoubleArray da2 = API.alg.product(da, da);
        System.out.println(da2);
    }
}

