/*
 * Decompiled with CFR 0.152.
 */
package stallone.doubles;

import stallone.api.doubles.IDoubleArray;
import stallone.api.doubles.IDoubleList;
import stallone.doubles.AbstractDoubleArray;
import stallone.doubles.DoubleArrayView;
import stallone.doubles.fastutils.DoubleArrayList;

public class DoubleArrayList_FastUtilWrapper
extends AbstractDoubleArray
implements IDoubleList {
    private DoubleArrayList list;

    private DoubleArrayList_FastUtilWrapper(DoubleArrayList _list) {
        this.list = _list;
    }

    public DoubleArrayList_FastUtilWrapper() {
        this.list = new DoubleArrayList();
    }

    public DoubleArrayList_FastUtilWrapper(int capacity) {
        this.list = new DoubleArrayList(capacity);
    }

    public DoubleArrayList_FastUtilWrapper(double[] a) {
        this.list = new DoubleArrayList(a);
    }

    @Override
    public void append(double value) {
        this.list.add(value);
    }

    @Override
    public void appendAll(IDoubleArray values) {
        int i = 0;
        while (i < values.size()) {
            this.list.add(values.get(i));
            ++i;
        }
    }

    @Override
    public void insert(int index, double value) {
        this.list.add(index, value);
    }

    @Override
    public void insertAll(int index, IDoubleArray values) {
        int i = 0;
        while (i < values.size()) {
            this.list.add(index + i, values.get(i));
            ++i;
        }
    }

    @Override
    public void remove(int index) {
        this.list.remove(index);
    }

    @Override
    public void removeRange(int from, int to) {
        int i = from;
        while (i < to) {
            this.list.remove(from);
            ++i;
        }
    }

    @Override
    public void removeByValue(double value) {
        this.list.rem(value);
    }

    @Override
    public double get(int i) {
        return this.list.get(i);
    }

    @Override
    public void set(int i, double v) {
        this.list.set(i, v);
    }

    @Override
    public void copyFrom(IDoubleArray other) {
        this.list.ensureCapacity(other.size());
        int i = 0;
        while (i < other.size()) {
            this.list.set(i, other.get(i));
            ++i;
        }
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public IDoubleList copy() {
        return new DoubleArrayList_FastUtilWrapper(this.list.clone());
    }

    @Override
    public IDoubleArray create(int size) {
        return new DoubleArrayList_FastUtilWrapper(size);
    }

    @Override
    public double[] getArray() {
        return this.list.toDoubleArray();
    }

    @Override
    public int order() {
        return 1;
    }

    @Override
    public int rows() {
        return this.size();
    }

    @Override
    public int columns() {
        return 1;
    }

    @Override
    public double get(int i, int j) {
        if (j != 0) {
            throw new ArrayIndexOutOfBoundsException("This is a list. Column index " + j + " does not exist!");
        }
        return this.get(i);
    }

    @Override
    public void set(int i, int j, double x) {
        if (j != 0) {
            throw new ArrayIndexOutOfBoundsException("This is a list. Column index " + j + " does not exist!");
        }
        this.set(i, x);
    }

    @Override
    public double[][] getTable() {
        double[][] res = new double[this.size()][1];
        int i = 0;
        while (i < res.length) {
            res[i][0] = this.get(i);
            ++i;
        }
        return res;
    }

    @Override
    public double[] getRow(int i) {
        return new double[]{this.get(i)};
    }

    @Override
    public double[] getColumn(int j) {
        if (j != 0) {
            throw new ArrayIndexOutOfBoundsException("This is a list. Column index " + j + " does not exist!");
        }
        return this.getArray();
    }

    @Override
    public IDoubleArray create(int rows, int columns) {
        if (columns > 1) {
            throw new IllegalArgumentException("Cannot create a list with more than one column");
        }
        return new DoubleArrayList_FastUtilWrapper(rows);
    }

    @Override
    public IDoubleArray viewRow(int i) {
        return new DoubleArrayView(this, i, 0, i + 1, 1);
    }

    @Override
    public IDoubleArray viewColumn(int j) {
        if (j != 0) {
            throw new ArrayIndexOutOfBoundsException("This is a column array. Column index " + j + " does not exist!");
        }
        return this;
    }

    @Override
    public boolean isSparse() {
        return false;
    }
}

