/*
 * Decompiled with CFR 0.152.
 */
package stallone.doubles;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.StringTokenizer;
import stallone.api.doubles.Doubles;
import stallone.api.doubles.IDoubleArray;
import stallone.api.doubles.IDoubleElement;
import stallone.api.doubles.IDoubleIterator;
import stallone.io.BlockFileReader;
import stallone.util.StringTools;

public class DoubleIO {
    public static void print(IDoubleArray arr, String del, Appendable app) {
        DoubleIO.print(arr, del, del, app);
    }

    public static void print(IDoubleArray arr, String del, int predig, int postdig, Appendable app) {
        DoubleIO.print(arr, del, del, predig, postdig, app);
    }

    public static String toString(IDoubleArray arr, String del) {
        StringBuilder strb = new StringBuilder();
        DoubleIO.print(arr, "\t", strb);
        return strb.toString();
    }

    public static void print(IDoubleArray arr, String del) {
        DoubleIO.print(arr, del, System.out);
    }

    public static String toString(IDoubleArray arr, String del, int predig, int postdig) {
        StringBuilder strb = new StringBuilder();
        DoubleIO.print(arr, del, predig, postdig, strb);
        return strb.toString();
    }

    public static void print(IDoubleArray arr, String del, int predig, int postdig) {
        DoubleIO.print(arr, del, predig, postdig, System.out);
    }

    public static IDoubleArray readDoubleArray(String str, String delimiters) {
        StringTokenizer tok = new StringTokenizer(str, delimiters);
        int n = tok.countTokens();
        IDoubleArray res = Doubles.create.array(n);
        int k = 0;
        while (tok.hasMoreTokens()) {
            res.set(k++, StringTools.toDouble(tok.nextToken()));
        }
        return res;
    }

    public static IDoubleArray readDoubleArray(String str) {
        return DoubleIO.readDoubleArray(str, " ,;\t\n");
    }

    public static void print(IDoubleArray arr, String coldel, String linedel, Appendable app) {
        try {
            int i = 0;
            while (i < arr.rows()) {
                int j = 0;
                while (j < arr.columns()) {
                    app.append(String.valueOf(arr.get(i, j)));
                    if (j < arr.columns() - 1) {
                        app.append(coldel);
                    }
                    ++j;
                }
                app.append(linedel);
                ++i;
            }
        }
        catch (IOException e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
    }

    public static void print(IDoubleArray arr, String coldel, String linedel, int predig, int postdig, Appendable app) {
        try {
            int i = 0;
            while (i < arr.rows()) {
                int j = 0;
                while (j < arr.columns()) {
                    app.append(StringTools.toPrecision(arr.get(i, j), predig, postdig));
                    if (j < arr.columns() - 1) {
                        app.append(coldel);
                    }
                    ++j;
                }
                app.append(linedel);
                ++i;
            }
        }
        catch (IOException e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
    }

    public static String toString(IDoubleArray arr) {
        if (arr.order() <= 1 && arr.columns() == 1) {
            return DoubleIO.toString(arr, "\n");
        }
        if (arr.order() <= 1 && arr.rows() == 1) {
            return DoubleIO.toString(arr, "\t");
        }
        if (arr.order() == 2) {
            return DoubleIO.toString(arr, "\t", "\n");
        }
        throw new RuntimeException("Trying to print array with order " + arr.order() + ". Currently not implemented");
    }

    public static void print(IDoubleArray arr, Appendable out) {
        if (arr.order() <= 1 && arr.columns() == 1) {
            DoubleIO.print(arr, "\n", out);
        } else if (arr.order() <= 1 && arr.rows() == 1) {
            DoubleIO.print(arr, "\t", out);
        } else if (arr.order() == 2) {
            DoubleIO.print(arr, "\t", "\n", out);
        } else {
            throw new RuntimeException("Trying to print array with order " + arr.order() + ". Currently not implemented");
        }
    }

    public static void print(IDoubleArray arr) {
        DoubleIO.print(arr, System.out);
    }

    public static String toString(IDoubleArray arr, String coldel, String linedel) {
        StringBuilder strbuf = new StringBuilder();
        DoubleIO.print(arr, coldel, linedel, strbuf);
        return strbuf.toString();
    }

    public static void print(IDoubleArray arr, String coldel, String linedel) {
        DoubleIO.print(arr, coldel, linedel, System.out);
    }

    public static String toString(IDoubleArray arr, String coldel, String linedel, int predig, int postdig) {
        StringBuilder strbuf = new StringBuilder("");
        DoubleIO.print(arr, coldel, linedel, predig, postdig, strbuf);
        return strbuf.toString();
    }

    public static void print(IDoubleArray arr, String coldel, String linedel, int predig, int postdig) {
        DoubleIO.print(arr, coldel, linedel, predig, postdig, System.out);
    }

    private static boolean isSparseFormat(BlockFileReader reader) {
        boolean sparse = false;
        String firstWord = reader.getWord(0, 0);
        if (firstWord.equalsIgnoreCase("SPARSE") || firstWord.equalsIgnoreCase("DENSE")) {
            sparse = firstWord.equalsIgnoreCase("SPARSE");
        } else {
            int[] lnbd;
            int[] libd = reader.getLargestIntBlockDimensions();
            if (libd[0] == (lnbd = reader.getLargestNumberBlockDimensions())[0] && (libd[1] == 2 || libd[1] == 3) && lnbd[1] == 3) {
                sparse = true;
            }
        }
        return sparse;
    }

    public static IDoubleArray readDoubleMatrix(String file) throws FileNotFoundException, IOException {
        BlockFileReader reader = new BlockFileReader(file);
        reader.scan();
        boolean sparse = DoubleIO.isSparseFormat(reader);
        double[][] block = reader.getLargestDoubleBlock();
        IDoubleArray res = null;
        if (sparse) {
            int nrows = 0;
            int ncols = 0;
            int i = 0;
            while (i < block.length) {
                if (block[i][0] > (double)nrows) {
                    nrows = (int)block[i][0];
                }
                if (block[i][1] > (double)ncols) {
                    ncols = (int)block[i][1];
                }
                ++i;
            }
            res = Doubles.create.matrix(nrows + 1, ncols + 1);
            i = 0;
            while (i < block.length) {
                res.set((int)block[i][0], (int)block[i][1], block[i][2]);
                ++i;
            }
        } else {
            res = Doubles.create.array(block);
        }
        return res;
    }

    public static void writeMatrixDense(IDoubleArray M, Appendable app) throws IOException {
        int nrows = M.rows();
        int ncols = M.columns();
        int i = 0;
        while (i < nrows) {
            int j = 0;
            while (j < ncols) {
                app.append(String.valueOf(M.get(i, j)) + " ");
                ++j;
            }
            app.append("\n");
            ++i;
        }
    }

    public static void writeMatrixDense(IDoubleArray M, String filename) throws IOException {
        PrintStream out = new PrintStream(filename);
        DoubleIO.writeMatrixDense(M, out);
        out.close();
    }

    public static void writeMatrixSparse(IDoubleArray M, Appendable app) throws IOException {
        IDoubleIterator it = M.nonzeroIterator();
        while (it.hasNext()) {
            IDoubleElement de = it.next();
            app.append(String.valueOf(de.row()) + "\t" + de.column() + "\t" + de.get() + "\n");
        }
    }

    public static void writeMatrixSparse(IDoubleArray M, String filename) throws IOException {
        PrintStream out = new PrintStream(filename);
        DoubleIO.writeMatrixSparse(M, out);
        out.close();
    }
}

