/*
 * Decompiled with CFR 0.152.
 */
package stallone.doubles;

import stallone.api.doubles.IDifferentiableMetric;
import stallone.api.doubles.IDoubleArray;

public class EuclideanDistance
implements IDifferentiableMetric<IDoubleArray> {
    private double d = 0.0;
    private int i = 0;
    private int size = 0;

    @Override
    public double distance(IDoubleArray x, IDoubleArray y) {
        this.d = 0.0;
        this.size = x.size();
        this.i = 0;
        while (this.i < this.size) {
            double dd = x.get(this.i) - y.get(this.i);
            this.d += dd * dd;
            ++this.i;
        }
        this.d = Math.sqrt(this.d);
        return this.d;
    }

    @Override
    public IDoubleArray gradientX(IDoubleArray x, IDoubleArray y) {
        double dxy = this.distance(x, y);
        IDoubleArray res = x.copy();
        this.size = res.size();
        if (dxy == 0.0) {
            this.i = 0;
            while (this.i < this.size) {
                res.set(this.i, 0.0);
                ++this.i;
            }
        } else {
            this.i = 0;
            while (this.i < this.size) {
                res.set(this.i, (x.get(this.i) - y.get(this.i)) / dxy);
                ++this.i;
            }
        }
        return res;
    }

    @Override
    public IDoubleArray gradientY(IDoubleArray x, IDoubleArray y) {
        double dxy = this.distance(x, y);
        IDoubleArray res = x.copy();
        if (dxy == 0.0) {
            this.i = 0;
            while (this.i < res.size()) {
                res.set(this.i, 0.0);
                ++this.i;
            }
        } else {
            this.i = 0;
            while (this.i < res.size()) {
                res.set(this.i, -(x.get(this.i) - y.get(this.i)) / dxy);
                ++this.i;
            }
        }
        return res;
    }
}

