/*
 * Decompiled with CFR 0.152.
 */
package stallone.doubles;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.List;
import stallone.ints.PrimitiveIntTools;

public class PrimitiveDoubleTools {
    public static double[] List2Array(List<?> al) {
        int size = al.size();
        double[] res = new double[size];
        System.arraycopy(al, 0, res, 0, size);
        return res;
    }

    public static double[][] List2Array2(List<?> al) {
        int size = al.size();
        double[][] res = new double[size][];
        int i = 0;
        while (i < size) {
            res[i] = (double[])al.get(i);
            ++i;
        }
        return res;
    }

    public static double[][][] List2Array3(List<?> al) {
        int size = al.size();
        double[][][] res = new double[size][][];
        int i = 0;
        while (i < size) {
            res[i] = (double[][])al.get(i);
            ++i;
        }
        return res;
    }

    public static double[] createInitialized(int size, double d) {
        double[] res = new double[size];
        Arrays.fill(res, d);
        return res;
    }

    public static double[] getDoubleArray(double ... d) {
        double[] arr = new double[d.length];
        System.arraycopy(d, 0, arr, 0, d.length);
        return arr;
    }

    public static double[] from(int[] a) {
        double[] res = new double[a.length];
        int i = 0;
        while (i < a.length) {
            res[i] = a[i];
            ++i;
        }
        return res;
    }

    public static double[][] from(int[][] a) {
        double[][] res = new double[a.length][];
        int i = 0;
        while (i < a.length) {
            res[i] = PrimitiveDoubleTools.from(a[i]);
            ++i;
        }
        return res;
    }

    public static double[] from(float[] a) {
        double[] res = new double[a.length];
        int i = 0;
        while (i < a.length) {
            res[i] = a[i];
            ++i;
        }
        return res;
    }

    public static double[][] from(float[][] a) {
        double[][] res = new double[a.length][];
        int i = 0;
        while (i < a.length) {
            res[i] = PrimitiveDoubleTools.from(a[i]);
            ++i;
        }
        return res;
    }

    public static int[] lengths(double[][] M) {
        int[] res = new int[M.length];
        int i = 0;
        while (i < M.length) {
            res[i] = M[i].length;
            ++i;
        }
        return res;
    }

    public static double[][] unitMatrix(int n) {
        double[][] res = new double[n][n];
        int i = 0;
        while (i < n) {
            res[i][i] = 1.0;
            ++i;
        }
        return res;
    }

    public static double[] randomArray(int n) {
        double[] res = new double[n];
        int i = 0;
        while (i < n) {
            res[i] = Math.random();
            ++i;
        }
        return res;
    }

    public static double[] randomDirection(int n) {
        double[] res = PrimitiveDoubleTools.randomArray(n);
        res = PrimitiveDoubleTools.add(res, -0.5);
        return PrimitiveDoubleTools.normalize(res);
    }

    public static double[] getRepeat(double val, int n) {
        double[] res = new double[n];
        Arrays.fill(res, val);
        return res;
    }

    public static double[] range(double start, double end, double step) {
        int N = (int)Math.ceil((end - start) / step);
        double[] res = new double[N];
        res[0] = start;
        int i = 1;
        while (i < res.length) {
            res[i] = res[i - 1] + step;
            ++i;
        }
        return res;
    }

    public static double[] mirror(double[] arr) {
        double[] res = new double[arr.length];
        int i = 0;
        while (i < arr.length) {
            res[res.length - 1 - i] = arr[i];
            ++i;
        }
        return res;
    }

    public static double[] diagonal(double[][] M) {
        double[] res = new double[M.length];
        int i = 0;
        while (i < M.length) {
            res[i] = M[i][i];
            ++i;
        }
        return res;
    }

    public static double[][] transpose(double[][] arr) {
        int nCol = arr.length;
        int nLin = arr[0].length;
        int i = 0;
        while (i < arr.length) {
            if (arr[i].length != nLin) {
                throw new IllegalArgumentException("Trying to transpose a non-matrix-array");
            }
            ++i;
        }
        double[][] res = new double[nLin][nCol];
        int i2 = 0;
        while (i2 < res.length) {
            int j = 0;
            while (j < res[i2].length) {
                res[i2][j] = arr[j][i2];
                ++j;
            }
            ++i2;
        }
        return res;
    }

    public static double[][] translate(double[][] crds, double[] T) {
        double[][] res = PrimitiveDoubleTools.copy(crds);
        int i = 0;
        while (i < res.length) {
            PrimitiveDoubleTools.increment(res[i], T);
            ++i;
        }
        return res;
    }

    public static double[] square(double[] arr) {
        double[] res = new double[arr.length];
        int i = 0;
        while (i < arr.length) {
            int n = i;
            res[n] = res[n] + arr[i] * arr[i];
            ++i;
        }
        return res;
    }

    public static double norm(double[] arr) {
        double n = 0.0;
        int i = 0;
        while (i < arr.length) {
            n += arr[i] * arr[i];
            ++i;
        }
        return Math.sqrt(n);
    }

    public static double[] normalize(double[] arr) {
        double n = PrimitiveDoubleTools.norm(arr);
        double[] res = new double[arr.length];
        int i = 0;
        while (i < arr.length) {
            res[i] = arr[i] / n;
            ++i;
        }
        return res;
    }

    public static double dot(double[] arr1, double[] arr2) {
        double v = 0.0;
        int i = 0;
        while (i < arr1.length) {
            v += arr1[i] * arr2[i];
            ++i;
        }
        return v;
    }

    public static double dot(double[] arr1, double[] arr2, double[] w) {
        double v = 0.0;
        int i = 0;
        while (i < arr1.length) {
            v += w[i] * arr1[i] * arr2[i];
            ++i;
        }
        return v;
    }

    public static double[] add(double[] arr1, double v) {
        double[] res = new double[arr1.length];
        int i = 0;
        while (i < arr1.length) {
            res[i] = arr1[i] + v;
            ++i;
        }
        return res;
    }

    public static double[] add(double[] arr1, double[] arr2) {
        double[] res = new double[arr1.length];
        int i = 0;
        while (i < arr1.length) {
            res[i] = arr1[i] + arr2[i];
            ++i;
        }
        return res;
    }

    public static double[][] add(double[][] arr1, double[][] arr2) {
        double[][] res = new double[arr1.length][];
        int i = 0;
        while (i < arr1.length) {
            res[i] = new double[arr1[i].length];
            int j = 0;
            while (j < arr1[i].length) {
                res[i][j] = arr1[i][j] + arr2[i][j];
                ++j;
            }
            ++i;
        }
        return res;
    }

    public static double[][] add(double[][] arr1, double v) {
        double[][] res = new double[arr1.length][];
        int i = 0;
        while (i < arr1.length) {
            res[i] = PrimitiveDoubleTools.add(arr1[i], v);
            ++i;
        }
        return res;
    }

    public static double[] addWeighted(double w1, double[] arr1, double w2, double[] arr2) {
        if (arr1.length != arr2.length) {
            throw new IllegalArgumentException("incompatible vectors!");
        }
        double[] res = new double[arr1.length];
        int i = 0;
        while (i < arr1.length) {
            res[i] = w1 * arr1[i] + w2 * arr2[i];
            ++i;
        }
        return res;
    }

    public static double[] insert(double[] arr, int index, double v) {
        double[] res = new double[arr.length + 1];
        int j = 0;
        int i = 0;
        while (i < index) {
            res[j++] = arr[i];
            ++i;
        }
        res[j++] = v;
        i = index;
        while (i < arr.length) {
            res[j++] = arr[i];
            ++i;
        }
        return res;
    }

    public static double[][] insert(double[][] arr, int index, double[] v) {
        double[][] res = new double[arr.length + 1][];
        int j = 0;
        int i = 0;
        while (i < index) {
            res[j++] = arr[i];
            ++i;
        }
        res[j++] = v;
        i = index;
        while (i < arr.length) {
            res[j++] = arr[i];
            ++i;
        }
        return res;
    }

    public static int locateSorted(double[] arr, double num) {
        int l = 0;
        int m = arr.length / 2;
        int r = arr.length;
        boolean found = false;
        while (!found) {
            if (num < arr[m]) {
                r = m;
                m = (r + l) / 2;
            } else if (num > arr[m]) {
                l = m;
                m = (r + l) / 2;
            } else {
                found = true;
            }
            if (m != l && m != r) continue;
            found = true;
        }
        found = false;
        while (!found) {
            if (m == 0) {
                found = true;
                continue;
            }
            if (arr[m - 1] != arr[m]) {
                found = true;
                continue;
            }
            --m;
        }
        if (num > arr[m]) {
            ++m;
        }
        return m;
    }

    public static int findSorted(double[] arr, double num) {
        int i = PrimitiveDoubleTools.locateSorted(arr, num);
        if (arr[i] == num) {
            return i;
        }
        return -1;
    }

    public static double[] insertSorted(double[] arr, double num) {
        int i = PrimitiveDoubleTools.locateSorted(arr, num);
        return PrimitiveDoubleTools.insert(arr, i, num);
    }

    public static int insertSortedFixed(double[] arr, double num) {
        if (num >= arr[arr.length - 1]) {
            return -1;
        }
        int i = arr.length - 1;
        while (i >= 1) {
            if (!(arr[i - 1] >= num)) break;
            arr[i] = arr[i - 1];
            --i;
        }
        arr[i] = num;
        return i;
    }

    public static void increment(double[] arr1, double[] arr2) {
        int i = 0;
        while (i < arr1.length) {
            int n = i;
            arr1[n] = arr1[n] + arr2[i];
            ++i;
        }
    }

    public static void increment(double[] arr1, double v) {
        int i = 0;
        while (i < arr1.length) {
            int n = i++;
            arr1[n] = arr1[n] + v;
        }
    }

    public static void increment(double[][] arr1, double[][] arr2) {
        int i = 0;
        while (i < arr1.length) {
            int j = 0;
            while (j < arr1[i].length) {
                double[] dArray = arr1[i];
                int n = j;
                dArray[n] = dArray[n] + arr2[i][j];
                ++j;
            }
            ++i;
        }
    }

    public static void increment(double[][] arr1, double v) {
        int i = 0;
        while (i < arr1.length) {
            int j = 0;
            while (j < arr1[i].length) {
                double[] dArray = arr1[i];
                int n = j++;
                dArray[n] = dArray[n] + v;
            }
            ++i;
        }
    }

    public static void decrement(double[] arr1, double[] arr2) {
        int i = 0;
        while (i < arr1.length) {
            int n = i;
            arr1[n] = arr1[n] - arr2[i];
            ++i;
        }
    }

    public static void decrement(double[][] arr1, double[][] arr2) {
        int i = 0;
        while (i < arr1.length) {
            int j = 0;
            while (j < arr1[i].length) {
                double[] dArray = arr1[i];
                int n = j;
                dArray[n] = dArray[n] - arr2[i][j];
                ++j;
            }
            ++i;
        }
    }

    public static double[] subtract(double[] arr1, double[] arr2) {
        double[] res = new double[arr1.length];
        int i = 0;
        while (i < arr1.length) {
            res[i] = arr1[i] - arr2[i];
            ++i;
        }
        return res;
    }

    public static double[][] subtract(double[][] arr1, double[][] arr2) {
        double[][] res = new double[arr1.length][];
        int i = 0;
        while (i < arr1.length) {
            res[i] = new double[arr1[i].length];
            int j = 0;
            while (j < arr1[i].length) {
                res[i][j] = arr1[i][j] - arr2[i][j];
                ++j;
            }
            ++i;
        }
        return res;
    }

    public static double[] multiply(double[] arr1, double[] arr2) {
        double[] res = new double[arr1.length];
        int i = 0;
        while (i < arr1.length) {
            res[i] = arr1[i] * arr2[i];
            ++i;
        }
        return res;
    }

    public static double[][] multiply(double[][] arr1, double[][] arr2) {
        double[][] res = new double[arr1.length][];
        int i = 0;
        while (i < arr1.length) {
            res[i] = new double[arr1[i].length];
            int j = 0;
            while (j < arr1[i].length) {
                res[i][j] = arr1[i][j] * arr2[i][j];
                ++j;
            }
            ++i;
        }
        return res;
    }

    public static double[] multiply(double f, double[] arr) {
        double[] res = new double[arr.length];
        int i = 0;
        while (i < arr.length) {
            res[i] = f * arr[i];
            ++i;
        }
        return res;
    }

    public static double[][] multiply(double f, double[][] arr) {
        double[][] res = new double[arr.length][];
        int i = 0;
        while (i < arr.length) {
            res[i] = new double[arr[i].length];
            int j = 0;
            while (j < arr[i].length) {
                res[i][j] = f * arr[i][j];
                ++j;
            }
            ++i;
        }
        return res;
    }

    public static double[] negative(double[] arr) {
        return PrimitiveDoubleTools.multiply(-1.0, arr);
    }

    public static double[] invertElements(double[] arr) {
        double[] res = new double[arr.length];
        int i = 0;
        while (i < arr.length) {
            res[i] = 1.0 / arr[i];
            ++i;
        }
        return res;
    }

    public static double[][] negative(double[][] arr) {
        return PrimitiveDoubleTools.multiply(-1.0, arr);
    }

    public static double[][] invertElements(double[][] arr) {
        double[][] res = PrimitiveDoubleTools.alloc(arr);
        int i = 0;
        while (i < arr.length) {
            int j = 0;
            while (j < arr[i].length) {
                res[i][j] = 1.0 / arr[i][j];
                ++j;
            }
            ++i;
        }
        return res;
    }

    public static double[] divide(double[] arr1, double[] arr2) {
        double[] res = new double[arr1.length];
        int i = 0;
        while (i < arr1.length) {
            res[i] = arr1[i] / arr2[i];
            ++i;
        }
        return res;
    }

    public static double[][] divide(double[][] arr1, double[][] arr2) {
        double[][] res = new double[arr1.length][];
        int i = 0;
        while (i < arr1.length) {
            res[i] = new double[arr1[i].length];
            int j = 0;
            while (j < arr1[i].length) {
                res[i][j] = arr1[i][j] / arr2[i][j];
                ++j;
            }
            ++i;
        }
        return res;
    }

    public static double[] divide(double[] arr1, double d) {
        double[] res = new double[arr1.length];
        int i = 0;
        while (i < arr1.length) {
            res[i] = arr1[i] / d;
            ++i;
        }
        return res;
    }

    public static double[][] divide(double[][] arr1, double d) {
        double[][] res = new double[arr1.length][];
        int i = 0;
        while (i < arr1.length) {
            res[i] = new double[arr1[i].length];
            int j = 0;
            while (j < arr1[i].length) {
                res[i][j] = arr1[i][j] / d;
                ++j;
            }
            ++i;
        }
        return res;
    }

    public static double distance(double[] arr1, double[] arr2) {
        double d = 0.0;
        int i = 0;
        while (i < arr1.length) {
            double dev = arr1[i] - arr2[i];
            d += dev * dev;
            ++i;
        }
        return Math.sqrt(d);
    }

    public static double distance(double[][] arr1, double[][] arr2) {
        double d = 0.0;
        int i = 0;
        while (i < arr1.length) {
            int j = 0;
            while (j < arr1[i].length) {
                double dev = arr1[i][j] - arr2[i][j];
                d += dev * dev;
                ++j;
            }
            ++i;
        }
        return Math.sqrt(d);
    }

    public static int nearestNeighbor(double[][] crds, int v) {
        int imin = 0;
        double dmin = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < crds.length) {
            double d = PrimitiveDoubleTools.distance(crds[v], crds[i]);
            if (i != v && d < dmin) {
                dmin = d;
                imin = i;
            }
            ++i;
        }
        return imin;
    }

    public static boolean equal(double[] arr1, double[] arr2) {
        if (arr1 == null && arr2 == null) {
            return true;
        }
        if (arr1 == null && arr2 != null || arr1 != null && arr2 == null) {
            return false;
        }
        if (arr1.length != arr2.length) {
            return false;
        }
        int i = 0;
        while (i < arr1.length) {
            if (arr1[i] != arr2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equal(double[] arr1, double[] arr2, double tol) {
        if (arr1.length != arr2.length) {
            return false;
        }
        int i = 0;
        while (i < arr1.length) {
            if (arr1[i] != arr2[i] && (arr1[i] == 0.0 ? Math.abs(arr1[i] - arr2[i]) / Math.abs(arr2[i]) > tol : (arr2[i] == 0.0 ? Math.abs(arr1[i] - arr2[i]) / Math.abs(arr1[i]) > tol : Math.abs(arr1[i] - arr2[i]) / Math.abs(arr1[i]) > tol || Math.abs(arr1[i] - arr2[i]) / Math.abs(arr2[i]) > tol))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equal(double[][] arr1, double[][] arr2) {
        if (arr1.length != arr2.length) {
            return false;
        }
        int i = 0;
        while (i < arr1.length) {
            if (!PrimitiveDoubleTools.equal(arr1[i], arr2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equal(double[][] arr1, double[][] arr2, double tol) {
        if (arr1.length != arr2.length) {
            return false;
        }
        int i = 0;
        while (i < arr1.length) {
            if (!PrimitiveDoubleTools.equal(arr1[i], arr2[i], tol)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static double[] clean(double[] uncleaned) {
        if (uncleaned.length == 0) {
            return uncleaned;
        }
        Arrays.sort(uncleaned);
        double[] cleaned = new double[uncleaned.length];
        cleaned[0] = uncleaned[0];
        int k = 1;
        int i = 1;
        while (i < uncleaned.length) {
            if (uncleaned[i] != uncleaned[i - 1]) {
                cleaned[k++] = uncleaned[i];
            }
            ++i;
        }
        return PrimitiveDoubleTools.subarray(cleaned, 0, k);
    }

    public static double[] intersect(double[] arr1, double[] arr2) {
        double[] arr1c = PrimitiveDoubleTools.clean(arr1);
        double[] arr2c = PrimitiveDoubleTools.clean(arr2);
        double[] res = new double[Math.min(arr1c.length, arr2c.length)];
        int k = 0;
        int i = 0;
        while (i < arr1c.length) {
            int j = 0;
            while (j < arr2c.length) {
                if (arr1c[i] == arr2c[j]) {
                    res[k++] = arr1c[i];
                    break;
                }
                ++j;
            }
            ++i;
        }
        return PrimitiveDoubleTools.subarray(res, 0, k);
    }

    public static double[] smallValues(double[] arr, double maxValue) {
        double[] res = new double[arr.length];
        int k = 0;
        int i = 0;
        while (i < arr.length) {
            if (arr[i] <= maxValue) {
                res[k++] = arr[i];
            }
            ++i;
        }
        return PrimitiveDoubleTools.subarray(res, 0, k);
    }

    public static int[] smallValueIndexes(double[] arr, double maxValue) {
        int[] res = new int[arr.length];
        int k = 0;
        int i = 0;
        while (i < arr.length) {
            if (arr[i] <= maxValue) {
                res[k++] = i;
            }
            ++i;
        }
        return PrimitiveIntTools.subarray(res, 0, k);
    }

    public static double[] largeValues(double[] arr, double minValue) {
        double[] res = new double[arr.length];
        int k = 0;
        int i = 0;
        while (i < arr.length) {
            if (arr[i] >= minValue) {
                res[k++] = arr[i];
            }
            ++i;
        }
        return PrimitiveDoubleTools.subarray(res, 0, k);
    }

    public static int[] largeValueIndexes(double[] arr, double minValue) {
        int[] res = new int[arr.length];
        int k = 0;
        int i = 0;
        while (i < arr.length) {
            if (arr[i] >= minValue) {
                res[k++] = i;
            }
            ++i;
        }
        return PrimitiveIntTools.subarray(res, 0, k);
    }

    public static double[] within(double[] arr, double minVal, double maxVal) {
        double[] res = new double[arr.length];
        int k = 0;
        int i = 0;
        while (i < arr.length) {
            if (minVal <= arr[i] && arr[i] < maxVal) {
                res[k++] = arr[i];
            }
            ++i;
        }
        return PrimitiveDoubleTools.subarray(res, 0, k);
    }

    public static int[] withinIndexes(double[] arr, double minVal, double maxVal) {
        int[] res = new int[arr.length];
        int k = 0;
        int i = 0;
        while (i < arr.length) {
            if (minVal <= arr[i] && arr[i] < maxVal) {
                res[k++] = i;
            }
            ++i;
        }
        return PrimitiveIntTools.subarray(res, 0, k);
    }

    public static double[] center(double[][] crd) {
        double[] c = new double[crd[0].length];
        int i = 0;
        while (i < crd.length) {
            int j = 0;
            while (j < crd[i].length) {
                int n = j;
                c[n] = c[n] + crd[i][j];
                ++j;
            }
            ++i;
        }
        int j = 0;
        while (j < c.length) {
            int n = j++;
            c[n] = c[n] / (double)crd.length;
        }
        return c;
    }

    public static double mean(double[] arr) {
        return PrimitiveDoubleTools.sum(arr) / (double)arr.length;
    }

    public static double[] mean(double[][] arr) {
        double[] res = new double[arr[0].length];
        int i = 0;
        while (i < arr.length) {
            int j = 0;
            while (j < arr[i].length) {
                int n = j;
                res[n] = res[n] + arr[i][j];
                ++j;
            }
            ++i;
        }
        return PrimitiveDoubleTools.multiply(1.0 / (double)arr.length, res);
    }

    public static double variance(double[] arr) {
        if (arr.length == 1) {
            return -1.0;
        }
        double meanval = PrimitiveDoubleTools.mean(arr);
        double sum = 0.0;
        int i = 0;
        while (i < arr.length) {
            double err = arr[i] - meanval;
            sum += err * err;
            ++i;
        }
        return sum / (double)(arr.length - 1);
    }

    public static double stdDev(double[] arr) {
        return Math.sqrt(PrimitiveDoubleTools.variance(arr));
    }

    public static double lowerEstimate(double[] arr, double ratioCorrect) {
        int nCorrect = (int)Math.round((1.0 - ratioCorrect) * (double)(arr.length - 1));
        double[] arrSort = PrimitiveDoubleTools.copy(arr);
        Arrays.sort(arrSort);
        return arrSort[nCorrect];
    }

    public static double upperEstimate(double[] arr, double ratioCorrect) {
        int nCorrect = (int)Math.round(ratioCorrect * (double)(arr.length - 1));
        double[] arrSort = PrimitiveDoubleTools.copy(arr);
        Arrays.sort(arrSort);
        return arrSort[nCorrect];
    }

    public static double rmsd(double[] arr) {
        double sum = 0.0;
        int i = 0;
        while (i < arr.length) {
            sum += arr[i] * arr[i];
            ++i;
        }
        return Math.sqrt(sum / (double)arr.length);
    }

    public static double rmsd(double[] arr1, double[] arr2) {
        double sum = 0.0;
        int i = 0;
        while (i < arr1.length) {
            double d = arr1[i] - arr2[i];
            sum += d * d;
            ++i;
        }
        return Math.sqrt(sum / (double)arr1.length);
    }

    public static double rmsd(double[][] arr1, double[][] arr2) {
        double sum = 0.0;
        int i = 0;
        while (i < arr1.length) {
            double d = PrimitiveDoubleTools.distance(arr1[i], arr2[i]);
            sum += d * d;
            ++i;
        }
        return Math.sqrt(sum / (double)arr1.length);
    }

    public static double rmsd(double[][] arr) {
        double sum = 0.0;
        int i = 0;
        while (i < arr.length) {
            int j = 0;
            while (j < arr[i].length) {
                sum += arr[i][j] * arr[i][j];
                ++j;
            }
            ++i;
        }
        return Math.sqrt(sum / (double)arr.length);
    }

    public static double sum(double[] arr) {
        double sum = 0.0;
        int i = 0;
        while (i < arr.length) {
            sum += arr[i];
            ++i;
        }
        return sum;
    }

    public static double sum(double[][] arr) {
        double sum = 0.0;
        int i = 0;
        while (i < arr.length) {
            sum += PrimitiveDoubleTools.sum(arr[i]);
            ++i;
        }
        return sum;
    }

    public static int[] toInt(double[] arr) {
        int[] res = new int[arr.length];
        int i = 0;
        while (i < arr.length) {
            res[i] = (int)arr[i];
            ++i;
        }
        return res;
    }

    public static int findForward(double[] arr, double val, int from) {
        int i = from;
        while (i < arr.length) {
            if (arr[i] == val) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int findForward(double[] arr, double val) {
        return PrimitiveDoubleTools.findForward(arr, val, 0);
    }

    public static int findForward(double[][] arr, double[] val, int from) {
        int i = from;
        while (i < arr.length) {
            if (PrimitiveDoubleTools.equal(arr[i], val)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int findForward(double[][] arr, double[] val) {
        return PrimitiveDoubleTools.findForward(arr, val, 0);
    }

    public static int findBackwards(double[] arr, double val, int from) {
        int i = from;
        while (i >= 0) {
            if (arr[i] == val) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static int findBackwards(double[] arr, double val) {
        return PrimitiveDoubleTools.findBackwards(arr, val, 0);
    }

    public static int findBackwards(double[][] arr, double[] val, int from) {
        int i = from;
        while (i >= 0) {
            if (PrimitiveDoubleTools.equal(arr[i], val)) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static int findBackwards(double[][] arr, double[] val) {
        return PrimitiveDoubleTools.findBackwards(arr, val, 0);
    }

    public static int[] findAll(double[] arr, double val) {
        int[] res = new int[]{};
        int i = 0;
        while (i < arr.length) {
            if (arr[i] == val) {
                res = PrimitiveIntTools.concat(res, i);
            }
            ++i;
        }
        return res;
    }

    public static double[] copy(double[] arr) {
        if (arr == null) {
            return null;
        }
        double[] res = new double[arr.length];
        int i = 0;
        while (i < arr.length) {
            res[i] = arr[i];
            ++i;
        }
        return res;
    }

    public static double[][] copy(double[][] arr) {
        double[][] res = new double[arr.length][];
        int i = 0;
        while (i < arr.length) {
            if (arr[i] == null) {
                res[i] = null;
            } else {
                res[i] = new double[arr[i].length];
                int j = 0;
                while (j < arr[i].length) {
                    res[i][j] = arr[i][j];
                    ++j;
                }
            }
            ++i;
        }
        return res;
    }

    public static double[][] alloc(int[][] arr) {
        double[][] res = new double[arr.length][];
        int i = 0;
        while (i < arr.length) {
            res[i] = new double[arr[i].length];
            ++i;
        }
        return res;
    }

    public static void fill(double[][] arr, double v) {
        int i = 0;
        while (i < arr.length) {
            int j = 0;
            while (j < arr[i].length) {
                arr[i][j] = v;
                ++j;
            }
            ++i;
        }
    }

    public static double[][] alloc(double[][] arr) {
        double[][] res = new double[arr.length][];
        int i = 0;
        while (i < arr.length) {
            res[i] = new double[arr[i].length];
            ++i;
        }
        return res;
    }

    public static double[][] repeat(double[] arr, int n) {
        double[][] res = new double[n][];
        int i = 0;
        while (i < res.length) {
            res[i] = PrimitiveDoubleTools.copy(arr);
            ++i;
        }
        return res;
    }

    public static int maxIndex(double[] arr) {
        double m = Double.NEGATIVE_INFINITY;
        int im = 0;
        int i = 0;
        while (i < arr.length) {
            if (arr[i] > m) {
                m = arr[i];
                im = i;
            }
            ++i;
        }
        return im;
    }

    public static double max(double[] arr) {
        return arr[PrimitiveDoubleTools.maxIndex(arr)];
    }

    public static double max(double[][] arr) {
        double m = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < arr.length) {
            int j = 0;
            while (j < arr[i].length) {
                if (arr[i][j] > m) {
                    m = arr[i][j];
                }
                ++j;
            }
            ++i;
        }
        return m;
    }

    public static double maxForLine(double[][] arr, int i) {
        return PrimitiveDoubleTools.max(arr[i]);
    }

    public static double maxForColumn(double[][] arr, int i) {
        return PrimitiveDoubleTools.max(PrimitiveDoubleTools.getColumn(arr, i));
    }

    public static int minIndex(double[] arr) {
        double m = Double.POSITIVE_INFINITY;
        int im = 0;
        int i = 0;
        while (i < arr.length) {
            if (arr[i] < m) {
                m = arr[i];
                im = i;
            }
            ++i;
        }
        return im;
    }

    public static double min(double[] arr) {
        return arr[PrimitiveDoubleTools.minIndex(arr)];
    }

    public static double min(double[][] arr) {
        double m = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < arr.length) {
            int j = 0;
            while (j < arr[i].length) {
                if (arr[i][j] < m) {
                    m = arr[i][j];
                }
                ++j;
            }
            ++i;
        }
        return m;
    }

    public static int[] extremesIndexes(double[] arr) {
        double l = Double.POSITIVE_INFINITY;
        double u = Double.NEGATIVE_INFINITY;
        int[] I = new int[]{-1, -1};
        int i = 0;
        while (i < arr.length) {
            if (arr[i] < l) {
                l = arr[i];
                I[0] = i;
            }
            if (arr[i] > u) {
                u = arr[i];
                I[1] = i;
            }
            ++i;
        }
        return I;
    }

    public static double[] extremes(double[] arr) {
        int[] I = PrimitiveDoubleTools.extremesIndexes(arr);
        double[] res = new double[]{arr[I[0]], arr[I[1]]};
        return res;
    }

    public static int count(double[] arr, double val) {
        int c = 0;
        int i = 0;
        while (i < arr.length) {
            if (arr[i] == val) {
                ++c;
            }
            ++i;
        }
        return c;
    }

    public static int count(double[][] arr, double[] val) {
        int c = 0;
        int i = 0;
        while (i < arr.length) {
            if (PrimitiveDoubleTools.equal(arr[i], val)) {
                ++c;
            }
            ++i;
        }
        return c;
    }

    public static int[] sort(double[] arr) {
        if (arr.length == 0) {
            return new int[0];
        }
        int[] indexes = PrimitiveIntTools.range(arr.length);
        PrimitiveDoubleTools.quicksort(arr, indexes, 0, arr.length - 1);
        return indexes;
    }

    public static int[] sortedIndexes(double[] arr) {
        if (arr.length == 0) {
            return new int[0];
        }
        return PrimitiveDoubleTools.sort(PrimitiveDoubleTools.copy(arr));
    }

    /*
     * Unable to fully structure code
     */
    private static void quicksort(double[] arr, int[] indexes, int lo, int hi) {
        i = lo;
        j = hi;
        x = arr[(lo + hi) / 2];
        ** GOTO lbl16
        {
            ++i;
            do {
                if (arr[i] < x) continue block0;
                while (arr[j] > x) {
                    --j;
                }
                if (i > j) continue;
                PrimitiveDoubleTools.exchange(arr, i, j);
                PrimitiveIntTools.exchange(indexes, i, j);
                ++i;
                --j;
lbl16:
                // 3 sources

            } while (i <= j);
        }
        if (lo < j) {
            PrimitiveDoubleTools.quicksort(arr, indexes, lo, j);
        }
        if (i < hi) {
            PrimitiveDoubleTools.quicksort(arr, indexes, i, hi);
        }
    }

    public static int[] smallestIndexes(double[] arr, int n) {
        int[] indexes = PrimitiveDoubleTools.sortedIndexes(arr);
        return PrimitiveIntTools.subarray(indexes, 0, n);
    }

    public static double[] smallest(double[] arr, int n) {
        return PrimitiveDoubleTools.subarray(arr, PrimitiveDoubleTools.smallestIndexes(arr, n));
    }

    public static int[] largestIndexes(double[] arr, int n) {
        int[] indexes = PrimitiveDoubleTools.sortedIndexes(arr);
        return PrimitiveIntTools.subarray(indexes, indexes.length - n, indexes.length);
    }

    public static double[] largest(double[] arr, int n) {
        return PrimitiveDoubleTools.subarray(arr, PrimitiveDoubleTools.largestIndexes(arr, n));
    }

    public static void exchange(double[] arr, int i, int j) {
        double t = arr[i];
        arr[i] = arr[j];
        arr[j] = t;
    }

    public static double[][] reshape(double[] arr, int d1, int d2) {
        if (arr.length != d1 * d2) {
            throw new IllegalArgumentException("Illegal array size");
        }
        double[][] res = new double[d1][d2];
        int i = 0;
        while (i < d1) {
            int j = 0;
            while (j < d2) {
                res[i][j] = arr[i * d2 + j];
                ++j;
            }
            ++i;
        }
        return res;
    }

    public static double[] flatten(double[][] arr) {
        int n = 0;
        int i = 0;
        while (i < arr.length) {
            n += arr[i].length;
            ++i;
        }
        double[] res = new double[n];
        int i2 = 0;
        int k = 0;
        while (i2 < arr.length) {
            int j = 0;
            while (j < arr[i2].length) {
                res[k++] = arr[i2][j];
                ++j;
            }
            ++i2;
        }
        return res;
    }

    public static double[] subarray(double[] a, int i1, int i2) {
        double[] res = new double[i2 - i1];
        int i = i1;
        while (i < i2) {
            res[i - i1] = a[i];
            ++i;
        }
        return res;
    }

    public static double[][] subarray(double[][] a, int i1, int i2) {
        double[][] res = new double[i2 - i1][];
        int i = i1;
        while (i < i2) {
            res[i - i1] = a[i];
            ++i;
        }
        return res;
    }

    public static double[] subarray(double[] arr, int[] selection) {
        double[] res = new double[selection.length];
        int i = 0;
        while (i < selection.length) {
            res[i] = arr[selection[i]];
            ++i;
        }
        return res;
    }

    public static double[][] subarray(double[][] arr, int[] selection) {
        double[][] res = new double[selection.length][];
        int i = 0;
        while (i < selection.length) {
            res[i] = arr[selection[i]];
            ++i;
        }
        return res;
    }

    public static double[][] submatrix(double[][] arr, int[] selection) {
        double[][] M = new double[selection.length][selection.length];
        int i = 0;
        while (i < M.length) {
            int j = 0;
            while (j < M.length) {
                M[i][j] = arr[selection[i]][selection[j]];
                ++j;
            }
            ++i;
        }
        return M;
    }

    public static double[] getColumn(double[][] arr, int k) {
        double[] res = new double[arr.length];
        int i = 0;
        while (i < arr.length) {
            res[i] = arr[i][k];
            ++i;
        }
        return res;
    }

    public static double[] concat(double[] a1, double[] a2) {
        double[] res = new double[a1.length + a2.length];
        int j = 0;
        int i = 0;
        while (i < a1.length) {
            res[j++] = a1[i];
            ++i;
        }
        i = 0;
        while (i < a2.length) {
            res[j++] = a2[i];
            ++i;
        }
        return res;
    }

    public static double[][] concat(double[][] a1, double[][] a2) {
        double[][] res = new double[a1.length + a2.length][];
        int j = 0;
        int i = 0;
        while (i < a1.length) {
            res[j++] = a1[i];
            ++i;
        }
        i = 0;
        while (i < a2.length) {
            res[j++] = a2[i];
            ++i;
        }
        return res;
    }

    public static double[] concat(double[] a1, double a2) {
        double[] res = new double[a1.length + 1];
        int j = 0;
        int i = 0;
        while (i < a1.length) {
            res[j++] = a1[i];
            ++i;
        }
        res[j] = a2;
        return res;
    }

    public static double[][] concat(double[][] a1, double[] a2) {
        double[][] res = new double[a1.length + 1][];
        int j = 0;
        int i = 0;
        while (i < a1.length) {
            res[j++] = a1[i];
            ++i;
        }
        res[j] = a2;
        return res;
    }

    public static double[] removeByIndex(double[] arr, int index) {
        double[] res = new double[arr.length - 1];
        int j = 0;
        int i = 0;
        while (i < index) {
            res[j++] = arr[i];
            ++i;
        }
        i = index + 1;
        while (i < arr.length) {
            res[j++] = arr[i];
            ++i;
        }
        return res;
    }

    public static double[][] removeByIndex(double[][] arr, int index) {
        double[][] res = new double[arr.length - 1][];
        int j = 0;
        int i = 0;
        while (i < index) {
            res[j++] = arr[i];
            ++i;
        }
        i = index + 1;
        while (i < arr.length) {
            res[j++] = arr[i];
            ++i;
        }
        return res;
    }

    public static double[] removeByIndex(double[] arr, int[] index) {
        if (arr.length == 0) {
            return arr;
        }
        int[] keep = PrimitiveIntTools.removeByValue(PrimitiveIntTools.range(arr.length), index);
        return PrimitiveDoubleTools.subarray(arr, keep);
    }

    public static double[][] removeByIndex(double[][] arr, int[] index) {
        if (arr.length == 0) {
            return arr;
        }
        int[] keep = PrimitiveIntTools.removeByValue(PrimitiveIntTools.range(arr.length), index);
        return PrimitiveDoubleTools.subarray(arr, keep);
    }

    public static void print(double[] arr) {
        PrimitiveDoubleTools.print(arr, " ");
    }

    public static void print(double[] arr, String del) {
        if (arr == null) {
            System.out.println("null");
        }
        if (arr.length == 0) {
            System.out.println("");
        }
        if (arr.length > 0) {
            System.out.print(arr[0]);
        }
        int i = 1;
        while (i < arr.length) {
            System.out.print(String.valueOf(del) + arr[i]);
            ++i;
        }
    }

    public static void printInt(double[] arr, String del) {
        if (arr == null) {
            System.out.println("null");
        }
        if (arr.length == 0) {
            System.out.println("");
        }
        System.out.print((int)Math.round(arr[0]));
        int i = 1;
        while (i < arr.length) {
            System.out.print(String.valueOf(del) + (int)Math.round(arr[i]));
            ++i;
        }
    }

    public static void print(double[][] arr) {
        PrimitiveDoubleTools.print(arr, " ", "\n");
    }

    public static void print(double[][] arr, String coldel, String linedel) {
        int i = 0;
        while (i < arr.length) {
            PrimitiveDoubleTools.print(arr[i], coldel);
            System.out.print(linedel);
            ++i;
        }
    }

    public static String toString(double[] arr) {
        return PrimitiveDoubleTools.toString(arr, ",");
    }

    public static String toString(double[] arr, String del) {
        if (arr == null) {
            return "null";
        }
        if (arr.length == 0) {
            return "";
        }
        StringBuffer strbuf = new StringBuffer(String.valueOf(arr[0]));
        int i = 1;
        while (i < arr.length) {
            strbuf.append(String.valueOf(del) + arr[i]);
            ++i;
        }
        return strbuf.toString();
    }

    public static String toString(double[][] arr) {
        return PrimitiveDoubleTools.toString(arr, ",", "\n");
    }

    public static String toString(double[][] arr, String coldel, String linedel) {
        StringBuffer strbuf = new StringBuffer("");
        int i = 0;
        while (i < arr.length) {
            strbuf.append(String.valueOf(PrimitiveDoubleTools.toString(arr[i], coldel)) + linedel);
            ++i;
        }
        return strbuf.toString();
    }

    public static void save(double[] arr, String file) {
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(file));
            out.writeObject(arr);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static void save(double[][] arr, String file) {
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(file));
            out.writeObject(arr);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static double[][] loadMatrix(String file) {
        try {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(file));
            double[][] arr = (double[][])in.readObject();
            in.close();
            return arr;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
            return null;
        }
    }

    public static double[] load(String file) {
        try {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(file));
            double[] arr = (double[])in.readObject();
            in.close();
            return arr;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
            return null;
        }
    }
}

