/*
 * Decompiled with CFR 0.152.
 */
package stallone.doubles;

import stallone.api.doubles.IDoubleArray;
import stallone.api.doubles.IDoubleElement;
import stallone.api.doubles.IDoubleIterator;
import stallone.doubles.AbstractDoubleArray;
import stallone.doubles.SparseVectorIndexMap;
import stallone.doubles.SparseVectorNonzeroIterator;

public class SparseRealVector
extends AbstractDoubleArray {
    private SparseVectorIndexMap sparseIndexMap;
    protected double[] data;

    public SparseRealVector(int size) {
        this.sparseIndexMap = new MyIndexMap(size);
        this.data = new double[0];
    }

    protected SparseRealVector(SparseRealVector source) {
        this.sparseIndexMap = new MyIndexMap(source.getIndexMap());
        int nnz = source.getNumberOfNonzero();
        this.data = new double[nnz];
        System.arraycopy(source.data, 0, this.data, 0, nnz);
    }

    public final int getNumberOfNonzero() {
        return this.sparseIndexMap.usedNonZero;
    }

    @Override
    public void zero() {
        this.sparseIndexMap.lastRequestedIndex = -1;
        this.sparseIndexMap.lastRequestedPosition = -1;
        this.sparseIndexMap.usedNonZero = 0;
    }

    @Override
    public IDoubleArray copy() {
        return new SparseRealVector(this);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("( ");
        int i = 0;
        while (i < this.size()) {
            builder.append(this.get(i));
            if (i < this.size() - 1) {
                builder.append(", ");
            }
            ++i;
        }
        builder.append(" )");
        return builder.toString();
    }

    public String toStringOfInternalData() {
        return String.valueOf(SparseVectorIndexMap.toString(this.sparseIndexMap.nonZeroIndices, " ")) + "\n" + SparseVectorIndexMap.toString(this.data, " ") + "\n" + "Used: " + this.sparseIndexMap.usedNonZero;
    }

    @Override
    public IDoubleIterator nonzeroIterator() {
        return new SparseVectorNonzeroIterator(this, this.sparseIndexMap);
    }

    @Override
    public int rows() {
        return this.sparseIndexMap.size;
    }

    @Override
    public int columns() {
        return 1;
    }

    @Override
    public double get(int i, int j) {
        if (j != 0) {
            throw new ArrayIndexOutOfBoundsException("Invalid index to column vector: " + i + ", " + j);
        }
        int pos = this.sparseIndexMap.getPosition(i);
        if (pos < 0) {
            if (i >= 0 && i < this.size()) {
                return 0.0;
            }
            throw new ArrayIndexOutOfBoundsException("Invalid index to column vector: " + i + ", " + j);
        }
        return this.data[pos];
    }

    @Override
    public void set(int i, int j, double x) {
        if (j != 0) {
            throw new ArrayIndexOutOfBoundsException("Invalid index to column vector: " + i + ", " + j);
        }
        int pos = this.sparseIndexMap.getPosition(i);
        if (pos < 0) {
            if (i >= 0 && i < this.size()) {
                pos = this.sparseIndexMap.addIndex(i);
            } else {
                throw new ArrayIndexOutOfBoundsException("Invalid index to column vector: " + i + ", " + j);
            }
        }
        this.data[pos] = x;
    }

    @Override
    public IDoubleArray create(int size) {
        return new SparseRealVector(size);
    }

    @Override
    public IDoubleArray create(int rows, int columns) {
        if (columns != 1) {
            throw new ArrayIndexOutOfBoundsException("I'm a vector and cannot create a matrix with size: " + rows + ", " + columns);
        }
        return new SparseRealVector(rows);
    }

    public SparseVectorIndexMap getIndexMap() {
        return this.sparseIndexMap;
    }

    @Override
    public boolean isSparse() {
        return true;
    }

    public static void main(String[] args) {
        SparseRealVector v = new SparseRealVector(10);
        v.set(9, 0.0);
        v.set(0, 5.0);
        v.set(5, 2.0);
        IDoubleIterator it = v.nonzeroIterator();
        while (it.hasNext()) {
            IDoubleElement de = it.next();
            System.out.println(String.valueOf(de.index()) + " " + de.row() + " " + de.column() + " " + de.get());
        }
    }

    private class MyIndexMap
    extends SparseVectorIndexMap {
        public MyIndexMap(int _size) {
            super(_size);
        }

        public MyIndexMap(SparseVectorIndexMap base) {
            super(base);
        }

        @Override
        protected void augmentData(int newLength, int firstBlockLength, int secondBlockLength) {
            double[] newNonZeroData = new double[newLength];
            System.arraycopy(SparseRealVector.this.data, 0, newNonZeroData, 0, firstBlockLength);
            System.arraycopy(SparseRealVector.this.data, firstBlockLength, newNonZeroData, firstBlockLength + 1, secondBlockLength);
            SparseRealVector.this.data = newNonZeroData;
        }

        @Override
        protected void shiftDataRight(int firstBlockLength, int secondBlockLength) {
            System.arraycopy(SparseRealVector.this.data, firstBlockLength, SparseRealVector.this.data, firstBlockLength + 1, secondBlockLength);
        }

        @Override
        protected void shiftDataLeft(int firstBlockLength, int secondBlockLength) {
            System.arraycopy(SparseRealVector.this.data, firstBlockLength + 1, SparseRealVector.this.data, firstBlockLength, secondBlockLength);
        }
    }
}

