/*
 * Decompiled with CFR 0.152.
 */
package stallone.doubles;

import stallone.api.doubles.IDoubleArray;
import stallone.doubles.AbstractDoubleArray;

public class SymmetricMatrix
extends AbstractDoubleArray {
    private IDoubleArray underlyingMatrix;
    private int rows;
    private int cols;

    public SymmetricMatrix(IDoubleArray _underlyingMatrix) {
        this.rows = _underlyingMatrix.rows();
        this.cols = _underlyingMatrix.columns();
        this.underlyingMatrix = _underlyingMatrix;
    }

    @Override
    public IDoubleArray create(int rows, int cols) {
        return this.underlyingMatrix.create(rows, cols);
    }

    @Override
    public IDoubleArray copy() {
        return this.underlyingMatrix.copy();
    }

    @Override
    public void zero() {
        this.underlyingMatrix.zero();
    }

    @Override
    public IDoubleArray create(int size) {
        return this.underlyingMatrix.create(size);
    }

    @Override
    public double get(int i, int j) {
        if (i < j) {
            return this.underlyingMatrix.get(i, j);
        }
        return this.underlyingMatrix.get(j, i);
    }

    @Override
    public void set(int i, int j, double x) {
        if (i < j) {
            this.underlyingMatrix.set(i, j, x);
        } else {
            this.underlyingMatrix.set(j, i, x);
        }
    }

    @Override
    public int rows() {
        return this.rows;
    }

    @Override
    public int columns() {
        return this.cols;
    }

    @Override
    public boolean isSparse() {
        return this.underlyingMatrix.isSparse();
    }
}

