/*
 * Decompiled with CFR 0.152.
 */
package stallone.doubles.fastutils;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import stallone.doubles.fastutils.AbstractDoubleCollection;
import stallone.doubles.fastutils.AbstractDoubleListIterator;
import stallone.doubles.fastutils.DoubleCollection;
import stallone.doubles.fastutils.DoubleList;
import stallone.doubles.fastutils.DoubleListIterator;
import stallone.doubles.fastutils.DoubleStack;
import stallone.doubles.fastutils.HashCommon;

public abstract class AbstractDoubleList
extends AbstractDoubleCollection
implements DoubleList,
DoubleStack {
    protected AbstractDoubleList() {
    }

    protected void ensureIndex(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than list size (" + this.size() + ")");
        }
    }

    protected void ensureRestrictedIndex(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size() + ")");
        }
    }

    @Override
    public void add(int index, double k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(double k) {
        this.add(this.size(), k);
        return true;
    }

    @Override
    public double removeDouble(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double setAndReturnOld(int index, double k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends Double> c) {
        this.ensureIndex(index);
        int n = c.size();
        if (n == 0) {
            return false;
        }
        Iterator<? extends Double> i = c.iterator();
        while (n-- != 0) {
            this.add(index++, i.next());
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Double> c) {
        return this.addAll(this.size(), c);
    }

    @Override
    @Deprecated
    public DoubleListIterator doubleListIterator() {
        return this.listIterator();
    }

    @Override
    @Deprecated
    public DoubleListIterator doubleListIterator(int index) {
        return this.listIterator(index);
    }

    @Override
    public DoubleListIterator iterator() {
        return this.listIterator();
    }

    @Override
    public DoubleListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public DoubleListIterator listIterator(int index) {
        return new AbstractDoubleListIterator(index){
            int pos;
            int last;
            {
                this.pos = n;
                this.last = -1;
            }

            @Override
            public boolean hasNext() {
                return this.pos < AbstractDoubleList.this.size();
            }

            @Override
            public boolean hasPrevious() {
                return this.pos > 0;
            }

            @Override
            public double nextDouble() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos++;
                return AbstractDoubleList.this.getDouble(this.last);
            }

            @Override
            public double previousDouble() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.pos;
                return AbstractDoubleList.this.getDouble(this.pos);
            }

            @Override
            public int nextIndex() {
                return this.pos;
            }

            @Override
            public int previousIndex() {
                return this.pos - 1;
            }

            @Override
            public void add(double k) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                AbstractDoubleList.this.add(this.pos++, k);
                this.last = -1;
            }

            @Override
            public void set(double k) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                AbstractDoubleList.this.setAndReturnOld(this.last, k);
            }

            @Override
            public void remove() {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                AbstractDoubleList.this.removeDouble(this.last);
                if (this.last < this.pos) {
                    --this.pos;
                }
                this.last = -1;
            }
        };
    }

    @Override
    public boolean contains(double k) {
        return this.indexOf(k) >= 0;
    }

    @Override
    public int indexOf(double k) {
        DoubleListIterator i = this.listIterator();
        while (i.hasNext()) {
            double e = i.nextDouble();
            if (k != e) continue;
            return i.previousIndex();
        }
        return -1;
    }

    @Override
    public int lastIndexOf(double k) {
        DoubleListIterator i = this.listIterator(this.size());
        while (i.hasPrevious()) {
            double e = i.previousDouble();
            if (k != e) continue;
            return i.nextIndex();
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void size(int size) {
        block2: {
            i = this.size();
            if (size <= i) ** GOTO lbl10
            while (i++ < size) {
                this.add(0.0);
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                this.remove(i);
lbl10:
                // 2 sources

                ** while (i-- != size)
            }
        }
    }

    @Override
    public DoubleList subList(int from, int to) {
        this.ensureIndex(from);
        this.ensureIndex(to);
        if (from > to) {
            throw new IndexOutOfBoundsException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        return new DoubleSubList(this, from, to);
    }

    @Override
    @Deprecated
    public DoubleList doubleSubList(int from, int to) {
        return this.subList(from, to);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void removeElements(int from, int to) {
        this.ensureIndex(to);
        i = this.listIterator(from);
        n = to - from;
        if (n >= 0) ** GOTO lbl9
        throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
lbl-1000:
        // 1 sources

        {
            i.nextDouble();
            i.remove();
lbl9:
            // 2 sources

            ** while (n-- != 0)
        }
lbl10:
        // 1 sources

    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void addElements(int index, double[] a, int offset, int length) {
        this.ensureIndex(index);
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Offset (" + offset + ") is negative");
        }
        if (offset + length <= a.length) ** GOTO lbl7
        throw new ArrayIndexOutOfBoundsException("End index (" + (offset + length) + ") is greater than array length (" + a.length + ")");
lbl-1000:
        // 1 sources

        {
            this.add(index++, a[offset++]);
lbl7:
            // 2 sources

            ** while (length-- != 0)
        }
lbl8:
        // 1 sources

    }

    @Override
    public void addElements(int index, double[] a) {
        this.addElements(index, a, 0, a.length);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void getElements(int from, double[] a, int offset, int length) {
        i = this.listIterator(from);
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Offset (" + offset + ") is negative");
        }
        if (offset + length > a.length) {
            throw new ArrayIndexOutOfBoundsException("End index (" + (offset + length) + ") is greater than array length (" + a.length + ")");
        }
        if (from + length <= this.size()) ** GOTO lbl9
        throw new IndexOutOfBoundsException("End index (" + (from + length) + ") is greater than list size (" + this.size() + ")");
lbl-1000:
        // 1 sources

        {
            a[offset++] = i.nextDouble();
lbl9:
            // 2 sources

            ** while (length-- != 0)
        }
lbl10:
        // 1 sources

    }

    private boolean valEquals(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List l = (List)o;
        int s = this.size();
        if (s != l.size()) {
            return false;
        }
        DoubleListIterator i1 = this.listIterator();
        ListIterator i2 = l.listIterator();
        while (s-- != 0) {
            if (this.valEquals(i1.next(), i2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(List<? extends Double> l) {
        if (l == this) {
            return 0;
        }
        if (l instanceof DoubleList) {
            DoubleListIterator i1 = this.listIterator();
            DoubleListIterator i2 = ((DoubleList)l).listIterator();
            while (i1.hasNext() && i2.hasNext()) {
                int r;
                double e2;
                double e1 = i1.nextDouble();
                if ((e1 < (e2 = i2.nextDouble()) ? -1 : (r = e1 == e2 ? 0 : 1)) == 0) continue;
                return r;
            }
            return i2.hasNext() ? -1 : (i1.hasNext() ? 1 : 0);
        }
        DoubleListIterator i1 = this.listIterator();
        ListIterator<? extends Double> i2 = l.listIterator();
        while (i1.hasNext() && i2.hasNext()) {
            int r = ((Comparable)i1.next()).compareTo(i2.next());
            if (r == 0) continue;
            return r;
        }
        return i2.hasNext() ? -1 : (i1.hasNext() ? 1 : 0);
    }

    @Override
    public int hashCode() {
        DoubleListIterator i = this.iterator();
        int h = 1;
        int s = this.size();
        while (s-- != 0) {
            double k = i.nextDouble();
            h = 31 * h + HashCommon.double2int(k);
        }
        return h;
    }

    @Override
    public void push(double o) {
        this.add(o);
    }

    @Override
    public double popDouble() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.removeDouble(this.size() - 1);
    }

    @Override
    public double topDouble() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.getDouble(this.size() - 1);
    }

    @Override
    public double peekDouble(int i) {
        return this.getDouble(this.size() - 1 - i);
    }

    @Override
    public boolean rem(double k) {
        int index = this.indexOf(k);
        if (index == -1) {
            return false;
        }
        this.removeDouble(index);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        return this.rem((Double)o);
    }

    @Override
    public boolean addAll(int index, DoubleCollection c) {
        return this.addAll(index, (Collection<? extends Double>)c);
    }

    @Override
    public boolean addAll(int index, DoubleList l) {
        return this.addAll(index, (DoubleCollection)l);
    }

    @Override
    public boolean addAll(DoubleCollection c) {
        return this.addAll(this.size(), c);
    }

    @Override
    public boolean addAll(DoubleList l) {
        return this.addAll(this.size(), l);
    }

    @Override
    public void add(int index, Double ok) {
        this.add(index, (double)ok);
    }

    @Override
    public Double set(int index, Double ok) {
        return this.setAndReturnOld(index, ok);
    }

    @Override
    public Double get(int index) {
        return this.getDouble(index);
    }

    @Override
    public int indexOf(Object ok) {
        return this.indexOf((Double)ok);
    }

    @Override
    public int lastIndexOf(Object ok) {
        return this.lastIndexOf((Double)ok);
    }

    @Override
    public Double remove(int index) {
        return this.removeDouble(index);
    }

    @Override
    public void push(Double o) {
        this.push((double)o);
    }

    @Override
    public Double pop() {
        return this.popDouble();
    }

    @Override
    public Double top() {
        return this.topDouble();
    }

    @Override
    public Double peek(int i) {
        return this.peekDouble(i);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        DoubleListIterator i = this.iterator();
        int n = this.size();
        boolean first = true;
        s.append("[");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            double k = i.nextDouble();
            s.append(String.valueOf(k));
        }
        s.append("]");
        return s.toString();
    }

    public static class DoubleSubList
    extends AbstractDoubleList
    implements Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final DoubleList l;
        protected final int from;
        protected int to;
        private static final boolean ASSERTS = false;

        public DoubleSubList(DoubleList l, int from, int to) {
            this.l = l;
            this.from = from;
            this.to = to;
        }

        private void assertRange() {
        }

        @Override
        public boolean add(double k) {
            this.l.add(this.to, k);
            ++this.to;
            return true;
        }

        @Override
        public void add(int index, double k) {
            this.ensureIndex(index);
            this.l.add(this.from + index, k);
            ++this.to;
        }

        @Override
        public boolean addAll(int index, Collection<? extends Double> c) {
            this.ensureIndex(index);
            this.to += c.size();
            return this.l.addAll(this.from + index, c);
        }

        @Override
        public double getDouble(int index) {
            this.ensureRestrictedIndex(index);
            return this.l.getDouble(this.from + index);
        }

        @Override
        public double removeDouble(int index) {
            this.ensureRestrictedIndex(index);
            --this.to;
            return this.l.removeDouble(this.from + index);
        }

        @Override
        public double setAndReturnOld(int index, double k) {
            this.ensureRestrictedIndex(index);
            return this.l.setAndReturnOld(this.from + index, k);
        }

        @Override
        public void clear() {
            this.removeElements(0, this.size());
        }

        @Override
        public int size() {
            return this.to - this.from;
        }

        @Override
        public void getElements(int from, double[] a, int offset, int length) {
            this.ensureIndex(from);
            if (from + length > this.size()) {
                throw new IndexOutOfBoundsException("End index (" + from + length + ") is greater than list size (" + this.size() + ")");
            }
            this.l.getElements(this.from + from, a, offset, length);
        }

        @Override
        public void removeElements(int from, int to) {
            this.ensureIndex(from);
            this.ensureIndex(to);
            this.l.removeElements(this.from + from, this.from + to);
            this.to -= to - from;
        }

        @Override
        public void addElements(int index, double[] a, int offset, int length) {
            this.ensureIndex(index);
            this.l.addElements(this.from + index, a, offset, length);
            this.to += length;
        }

        @Override
        public DoubleListIterator listIterator(int index) {
            this.ensureIndex(index);
            return new AbstractDoubleListIterator(index){
                int pos;
                int last;
                {
                    this.pos = n;
                    this.last = -1;
                }

                @Override
                public boolean hasNext() {
                    return this.pos < DoubleSubList.this.size();
                }

                @Override
                public boolean hasPrevious() {
                    return this.pos > 0;
                }

                @Override
                public double nextDouble() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.last = this.pos++;
                    return DoubleSubList.this.l.getDouble(DoubleSubList.this.from + this.last);
                }

                @Override
                public double previousDouble() {
                    if (!this.hasPrevious()) {
                        throw new NoSuchElementException();
                    }
                    this.last = --this.pos;
                    return DoubleSubList.this.l.getDouble(DoubleSubList.this.from + this.pos);
                }

                @Override
                public int nextIndex() {
                    return this.pos;
                }

                @Override
                public int previousIndex() {
                    return this.pos - 1;
                }

                @Override
                public void add(double k) {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    DoubleSubList.this.add(this.pos++, k);
                    this.last = -1;
                }

                @Override
                public void set(double k) {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    DoubleSubList.this.setAndReturnOld(this.last, k);
                }

                @Override
                public void remove() {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    DoubleSubList.this.removeDouble(this.last);
                    if (this.last < this.pos) {
                        --this.pos;
                    }
                    this.last = -1;
                }
            };
        }

        @Override
        public DoubleList subList(int from, int to) {
            this.ensureIndex(from);
            this.ensureIndex(to);
            if (from > to) {
                throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
            }
            return new DoubleSubList(this, from, to);
        }

        @Override
        public boolean rem(double k) {
            int index = this.indexOf(k);
            if (index == -1) {
                return false;
            }
            --this.to;
            this.l.removeDouble(this.from + index);
            return true;
        }

        @Override
        public boolean remove(Object o) {
            return this.rem((Double)o);
        }

        @Override
        public boolean addAll(int index, DoubleCollection c) {
            this.ensureIndex(index);
            this.to += c.size();
            return this.l.addAll(this.from + index, c);
        }

        @Override
        public boolean addAll(int index, DoubleList l) {
            this.ensureIndex(index);
            this.to += l.size();
            return this.l.addAll(this.from + index, l);
        }
    }
}

