/*
 * Decompiled with CFR 0.152.
 */
package stallone.doubles.fastutils;

import java.io.Serializable;
import java.util.Random;
import stallone.doubles.fastutils.Arrays;
import stallone.doubles.fastutils.DoubleComparator;
import stallone.doubles.fastutils.Hash;
import stallone.doubles.fastutils.IntArrays;

public class DoubleArrays {
    public static final long ONEOVERPHI = 106039L;
    public static final double[] EMPTY_ARRAY = new double[0];
    private static final int SMALL = 7;
    private static final int MEDIUM = 50;
    private static final int DIGIT_BITS = 8;
    private static final int DIGIT_MASK = 255;
    private static final int DIGITS_PER_ELEMENT = 8;
    public static final Hash.Strategy HASH_STRATEGY = new ArrayHashStrategy();

    private DoubleArrays() {
    }

    public static double[] ensureCapacity(double[] array, int length) {
        if (length > array.length) {
            double[] t = new double[length];
            System.arraycopy(array, 0, t, 0, array.length);
            return t;
        }
        return array;
    }

    public static double[] ensureCapacity(double[] array, int length, int preserve) {
        if (length > array.length) {
            double[] t = new double[length];
            System.arraycopy(array, 0, t, 0, preserve);
            return t;
        }
        return array;
    }

    public static double[] grow(double[] array, int length) {
        if (length > array.length) {
            int newLength = (int)Math.min(Math.max(106039L * (long)array.length >>> 16, (long)length), Integer.MAX_VALUE);
            double[] t = new double[newLength];
            System.arraycopy(array, 0, t, 0, array.length);
            return t;
        }
        return array;
    }

    public static double[] grow(double[] array, int length, int preserve) {
        if (length > array.length) {
            int newLength = (int)Math.min(Math.max(106039L * (long)array.length >>> 16, (long)length), Integer.MAX_VALUE);
            double[] t = new double[newLength];
            System.arraycopy(array, 0, t, 0, preserve);
            return t;
        }
        return array;
    }

    public static double[] trim(double[] array, int length) {
        if (length >= array.length) {
            return array;
        }
        double[] t = length == 0 ? EMPTY_ARRAY : new double[length];
        System.arraycopy(array, 0, t, 0, length);
        return t;
    }

    public static double[] setLength(double[] array, int length) {
        if (length == array.length) {
            return array;
        }
        if (length < array.length) {
            return DoubleArrays.trim(array, length);
        }
        return DoubleArrays.ensureCapacity(array, length);
    }

    public static double[] copy(double[] array, int offset, int length) {
        DoubleArrays.ensureOffsetLength(array, offset, length);
        double[] a = length == 0 ? EMPTY_ARRAY : new double[length];
        System.arraycopy(array, offset, a, 0, length);
        return a;
    }

    public static double[] copy(double[] array) {
        return (double[])array.clone();
    }

    public static void fill(double[] array, double value) {
        int i = array.length;
        while (i-- != 0) {
            array[i] = value;
        }
    }

    public static void fill(double[] array, int from, int to, double value) {
        DoubleArrays.ensureFromTo(array, from, to);
        if (from == 0) {
            while (to-- != 0) {
                array[to] = value;
            }
        } else {
            int i = from;
            while (i < to) {
                array[i] = value;
                ++i;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static boolean equals(double[] a1, double[] a2) {
        i = a1.length;
        if (i == a2.length) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            if (a1[i] == a2[i]) continue;
            return false;
lbl6:
            // 2 sources

            ** while (i-- != 0)
        }
lbl7:
        // 1 sources

        return true;
    }

    public static void ensureFromTo(double[] a, int from, int to) {
        Arrays.ensureFromTo(a.length, from, to);
    }

    public static void ensureOffsetLength(double[] a, int offset, int length) {
        Arrays.ensureOffsetLength(a.length, offset, length);
    }

    private static void swap(double[] x, int a, int b) {
        double t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void vecSwap(double[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            DoubleArrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(double[] x, int a, int b, int c, DoubleComparator comp) {
        int ab = comp.compare(x[a], x[b]);
        int ac = comp.compare(x[a], x[c]);
        int bc = comp.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static void selectionSort(double[] a, int from, int to, DoubleComparator comp) {
        int i = from;
        while (i < to - 1) {
            int m = i;
            int j = i + 1;
            while (j < to) {
                if (comp.compare(a[j], a[m]) < 0) {
                    m = j;
                }
                ++j;
            }
            if (m != i) {
                double u = a[i];
                a[i] = a[m];
                a[m] = u;
            }
            ++i;
        }
    }

    private static void insertionSort(double[] a, int from, int to, DoubleComparator comp) {
        int i = from;
        while (++i < to) {
            double t = a[i];
            int j = i;
            double u = a[j - 1];
            while (comp.compare(t, u) < 0) {
                a[j] = u;
                if (from == j - 1) {
                    --j;
                    break;
                }
                u = a[--j - 1];
            }
            a[j] = t;
        }
    }

    private static void selectionSort(double[] a, int from, int to) {
        int i = from;
        while (i < to - 1) {
            int m = i;
            int j = i + 1;
            while (j < to) {
                if (a[j] < a[m]) {
                    m = j;
                }
                ++j;
            }
            if (m != i) {
                double u = a[i];
                a[i] = a[m];
                a[m] = u;
            }
            ++i;
        }
    }

    private static void insertionSort(double[] a, int from, int to) {
        int i = from;
        while (++i < to) {
            double t = a[i];
            int j = i;
            double u = a[j - 1];
            while (t < u) {
                a[j] = u;
                if (from == j - 1) {
                    --j;
                    break;
                }
                u = a[--j - 1];
            }
            a[j] = t;
        }
    }

    public static void quickSort(double[] x, int from, int to, DoubleComparator comp) {
        int c;
        int a;
        int len = to - from;
        if (len < 7) {
            DoubleArrays.selectionSort(x, from, to, comp);
            return;
        }
        int m = from + len / 2;
        if (len > 7) {
            int l = from;
            int n = to - 1;
            if (len > 50) {
                int s = len / 8;
                l = DoubleArrays.med3(x, l, l + s, l + 2 * s, comp);
                m = DoubleArrays.med3(x, m - s, m, m + s, comp);
                n = DoubleArrays.med3(x, n - 2 * s, n - s, n, comp);
            }
            m = DoubleArrays.med3(x, l, m, n, comp);
        }
        double v = x[m];
        int b = a = from;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    DoubleArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    DoubleArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            DoubleArrays.swap(x, b++, c--);
        }
        int n = to;
        int s = Math.min(a - from, b - a);
        DoubleArrays.vecSwap(x, from, b - s, s);
        s = Math.min(d - c, n - d - 1);
        DoubleArrays.vecSwap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            DoubleArrays.quickSort(x, from, from + s, comp);
        }
        if ((s = d - c) > 1) {
            DoubleArrays.quickSort(x, n - s, n, comp);
        }
    }

    public static void quickSort(double[] x, DoubleComparator comp) {
        DoubleArrays.quickSort(x, 0, x.length, comp);
    }

    private static int med3(double[] x, int a, int b, int c) {
        int bc;
        int ac;
        int ab;
        int n = x[a] < x[b] ? -1 : (ab = x[a] == x[b] ? 0 : 1);
        int n2 = x[a] < x[c] ? -1 : (ac = x[a] == x[c] ? 0 : 1);
        int n3 = x[b] < x[c] ? -1 : (bc = x[b] == x[c] ? 0 : 1);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    public static void quickSort(double[] x, int from, int to) {
        int c;
        int a;
        int len = to - from;
        if (len < 7) {
            DoubleArrays.selectionSort(x, from, to);
            return;
        }
        int m = from + len / 2;
        if (len > 7) {
            int l = from;
            int n = to - 1;
            if (len > 50) {
                int s = len / 8;
                l = DoubleArrays.med3(x, l, l + s, l + 2 * s);
                m = DoubleArrays.med3(x, m - s, m, m + s);
                n = DoubleArrays.med3(x, n - 2 * s, n - s, n);
            }
            m = DoubleArrays.med3(x, l, m, n);
        }
        double v = x[m];
        int b = a = from;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b <= c && (x[b] < v ? -1 : (comparison = x[b] == v ? 0 : 1)) <= 0) {
                if (comparison == 0) {
                    DoubleArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (x[c] < v ? -1 : (comparison = x[c] == v ? 0 : 1)) >= 0) {
                if (comparison == 0) {
                    DoubleArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            DoubleArrays.swap(x, b++, c--);
        }
        int n = to;
        int s = Math.min(a - from, b - a);
        DoubleArrays.vecSwap(x, from, b - s, s);
        s = Math.min(d - c, n - d - 1);
        DoubleArrays.vecSwap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            DoubleArrays.quickSort(x, from, from + s);
        }
        if ((s = d - c) > 1) {
            DoubleArrays.quickSort(x, n - s, n);
        }
    }

    public static void quickSort(double[] x) {
        DoubleArrays.quickSort(x, 0, x.length);
    }

    public static void mergeSort(double[] a, int from, int to, double[] supp) {
        int len = to - from;
        if (len < 7) {
            DoubleArrays.insertionSort(a, from, to);
            return;
        }
        int mid = from + to >>> 1;
        DoubleArrays.mergeSort(supp, from, mid, a);
        DoubleArrays.mergeSort(supp, mid, to, a);
        if (supp[mid - 1] <= supp[mid]) {
            System.arraycopy(supp, from, a, from, len);
            return;
        }
        int i = from;
        int p = from;
        int q = mid;
        while (i < to) {
            a[i] = q >= to || p < mid && supp[p] <= supp[q] ? supp[p++] : supp[q++];
            ++i;
        }
    }

    public static void mergeSort(double[] a, int from, int to) {
        DoubleArrays.mergeSort(a, from, to, (double[])a.clone());
    }

    public static void mergeSort(double[] a) {
        DoubleArrays.mergeSort(a, 0, a.length);
    }

    public static void mergeSort(double[] a, int from, int to, DoubleComparator comp, double[] supp) {
        int len = to - from;
        if (len < 7) {
            DoubleArrays.insertionSort(a, from, to, comp);
            return;
        }
        int mid = from + to >>> 1;
        DoubleArrays.mergeSort(supp, from, mid, comp, a);
        DoubleArrays.mergeSort(supp, mid, to, comp, a);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from, a, from, len);
            return;
        }
        int i = from;
        int p = from;
        int q = mid;
        while (i < to) {
            a[i] = q >= to || p < mid && comp.compare(supp[p], supp[q]) <= 0 ? supp[p++] : supp[q++];
            ++i;
        }
    }

    public static void mergeSort(double[] a, int from, int to, DoubleComparator comp) {
        DoubleArrays.mergeSort(a, from, to, comp, (double[])a.clone());
    }

    public static void mergeSort(double[] a, DoubleComparator comp) {
        DoubleArrays.mergeSort(a, 0, a.length, comp);
    }

    public static int binarySearch(double[] a, int from, int to, double key) {
        --to;
        while (from <= to) {
            int mid = from + to >>> 1;
            double midVal = a[mid];
            if (midVal < key) {
                from = mid + 1;
                continue;
            }
            if (midVal > key) {
                to = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from + 1);
    }

    public static int binarySearch(double[] a, double key) {
        return DoubleArrays.binarySearch(a, 0, a.length, key);
    }

    public static int binarySearch(double[] a, int from, int to, double key, DoubleComparator c) {
        --to;
        while (from <= to) {
            int mid = from + to >>> 1;
            double midVal = a[mid];
            int cmp = c.compare(midVal, key);
            if (cmp < 0) {
                from = mid + 1;
                continue;
            }
            if (cmp > 0) {
                to = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from + 1);
    }

    public static int binarySearch(double[] a, double key, DoubleComparator c) {
        return DoubleArrays.binarySearch(a, 0, a.length, key, c);
    }

    private static final long fixDouble(double d) {
        long l = Double.doubleToRawLongBits(d);
        return l >= 0L ? l : l ^ Long.MAX_VALUE;
    }

    public static void radixSort(double[] a) {
        DoubleArrays.radixSort(a, 0, a.length);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public static void radixSort(double[] a, int from, int to) {
        int maxLevel = 7;
        int stackSize = 1786;
        int[] offsetStack = new int[1786];
        int offsetPos = 0;
        int[] lengthStack = new int[1786];
        int lengthPos = 0;
        int[] levelStack = new int[1786];
        int levelPos = 0;
        offsetStack[offsetPos++] = from;
        lengthStack[lengthPos++] = to - from;
        levelStack[levelPos++] = 0;
        int[] count = new int[256];
        int[] pos = new int[256];
        byte[] digit = new byte[to - from];
        while (offsetPos > 0) {
            int level;
            int signMask;
            int first = offsetStack[--offsetPos];
            int length = lengthStack[--lengthPos];
            int n = signMask = (level = levelStack[--levelPos]) % 8 == 0 ? 128 : 0;
            if (length < 50) {
                DoubleArrays.selectionSort(a, first, first + length);
                continue;
            }
            int shift = (7 - level % 8) * 8;
            int i = length;
            while (i-- != 0) {
                digit[i] = (byte)(DoubleArrays.fixDouble(a[first + i]) >>> shift & 0xFFL ^ (long)signMask);
            }
            i = length;
            while (i-- != 0) {
                int n2 = digit[i] & 0xFF;
                count[n2] = count[n2] + 1;
            }
            int lastUsed = -1;
            int i2 = 0;
            int p = 0;
            while (i2 < 256) {
                if (count[i2] != 0) {
                    lastUsed = i2;
                    if (level < 7 && count[i2] > 1) {
                        offsetStack[offsetPos++] = p + first;
                        lengthStack[lengthPos++] = count[i2];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                pos[i2] = p += count[i2];
                ++i2;
            }
            int end = length - count[lastUsed];
            count[lastUsed] = 0;
            int i3 = 0;
            int c = -1;
            while (i3 < end) {
                double t;
                block11: {
                    int d;
                    int n3;
                    int n4;
                    block10: {
                        t = a[i3 + first];
                        c = digit[i3] & 0xFF;
                        if (!true) break block10;
                        n4 = c;
                        n3 = pos[n4] - 1;
                        pos[n4] = n3;
                        d = n3;
                        if (n3 <= i3) break block11;
                    }
                    do {
                        double z = t;
                        int zz = c;
                        t = a[d + first];
                        c = digit[d] & 0xFF;
                        a[d + first] = z;
                        digit[d] = (byte)zz;
                        n4 = c;
                        n3 = pos[n4] - 1;
                        pos[n4] = n3;
                        d = n3;
                    } while (n3 > i3);
                }
                a[i3 + first] = t;
                i3 += count[c];
                count[c] = 0;
            }
        }
    }

    private static void insertionSortIndirect(int[] perm, double[] a, int from, int to) {
        int i = from;
        while (++i < to) {
            int t = perm[i];
            int j = i;
            int u = perm[j - 1];
            while (a[t] < a[u]) {
                perm[j] = u;
                if (from == j - 1) {
                    --j;
                    break;
                }
                u = perm[--j - 1];
            }
            perm[j] = t;
        }
    }

    public static void radixSortIndirect(int[] perm, double[] a, boolean stable) {
        DoubleArrays.radixSortIndirect(perm, a, 0, perm.length, stable);
    }

    /*
     * Unable to fully structure code
     */
    public static void radixSortIndirect(int[] perm, double[] a, int from, int to, boolean stable) {
        maxLevel = 7;
        stackSize = 1786;
        offsetStack = new int[1786];
        offsetPos = 0;
        lengthStack = new int[1786];
        lengthPos = 0;
        levelStack = new int[1786];
        levelPos = 0;
        offsetStack[offsetPos++] = from;
        lengthStack[lengthPos++] = to - from;
        levelStack[levelPos++] = 0;
        count = new int[256];
        pos = stable != false ? null : new int[256];
        support = stable != false ? new int[perm.length] : null;
        digit = new byte[to - from];
        while (offsetPos > 0) {
            first = offsetStack[--offsetPos];
            length = lengthStack[--lengthPos];
            v0 = signMask = (level = levelStack[--levelPos]) % 8 == 0 ? 128 : 0;
            if (length < 50) {
                DoubleArrays.insertionSortIndirect(perm, a, first, first + length);
                continue;
            }
            shift = (7 - level % 8) * 8;
            i = length;
            while (i-- != 0) {
                digit[i] = (byte)(DoubleArrays.fixDouble(a[perm[first + i]]) >>> shift & 255L ^ (long)signMask);
            }
            i = length;
            while (i-- != 0) {
                v1 = digit[i] & 255;
                count[v1] = count[v1] + 1;
            }
            lastUsed = -1;
            i = 0;
            p = 0;
            while (i < 256) {
                if (count[i] != 0) {
                    lastUsed = i;
                    if (level < 7 && count[i] > 1) {
                        offsetStack[offsetPos++] = p + first;
                        lengthStack[lengthPos++] = count[i];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                if (stable) {
                    count[i] = p += count[i];
                } else {
                    pos[i] = p += count[i];
                }
                ++i;
            }
            if (stable) {
                i = length;
                while (i-- != 0) {
                    v2 = digit[i] & 255;
                    v3 = count[v2] - 1;
                    count[v2] = v3;
                    support[v3] = perm[first + i];
                }
                System.arraycopy(support, 0, perm, first, length);
                IntArrays.fill(count, 0);
                continue;
            }
            end = length - count[lastUsed];
            count[lastUsed] = 0;
            i = 0;
            c = -1;
            while (i < end) {
                t = perm[i + first];
                c = digit[i] & 255;
                if (true) ** GOTO lbl75
                do {
                    z = t;
                    zz = c;
                    t = perm[d + first];
                    c = digit[d] & 255;
                    perm[d + first] = z;
                    digit[d] = (byte)zz;
lbl75:
                    // 2 sources

                    v4 = c;
                    v5 = pos[v4] - 1;
                    pos[v4] = v5;
                    d = v5;
                } while (v5 > i);
                perm[i + first] = t;
                i += count[c];
                count[c] = 0;
            }
        }
    }

    private static void selectionSort(double[] a, double[] b, int from, int to) {
        int i = from;
        while (i < to - 1) {
            int m = i;
            int j = i + 1;
            while (j < to) {
                if (a[j] < a[m] || a[j] == a[m] && b[j] < b[m]) {
                    m = j;
                }
                ++j;
            }
            if (m != i) {
                double t = a[i];
                a[i] = a[m];
                a[m] = t;
                t = b[i];
                b[i] = b[m];
                b[m] = t;
            }
            ++i;
        }
    }

    public static void radixSort(double[] a, double[] b) {
        DoubleArrays.radixSort(a, b, 0, a.length);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public static void radixSort(double[] a, double[] b, int from, int to) {
        int layers = 2;
        if (a.length != b.length) {
            throw new IllegalArgumentException("Array size mismatch.");
        }
        int maxLevel = 15;
        int stackSize = 3826;
        int[] offsetStack = new int[3826];
        int offsetPos = 0;
        int[] lengthStack = new int[3826];
        int lengthPos = 0;
        int[] levelStack = new int[3826];
        int levelPos = 0;
        offsetStack[offsetPos++] = from;
        lengthStack[lengthPos++] = to - from;
        levelStack[levelPos++] = 0;
        int[] count = new int[256];
        int[] pos = new int[256];
        byte[] digit = new byte[to - from];
        while (offsetPos > 0) {
            int level;
            int signMask;
            int first = offsetStack[--offsetPos];
            int length = lengthStack[--lengthPos];
            int n = signMask = (level = levelStack[--levelPos]) % 8 == 0 ? 128 : 0;
            if (length < 50) {
                DoubleArrays.selectionSort(a, b, first, first + length);
                continue;
            }
            double[] k = level < 8 ? a : b;
            int shift = (7 - level % 8) * 8;
            int i = length;
            while (i-- != 0) {
                digit[i] = (byte)(DoubleArrays.fixDouble(k[first + i]) >>> shift & 0xFFL ^ (long)signMask);
            }
            i = length;
            while (i-- != 0) {
                int n2 = digit[i] & 0xFF;
                count[n2] = count[n2] + 1;
            }
            int lastUsed = -1;
            int i2 = 0;
            int p = 0;
            while (i2 < 256) {
                if (count[i2] != 0) {
                    lastUsed = i2;
                    if (level < 15 && count[i2] > 1) {
                        offsetStack[offsetPos++] = p + first;
                        lengthStack[lengthPos++] = count[i2];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                pos[i2] = p += count[i2];
                ++i2;
            }
            int end = length - count[lastUsed];
            count[lastUsed] = 0;
            int i3 = 0;
            int c = -1;
            while (i3 < end) {
                double u;
                double t;
                block12: {
                    int d;
                    int n3;
                    int n4;
                    block11: {
                        t = a[i3 + first];
                        u = b[i3 + first];
                        c = digit[i3] & 0xFF;
                        if (!true) break block11;
                        n4 = c;
                        n3 = pos[n4] - 1;
                        pos[n4] = n3;
                        d = n3;
                        if (n3 <= i3) break block12;
                    }
                    do {
                        double z = t;
                        int zz = c;
                        t = a[d + first];
                        a[d + first] = z;
                        z = u;
                        u = b[d + first];
                        b[d + first] = z;
                        c = digit[d] & 0xFF;
                        digit[d] = (byte)zz;
                        n4 = c;
                        n3 = pos[n4] - 1;
                        pos[n4] = n3;
                        d = n3;
                    } while (n3 > i3);
                }
                a[i3 + first] = t;
                b[i3 + first] = u;
                i3 += count[c];
                count[c] = 0;
            }
        }
    }

    private static void insertionSortIndirect(int[] perm, double[] a, double[] b, int from, int to) {
        int i = from;
        while (++i < to) {
            int t = perm[i];
            int j = i;
            int u = perm[j - 1];
            while (a[t] < a[u] || a[t] == a[u] && b[t] < b[u]) {
                perm[j] = u;
                if (from == j - 1) {
                    --j;
                    break;
                }
                u = perm[--j - 1];
            }
            perm[j] = t;
        }
    }

    public static void radixSortIndirect(int[] perm, double[] a, double[] b, boolean stable) {
        DoubleArrays.radixSortIndirect(perm, a, b, 0, perm.length, stable);
    }

    /*
     * Unable to fully structure code
     */
    public static void radixSortIndirect(int[] perm, double[] a, double[] b, int from, int to, boolean stable) {
        layers = 2;
        if (a.length != b.length) {
            throw new IllegalArgumentException("Array size mismatch.");
        }
        maxLevel = 15;
        stackSize = 3826;
        offsetStack = new int[3826];
        offsetPos = 0;
        lengthStack = new int[3826];
        lengthPos = 0;
        levelStack = new int[3826];
        levelPos = 0;
        offsetStack[offsetPos++] = from;
        lengthStack[lengthPos++] = to - from;
        levelStack[levelPos++] = 0;
        count = new int[256];
        pos = stable != false ? null : new int[256];
        support = stable != false ? new int[perm.length] : null;
        digit = new byte[to - from];
        while (offsetPos > 0) {
            first = offsetStack[--offsetPos];
            length = lengthStack[--lengthPos];
            v0 = signMask = (level = levelStack[--levelPos]) % 8 == 0 ? 128 : 0;
            if (length < 50) {
                DoubleArrays.insertionSortIndirect(perm, a, b, first, first + length);
                continue;
            }
            k = level < 8 ? a : b;
            shift = (7 - level % 8) * 8;
            i = length;
            while (i-- != 0) {
                digit[i] = (byte)(DoubleArrays.fixDouble(k[perm[first + i]]) >>> shift & 255L ^ (long)signMask);
            }
            i = length;
            while (i-- != 0) {
                v1 = digit[i] & 255;
                count[v1] = count[v1] + 1;
            }
            lastUsed = -1;
            i = 0;
            p = 0;
            while (i < 256) {
                if (count[i] != 0) {
                    lastUsed = i;
                    if (level < 15 && count[i] > 1) {
                        offsetStack[offsetPos++] = p + first;
                        lengthStack[lengthPos++] = count[i];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                if (stable) {
                    count[i] = p += count[i];
                } else {
                    pos[i] = p += count[i];
                }
                ++i;
            }
            if (stable) {
                i = length;
                while (i-- != 0) {
                    v2 = digit[i] & 255;
                    v3 = count[v2] - 1;
                    count[v2] = v3;
                    support[v3] = perm[first + i];
                }
                System.arraycopy(support, 0, perm, first, length);
                IntArrays.fill(count, 0);
                continue;
            }
            end = length - count[lastUsed];
            count[lastUsed] = 0;
            i = 0;
            c = -1;
            while (i < end) {
                t = perm[i + first];
                c = digit[i] & 255;
                if (true) ** GOTO lbl79
                do {
                    z = t;
                    zz = c;
                    t = perm[d + first];
                    c = digit[d] & 255;
                    perm[d + first] = z;
                    digit[d] = (byte)zz;
lbl79:
                    // 2 sources

                    v4 = c;
                    v5 = pos[v4] - 1;
                    pos[v4] = v5;
                    d = v5;
                } while (v5 > i);
                perm[i + first] = t;
                i += count[c];
                count[c] = 0;
            }
        }
    }

    private static void selectionSort(double[][] a, int from, int to, int level) {
        int layers = a.length;
        int firstLayer = level / 8;
        int i = from;
        while (i < to - 1) {
            int m = i;
            int j = i + 1;
            while (j < to) {
                int p = firstLayer;
                while (p < layers) {
                    if (a[p][j] < a[p][m]) {
                        m = j;
                        break;
                    }
                    if (a[p][j] > a[p][m]) break;
                    ++p;
                }
                ++j;
            }
            if (m != i) {
                int p = layers;
                while (p-- != 0) {
                    double u = a[p][i];
                    a[p][i] = a[p][m];
                    a[p][m] = u;
                }
            }
            ++i;
        }
    }

    public static void radixSort(double[][] a) {
        DoubleArrays.radixSort(a, 0, a[0].length);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public static void radixSort(double[][] a, int from, int to) {
        int layers = a.length;
        int maxLevel = 8 * layers - 1;
        int p = layers;
        int l = a[0].length;
        while (p-- != 0) {
            if (a[p].length == l) continue;
            throw new IllegalArgumentException("The array of index " + p + " has not the same length of the array of index 0.");
        }
        int stackSize = 255 * (layers * 8 - 1) + 1;
        int[] offsetStack = new int[stackSize];
        int offsetPos = 0;
        int[] lengthStack = new int[stackSize];
        int lengthPos = 0;
        int[] levelStack = new int[stackSize];
        int levelPos = 0;
        offsetStack[offsetPos++] = from;
        lengthStack[lengthPos++] = to - from;
        levelStack[levelPos++] = 0;
        int[] count = new int[256];
        int[] pos = new int[256];
        byte[] digit = new byte[to - from];
        double[] t = new double[layers];
        while (offsetPos > 0) {
            int level;
            int signMask;
            int first = offsetStack[--offsetPos];
            int length = lengthStack[--lengthPos];
            int n = signMask = (level = levelStack[--levelPos]) % 8 == 0 ? 128 : 0;
            if (length < 50) {
                DoubleArrays.selectionSort(a, first, first + length, level);
                continue;
            }
            double[] k = a[level / 8];
            int shift = (7 - level % 8) * 8;
            int i = length;
            while (i-- != 0) {
                digit[i] = (byte)(DoubleArrays.fixDouble(k[first + i]) >>> shift & 0xFFL ^ (long)signMask);
            }
            i = length;
            while (i-- != 0) {
                int n2 = digit[i] & 0xFF;
                count[n2] = count[n2] + 1;
            }
            int lastUsed = -1;
            int i2 = 0;
            int p2 = 0;
            while (i2 < 256) {
                if (count[i2] != 0) {
                    lastUsed = i2;
                    if (level < maxLevel && count[i2] > 1) {
                        offsetStack[offsetPos++] = p2 + first;
                        lengthStack[lengthPos++] = count[i2];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                pos[i2] = p2 += count[i2];
                ++i2;
            }
            int end = length - count[lastUsed];
            count[lastUsed] = 0;
            int i3 = 0;
            int c = -1;
            while (i3 < end) {
                int p3;
                block15: {
                    int d;
                    int n3;
                    int n4;
                    block14: {
                        p3 = layers;
                        while (p3-- != 0) {
                            t[p3] = a[p3][i3 + first];
                        }
                        c = digit[i3] & 0xFF;
                        if (!true) break block14;
                        n4 = c;
                        n3 = pos[n4] - 1;
                        pos[n4] = n3;
                        d = n3;
                        if (n3 <= i3) break block15;
                    }
                    do {
                        p3 = layers;
                        while (p3-- != 0) {
                            double u = t[p3];
                            t[p3] = a[p3][d + first];
                            a[p3][d + first] = u;
                        }
                        int zz = c;
                        c = digit[d] & 0xFF;
                        digit[d] = (byte)zz;
                        n4 = c;
                        n3 = pos[n4] - 1;
                        pos[n4] = n3;
                        d = n3;
                    } while (n3 > i3);
                }
                p3 = layers;
                while (p3-- != 0) {
                    a[p3][i3 + first] = t[p3];
                }
                i3 += count[c];
                count[c] = 0;
            }
        }
    }

    public static double[] shuffle(double[] a, int from, int to, Random random) {
        int i = to - from;
        while (i-- != 0) {
            int p = random.nextInt(i + 1);
            double t = a[from + i];
            a[from + i] = a[from + p];
            a[from + p] = t;
        }
        return a;
    }

    public static double[] shuffle(double[] a, Random random) {
        int i = a.length;
        while (i-- != 0) {
            int p = random.nextInt(i + 1);
            double t = a[i];
            a[i] = a[p];
            a[p] = t;
        }
        return a;
    }

    public static double[] reverse(double[] a) {
        int length = a.length;
        int i = length / 2;
        while (i-- != 0) {
            double t = a[length - i - 1];
            a[length - i - 1] = a[i];
            a[i] = t;
        }
        return a;
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy<double[]>,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;

        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(double[] o) {
            return java.util.Arrays.hashCode(o);
        }

        @Override
        public boolean equals(double[] a, double[] b) {
            return DoubleArrays.equals(a, b);
        }
    }
}

