/*
 * Decompiled with CFR 0.152.
 */
package stallone.doubles.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.regex.Pattern;
import stallone.api.doubles.Doubles;
import stallone.api.doubles.IDoubleArray;
import stallone.doubles.io.AbstractAsciiMatrixReader;

public class DenseDoubleArrayAsciiReader
extends AbstractAsciiMatrixReader {
    private Pattern denseHeader = Pattern.compile("DENSE\\s+[0-9]+\\s+[0-9]+\\s*");

    public DenseDoubleArrayAsciiReader(String filename) throws FileNotFoundException, IOException {
        super(filename);
    }

    @Override
    public boolean checkHeader() {
        return this.denseHeader.matcher(this.getLine(0)).matches();
    }

    @Override
    protected void readToMatrix() {
        String[] elements;
        int numberOfRows = 0;
        int numberOfColumns = 0;
        String headerLine = this.getLine(0);
        if (this.denseHeader.matcher(headerLine).matches()) {
            elements = whiteSpacePattern.split(headerLine);
            if (elements.length != 3) {
                throw new RuntimeException("Invalid header for dense matrix, should be 'DENSE <rows> <columns>'.");
            }
        } else {
            throw new RuntimeException("Invalid header found.");
        }
        numberOfRows = Integer.parseInt(elements[1]);
        numberOfColumns = Integer.parseInt(elements[2]);
        this.m = Doubles.create.array(numberOfRows, numberOfColumns);
        int currentMatrixRow = 0;
        int i = this.getDataStart();
        int n = this.getDataEnd();
        while (i < n) {
            String currentLine = this.getLine(i);
            if (currentMatrixRow >= this.m.rows()) {
                throw new RuntimeException("Too many matrix rows in file. Expected: " + numberOfRows + ".");
            }
            String[] elements2 = whiteSpacePattern.split(currentLine);
            int rowLength = elements2.length;
            if (rowLength == this.m.columns()) {
                IDoubleArray row = this.m.viewRow(currentMatrixRow);
                int j = 0;
                while (j < rowLength) {
                    double value = Double.parseDouble(elements2[j]);
                    row.set(j, value);
                    ++j;
                }
            } else {
                throw new RuntimeException("Too many or too few entries for matrix in line " + i + " of file.");
            }
            ++currentMatrixRow;
            ++i;
        }
        if (currentMatrixRow < this.m.rows()) {
            throw new RuntimeException("Matrix row(s) missing.");
        }
        System.out.println("Dense matrix with dimension ( " + numberOfRows + " x " + numberOfColumns + " ) " + "read successfully from file '" + this.filename + "'.");
    }
}

