/*
 * Decompiled with CFR 0.152.
 */
package stallone.function;

import java.util.ArrayList;
import org.nfunk.jep.JEP;
import org.nfunk.jep.SymbolTable;
import stallone.api.doubles.IDoubleArray;
import stallone.api.function.IFunction;

public class JEPFunction
implements IFunction {
    protected JEP jep = new JEP();
    protected String[] variables;

    public JEPFunction(String[] _variables, String _expression) {
        this.jep.addStandardFunctions();
        this.jep.addStandardConstants();
        if (_variables == null) {
            this.jep.setAllowUndeclared(true);
            this.jep.parseExpression(_expression);
            ArrayList<String> var = new ArrayList<String>();
            SymbolTable tab = this.jep.getSymbolTable();
            if (tab.get("x") != null) {
                var.add("x");
            }
            int i = 0;
            while (i < 10) {
                if (tab.get("x" + i) != null) {
                    var.add("x" + i);
                }
                ++i;
            }
            if (tab.get("y") != null) {
                var.add("y");
            }
            i = 0;
            while (i < 10) {
                if (tab.get("y" + i) != null) {
                    var.add("y" + i);
                }
                ++i;
            }
            if (tab.get("z") != null) {
                var.add("z");
            }
            i = 0;
            while (i < 10) {
                if (tab.get("z" + i) != null) {
                    var.add("z" + i);
                }
                ++i;
            }
            this.variables = new String[var.size()];
            var.toArray(this.variables);
        } else {
            this.variables = _variables;
            String[] stringArray = _variables;
            int n = _variables.length;
            int n2 = 0;
            while (n2 < n) {
                String var = stringArray[n2];
                this.jep.addVariable(var, 0.0);
                ++n2;
            }
            this.jep.parseExpression(_expression);
        }
    }

    public JEPFunction(String _expression) {
        this(null, _expression);
    }

    @Override
    public int getNumberOfVariables() {
        return this.variables.length;
    }

    @Override
    public double f(double ... x) {
        if (x.length != this.variables.length) {
            throw new IllegalArgumentException("Wrong number of variables: expecting " + this.variables.length + " but got " + x.length);
        }
        int i = 0;
        while (i < this.variables.length) {
            this.jep.addVariable(this.variables[i], x[i]);
            ++i;
        }
        return this.jep.getValue();
    }

    @Override
    public double f(IDoubleArray x) {
        return this.f(x.getArray());
    }
}

