/*
 * Decompiled with CFR 0.152.
 */
package stallone.graph;

import java.util.ArrayList;
import java.util.Iterator;
import stallone.api.API;
import stallone.api.doubles.IDoubleArray;
import stallone.api.doubles.IDoubleIterator;
import stallone.api.graph.IIntEdge;
import stallone.api.graph.IIntGraph;
import stallone.api.ints.IIntArray;
import stallone.api.ints.IIntIterator;
import stallone.api.ints.IIntList;
import stallone.api.ints.Ints;
import stallone.graph.IntEdge;
import stallone.ints.IntArrayIterator;
import stallone.ints.PrimitiveIntTools;

public class ListIntGraph
implements IIntGraph {
    private IIntList[] neighbors;

    public ListIntGraph(int nNodes) {
        this.neighbors = new IIntList[nNodes];
        int i = 0;
        while (i < this.neighbors.length) {
            this.neighbors[i] = API.intsNew.list(5);
            ++i;
        }
    }

    public ListIntGraph(IDoubleArray matrix) {
        this(matrix.rows());
        IDoubleIterator it = matrix.nonzeroIterator();
        while (it.hasNext()) {
            this.addEdge(it.row(), it.column());
        }
    }

    public ListIntGraph(int[][] edges) {
        this(PrimitiveIntTools.max(PrimitiveIntTools.flatten(edges)) + 1);
        int[][] nArray = edges;
        int n = edges.length;
        int n2 = 0;
        while (n2 < n) {
            int[] e = nArray[n2];
            this.addEdge(e[0], e[1]);
            ++n2;
        }
    }

    private void addEdge(int i, int j) {
        if (!API.ints.contains(this.neighbors[i], j)) {
            this.neighbors[i].append(j);
        }
    }

    @Override
    public boolean contains(int vertex) {
        return vertex >= 0 && vertex < this.neighbors.length;
    }

    @Override
    public boolean contains(int vertex1, int vertex2) {
        return API.ints.contains(this.neighbors[vertex1], vertex2);
    }

    @Override
    public IIntIterator nodeIterator() {
        IntArrayIterator it = new IntArrayIterator(Ints.create.arrayRange(this.neighbors.length));
        return it;
    }

    @Override
    public IIntIterator neighborIterator(int node) {
        return this.neighbors[node].iterator();
    }

    @Override
    public Iterator<IIntEdge> edgeIterator() {
        ArrayList<IntEdge> edges = new ArrayList<IntEdge>();
        int i = 0;
        while (i < this.neighbors.length) {
            int j = 0;
            while (j < this.neighbors[i].size()) {
                edges.add(new IntEdge(i, this.neighbors[i].get(j)));
                ++j;
            }
            ++i;
        }
        return edges.iterator();
    }

    @Override
    public int numberOfNodes() {
        return this.neighbors.length;
    }

    @Override
    public int numberOfArcs() {
        int n = 0;
        int i = 0;
        while (i < this.neighbors.length) {
            n += this.neighbors[i].size();
            ++i;
        }
        return n;
    }

    @Override
    public IIntArray getNodes() {
        return Ints.create.arrayRange(this.neighbors.length);
    }

    @Override
    public IIntArray getNeighbors(int i) {
        return this.neighbors[i];
    }
}

